/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.Iterator;
import org.apache.flink.runtime.checkpoint.AbstractCheckpointStats;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CheckpointStatsHistory;
import org.apache.flink.runtime.checkpoint.CheckpointStatsStatus;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStats;
import org.apache.flink.runtime.checkpoint.FailedCheckpointStats;
import org.apache.flink.runtime.checkpoint.PendingCheckpointStats;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class CheckpointStatsHistoryTest {
    @Test
    public void testZeroMaxSizeHistory() throws Exception {
        CheckpointStatsHistory history = new CheckpointStatsHistory(0);
        history.addInProgressCheckpoint(this.createPendingCheckpointStats(0L));
        Assert.assertFalse((boolean)history.replacePendingCheckpointById((AbstractCheckpointStats)this.createCompletedCheckpointStats(0L)));
        CheckpointStatsHistory snapshot = history.createSnapshot();
        int counter = 0;
        for (AbstractCheckpointStats ignored : snapshot.getCheckpoints()) {
            ++counter;
        }
        Assert.assertEquals((long)0L, (long)counter);
        Assert.assertNotNull((Object)snapshot.getCheckpointById(0L));
    }

    @Test
    public void testSizeOneHistory() throws Exception {
        CheckpointStatsHistory history = new CheckpointStatsHistory(1);
        history.addInProgressCheckpoint(this.createPendingCheckpointStats(0L));
        history.addInProgressCheckpoint(this.createPendingCheckpointStats(1L));
        Assert.assertFalse((boolean)history.replacePendingCheckpointById((AbstractCheckpointStats)this.createCompletedCheckpointStats(0L)));
        Assert.assertTrue((boolean)history.replacePendingCheckpointById((AbstractCheckpointStats)this.createCompletedCheckpointStats(1L)));
        CheckpointStatsHistory snapshot = history.createSnapshot();
        for (AbstractCheckpointStats stats : snapshot.getCheckpoints()) {
            Assert.assertEquals((long)1L, (long)stats.getCheckpointId());
            Assert.assertTrue((boolean)stats.getStatus().isCompleted());
        }
    }

    @Test
    public void testCheckpointHistory() throws Exception {
        CheckpointStatsHistory history = new CheckpointStatsHistory(3);
        history.addInProgressCheckpoint(this.createPendingCheckpointStats(0L));
        CheckpointStatsHistory snapshot = history.createSnapshot();
        for (AbstractCheckpointStats stats : snapshot.getCheckpoints()) {
            Assert.assertEquals((long)0L, (long)stats.getCheckpointId());
            Assert.assertTrue((boolean)stats.getStatus().isInProgress());
        }
        history.addInProgressCheckpoint(this.createPendingCheckpointStats(1L));
        history.addInProgressCheckpoint(this.createPendingCheckpointStats(2L));
        history.addInProgressCheckpoint(this.createPendingCheckpointStats(3L));
        snapshot = history.createSnapshot();
        Iterator it = snapshot.getCheckpoints().iterator();
        for (int i = 3; i > 0; --i) {
            Assert.assertTrue((boolean)it.hasNext());
            AbstractCheckpointStats stats = (AbstractCheckpointStats)it.next();
            Assert.assertEquals((long)i, (long)stats.getCheckpointId());
            Assert.assertTrue((boolean)stats.getStatus().isInProgress());
        }
        Assert.assertFalse((boolean)it.hasNext());
        history.replacePendingCheckpointById((AbstractCheckpointStats)this.createFailedCheckpointStats(1L));
        history.replacePendingCheckpointById((AbstractCheckpointStats)this.createCompletedCheckpointStats(3L));
        history.replacePendingCheckpointById((AbstractCheckpointStats)this.createFailedCheckpointStats(2L));
        snapshot = history.createSnapshot();
        it = snapshot.getCheckpoints().iterator();
        Assert.assertTrue((boolean)it.hasNext());
        AbstractCheckpointStats stats = (AbstractCheckpointStats)it.next();
        Assert.assertEquals((long)3L, (long)stats.getCheckpointId());
        Assert.assertNotNull((Object)snapshot.getCheckpointById(3L));
        Assert.assertTrue((boolean)stats.getStatus().isCompleted());
        Assert.assertTrue((boolean)snapshot.getCheckpointById(3L).getStatus().isCompleted());
        Assert.assertTrue((boolean)it.hasNext());
        stats = (AbstractCheckpointStats)it.next();
        Assert.assertEquals((long)2L, (long)stats.getCheckpointId());
        Assert.assertNotNull((Object)snapshot.getCheckpointById(2L));
        Assert.assertTrue((boolean)stats.getStatus().isFailed());
        Assert.assertTrue((boolean)snapshot.getCheckpointById(2L).getStatus().isFailed());
        Assert.assertTrue((boolean)it.hasNext());
        stats = (AbstractCheckpointStats)it.next();
        Assert.assertEquals((long)1L, (long)stats.getCheckpointId());
        Assert.assertNotNull((Object)snapshot.getCheckpointById(1L));
        Assert.assertTrue((boolean)stats.getStatus().isFailed());
        Assert.assertTrue((boolean)snapshot.getCheckpointById(1L).getStatus().isFailed());
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testModifySnapshot() throws Exception {
        CheckpointStatsHistory history = new CheckpointStatsHistory(3);
        history.addInProgressCheckpoint(this.createPendingCheckpointStats(0L));
        history.addInProgressCheckpoint(this.createPendingCheckpointStats(1L));
        history.addInProgressCheckpoint(this.createPendingCheckpointStats(2L));
        CheckpointStatsHistory snapshot = history.createSnapshot();
        try {
            snapshot.addInProgressCheckpoint(this.createPendingCheckpointStats(4L));
            Assert.fail((String)"Did not throw expected Exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            snapshot.replacePendingCheckpointById((AbstractCheckpointStats)this.createCompletedCheckpointStats(2L));
            Assert.fail((String)"Did not throw expected Exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            snapshot.createSnapshot();
            Assert.fail((String)"Did not throw expected Exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private PendingCheckpointStats createPendingCheckpointStats(long checkpointId) {
        PendingCheckpointStats pending = (PendingCheckpointStats)Mockito.mock(PendingCheckpointStats.class);
        Mockito.when((Object)pending.getStatus()).thenReturn((Object)CheckpointStatsStatus.IN_PROGRESS);
        Mockito.when((Object)pending.getCheckpointId()).thenReturn((Object)checkpointId);
        Mockito.when((Object)pending.getProperties()).thenReturn((Object)CheckpointProperties.forStandardCheckpoint());
        return pending;
    }

    private CompletedCheckpointStats createCompletedCheckpointStats(long checkpointId) {
        CompletedCheckpointStats completed = (CompletedCheckpointStats)Mockito.mock(CompletedCheckpointStats.class);
        Mockito.when((Object)completed.getStatus()).thenReturn((Object)CheckpointStatsStatus.COMPLETED);
        Mockito.when((Object)completed.getProperties()).thenReturn((Object)CheckpointProperties.forStandardCheckpoint());
        Mockito.when((Object)completed.getCheckpointId()).thenReturn((Object)checkpointId);
        Mockito.when((Object)completed.getProperties()).thenReturn((Object)CheckpointProperties.forStandardCheckpoint());
        return completed;
    }

    private FailedCheckpointStats createFailedCheckpointStats(long checkpointId) {
        FailedCheckpointStats failed = (FailedCheckpointStats)Mockito.mock(FailedCheckpointStats.class);
        Mockito.when((Object)failed.getStatus()).thenReturn((Object)CheckpointStatsStatus.FAILED);
        Mockito.when((Object)failed.getProperties()).thenReturn((Object)CheckpointProperties.forStandardCheckpoint());
        Mockito.when((Object)failed.getCheckpointId()).thenReturn((Object)checkpointId);
        return failed;
    }
}

