/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.hooks;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.runtime.checkpoint.MasterTriggerRestoreHook;
import org.apache.flink.runtime.checkpoint.hooks.MasterHooks;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class MasterHooksTest
extends TestLogger {
    @Test
    public void wrapHook() throws Exception {
        String id = "id";
        Thread thread = Thread.currentThread();
        ClassLoader originalClassLoader = thread.getContextClassLoader();
        final URLClassLoader userClassLoader = new URLClassLoader(new URL[0]);
        final Runnable command = (Runnable)Mockito.spy((Object)new Runnable(){

            @Override
            public void run() {
                Assert.assertEquals((Object)userClassLoader, (Object)Thread.currentThread().getContextClassLoader());
            }
        });
        MasterTriggerRestoreHook hook = (MasterTriggerRestoreHook)Mockito.spy((Object)new MasterTriggerRestoreHook<String>(){

            public String getIdentifier() {
                Assert.assertEquals((Object)userClassLoader, (Object)Thread.currentThread().getContextClassLoader());
                return "id";
            }

            @Nullable
            public CompletableFuture<String> triggerCheckpoint(long checkpointId, long timestamp, Executor executor) throws Exception {
                Assert.assertEquals((Object)userClassLoader, (Object)Thread.currentThread().getContextClassLoader());
                executor.execute(command);
                return null;
            }

            public void restoreCheckpoint(long checkpointId, @Nullable String checkpointData) throws Exception {
                Assert.assertEquals((Object)userClassLoader, (Object)Thread.currentThread().getContextClassLoader());
            }

            @Nullable
            public SimpleVersionedSerializer<String> createCheckpointDataSerializer() {
                Assert.assertEquals((Object)userClassLoader, (Object)Thread.currentThread().getContextClassLoader());
                return null;
            }
        });
        MasterTriggerRestoreHook wrapped = MasterHooks.wrapHook((MasterTriggerRestoreHook)hook, (ClassLoader)userClassLoader);
        wrapped.getIdentifier();
        ((MasterTriggerRestoreHook)Mockito.verify((Object)hook, (VerificationMode)Mockito.times((int)1))).getIdentifier();
        Assert.assertEquals((Object)originalClassLoader, (Object)thread.getContextClassLoader());
        TestExecutor testExecutor = new TestExecutor();
        wrapped.triggerCheckpoint(0L, 0L, (Executor)testExecutor);
        Assert.assertEquals((Object)originalClassLoader, (Object)thread.getContextClassLoader());
        Assert.assertNotNull((Object)testExecutor.command);
        testExecutor.command.run();
        ((Runnable)Mockito.verify((Object)command, (VerificationMode)Mockito.times((int)1))).run();
        Assert.assertEquals((Object)originalClassLoader, (Object)thread.getContextClassLoader());
        wrapped.restoreCheckpoint(0L, (Object)"");
        ((MasterTriggerRestoreHook)Mockito.verify((Object)hook, (VerificationMode)Mockito.times((int)1))).restoreCheckpoint(Matchers.eq((long)0L), Matchers.eq((Object)""));
        Assert.assertEquals((Object)originalClassLoader, (Object)thread.getContextClassLoader());
        wrapped.createCheckpointDataSerializer();
        ((MasterTriggerRestoreHook)Mockito.verify((Object)hook, (VerificationMode)Mockito.times((int)1))).createCheckpointDataSerializer();
        Assert.assertEquals((Object)originalClassLoader, (Object)thread.getContextClassLoader());
    }

    private static class TestExecutor
    implements Executor {
        Runnable command;

        private TestExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            this.command = command;
        }
    }
}

