/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.savepoint;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.savepoint.Savepoint;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointLoader;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointStore;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointV2;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;

public class SavepointLoaderTest {
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();

    @Test
    public void testLoadAndValidateSavepoint() throws Exception {
        File tmp = this.tmpFolder.newFolder();
        int parallelism = 128128;
        long checkpointId = 2147606770L;
        JobVertexID jobVertexID = new JobVertexID();
        OperatorID operatorID = OperatorID.fromJobVertexID((JobVertexID)jobVertexID);
        OperatorSubtaskState subtaskState = new OperatorSubtaskState(new OperatorStateHandle(Collections.emptyMap(), (StreamStateHandle)new ByteStreamStateHandle("testHandler", new byte[0])), null, null, null);
        OperatorState state = new OperatorState(operatorID, parallelism, parallelism);
        state.putState(0, subtaskState);
        HashMap<OperatorID, OperatorState> taskStates = new HashMap<OperatorID, OperatorState>();
        taskStates.put(operatorID, state);
        JobID jobId = new JobID();
        SavepointV2 savepoint = new SavepointV2(checkpointId, taskStates.values(), Collections.emptyList());
        String path = SavepointStore.storeSavepoint((String)tmp.getAbsolutePath(), (Savepoint)savepoint);
        ExecutionJobVertex vertex = (ExecutionJobVertex)Mockito.mock(ExecutionJobVertex.class);
        Mockito.when((Object)vertex.getParallelism()).thenReturn((Object)parallelism);
        Mockito.when((Object)vertex.getMaxParallelism()).thenReturn((Object)parallelism);
        Mockito.when((Object)vertex.getOperatorIDs()).thenReturn(Collections.singletonList(operatorID));
        HashMap<JobVertexID, ExecutionJobVertex> tasks = new HashMap<JobVertexID, ExecutionJobVertex>();
        tasks.put(jobVertexID, vertex);
        ClassLoader ucl = Thread.currentThread().getContextClassLoader();
        CompletedCheckpoint loaded = SavepointLoader.loadAndValidateSavepoint((JobID)jobId, tasks, (String)path, (ClassLoader)ucl, (boolean)false);
        Assert.assertEquals((Object)jobId, (Object)loaded.getJobId());
        Assert.assertEquals((long)checkpointId, (long)loaded.getCheckpointID());
        Mockito.when((Object)vertex.getMaxParallelism()).thenReturn((Object)222);
        Mockito.when((Object)vertex.isMaxParallelismConfigured()).thenReturn((Object)true);
        try {
            SavepointLoader.loadAndValidateSavepoint((JobID)jobId, tasks, (String)path, (ClassLoader)ucl, (boolean)false);
            Assert.fail((String)"Did not throw expected Exception");
        }
        catch (IllegalStateException expected) {
            Assert.assertTrue((boolean)expected.getMessage().contains("Max parallelism mismatch"));
        }
        Assert.assertNotNull(tasks.remove(jobVertexID));
        try {
            SavepointLoader.loadAndValidateSavepoint((JobID)jobId, tasks, (String)path, (ClassLoader)ucl, (boolean)false);
            Assert.fail((String)"Did not throw expected Exception");
        }
        catch (IllegalStateException expected) {
            Assert.assertTrue((boolean)expected.getMessage().contains("allowNonRestoredState"));
        }
        SavepointLoader.loadAndValidateSavepoint((JobID)jobId, tasks, (String)path, (ClassLoader)ucl, (boolean)true);
    }
}

