/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework;

import akka.actor.ActorSystem;
import akka.testkit.JavaTestKit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.AkkaOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.clusterframework.messages.NotifyResourceStarted;
import org.apache.flink.runtime.clusterframework.messages.RegisterResourceManager;
import org.apache.flink.runtime.clusterframework.messages.RegisterResourceManagerSuccessful;
import org.apache.flink.runtime.clusterframework.messages.RemoveResource;
import org.apache.flink.runtime.clusterframework.messages.ResourceRemoved;
import org.apache.flink.runtime.clusterframework.messages.TriggerRegistrationAtJobManager;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.heartbeat.TestingHeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.TestingHighAvailabilityServices;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.jobmaster.JobMasterGateway;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.jobmaster.JobMasterRegistrationSuccess;
import org.apache.flink.runtime.leaderelection.TestingLeaderElectionService;
import org.apache.flink.runtime.leaderelection.TestingLeaderRetrievalService;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.messages.JobManagerMessages;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryImpl;
import org.apache.flink.runtime.registration.RegistrationResponse;
import org.apache.flink.runtime.resourcemanager.JobLeaderIdService;
import org.apache.flink.runtime.resourcemanager.ResourceManagerConfiguration;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.resourcemanager.ResourceManagerId;
import org.apache.flink.runtime.resourcemanager.StandaloneResourceManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManager;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcGateway;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.TestingRpcService;
import org.apache.flink.runtime.taskexecutor.SlotReport;
import org.apache.flink.runtime.taskexecutor.TaskExecutorGateway;
import org.apache.flink.runtime.taskexecutor.TaskExecutorRegistrationSuccess;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.runtime.testutils.TestingResourceManager;
import org.apache.flink.runtime.util.TestingFatalErrorHandler;
import org.apache.flink.util.TestLogger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Option;

public class ResourceManagerTest
extends TestLogger {
    private static ActorSystem system;
    private static ActorGateway fakeJobManager;
    private static ActorGateway resourceManager;
    private static Configuration config;
    private final Time timeout = Time.seconds((long)10L);
    private TestingHighAvailabilityServices highAvailabilityServices;
    private TestingLeaderRetrievalService jobManagerLeaderRetrievalService;

    @BeforeClass
    public static void setup() {
        system = AkkaUtils.createLocalActorSystem((Configuration)config);
    }

    @AfterClass
    public static void teardown() {
        JavaTestKit.shutdownActorSystem((ActorSystem)system);
    }

    @Before
    public void setupTest() {
        this.jobManagerLeaderRetrievalService = new TestingLeaderRetrievalService();
        this.highAvailabilityServices = new TestingHighAvailabilityServices();
        this.highAvailabilityServices.setJobMasterLeaderRetriever(HighAvailabilityServices.DEFAULT_JOB_ID, this.jobManagerLeaderRetrievalService);
    }

    @After
    public void teardownTest() throws Exception {
        if (this.jobManagerLeaderRetrievalService != null) {
            this.jobManagerLeaderRetrievalService.stop();
            this.jobManagerLeaderRetrievalService = null;
        }
        if (this.highAvailabilityServices != null) {
            this.highAvailabilityServices.closeAndCleanupAllData();
            this.highAvailabilityServices = null;
        }
    }

    @Test
    public void testJobManagerRegistrationAndReconciliation() {
        new JavaTestKit(system){
            {
                new JavaTestKit.Within(1.duration((String)"10 seconds")){

                    protected void run() {
                        fakeJobManager = TestingUtils.createForwardingActor(system, this.getTestActor(), HighAvailabilityServices.DEFAULT_LEADER_ID, (Option<String>)Option.empty());
                        ResourceManagerTest.this.jobManagerLeaderRetrievalService.notifyListener(fakeJobManager.path(), HighAvailabilityServices.DEFAULT_LEADER_ID);
                        resourceManager = TestingUtils.createResourceManager(system, config, ResourceManagerTest.this.highAvailabilityServices);
                        this.expectMsgClass(RegisterResourceManager.class);
                        ArrayList<ResourceID> resourceList = new ArrayList<ResourceID>();
                        resourceList.add(ResourceID.generate());
                        resourceList.add(ResourceID.generate());
                        resourceList.add(ResourceID.generate());
                        resourceManager.tell((Object)new RegisterResourceManagerSuccessful(fakeJobManager.actor(), resourceList), fakeJobManager);
                        resourceManager.tell((Object)new TestingResourceManager.GetRegisteredResources(), fakeJobManager);
                        TestingResourceManager.GetRegisteredResourcesReply reply = (TestingResourceManager.GetRegisteredResourcesReply)this.expectMsgClass(TestingResourceManager.GetRegisteredResourcesReply.class);
                        for (ResourceID id : resourceList) {
                            if (reply.resources.contains(id)) continue;
                            Assert.fail((String)"Expected to find all resources that were provided during registration.");
                        }
                    }
                };
            }
        };
    }

    @Test
    public void testDelayedJobManagerRegistration() {
        new JavaTestKit(system){
            {
                new JavaTestKit.Within(2.duration((String)"10 seconds")){

                    protected void run() {
                        Configuration shortTimeoutConfig = config.clone();
                        shortTimeoutConfig.setString(AkkaOptions.LOOKUP_TIMEOUT, "1 s");
                        fakeJobManager = TestingUtils.createForwardingActor(system, this.getTestActor(), HighAvailabilityServices.DEFAULT_LEADER_ID, (Option<String>)Option.empty());
                        ResourceManagerTest.this.jobManagerLeaderRetrievalService.notifyListener(fakeJobManager.path(), HighAvailabilityServices.DEFAULT_LEADER_ID);
                        resourceManager = TestingUtils.createResourceManager(system, shortTimeoutConfig, ResourceManagerTest.this.highAvailabilityServices);
                        RegisterResourceManager msg = (RegisterResourceManager)this.expectMsgClass(RegisterResourceManager.class);
                        this.getLastSender().tell((Object)new JobManagerMessages.LeaderSessionMessage(null, new Object()), fakeJobManager.actor());
                        this.expectMsgClass(RegisterResourceManager.class);
                        this.expectMsgClass(RegisterResourceManager.class);
                    }
                };
            }
        };
    }

    @Test
    public void testTriggerReconnect() {
        new JavaTestKit(system){
            {
                new JavaTestKit.Within(3.duration((String)"10 seconds")){

                    protected void run() {
                        Configuration shortTimeoutConfig = config.clone();
                        shortTimeoutConfig.setString(AkkaOptions.LOOKUP_TIMEOUT, "99999 s");
                        fakeJobManager = TestingUtils.createForwardingActor(system, this.getTestActor(), HighAvailabilityServices.DEFAULT_LEADER_ID, (Option<String>)Option.empty());
                        ResourceManagerTest.this.jobManagerLeaderRetrievalService.notifyListener(fakeJobManager.path(), HighAvailabilityServices.DEFAULT_LEADER_ID);
                        resourceManager = TestingUtils.createResourceManager(system, shortTimeoutConfig, ResourceManagerTest.this.highAvailabilityServices);
                        RegisterResourceManager msg = (RegisterResourceManager)this.expectMsgClass(RegisterResourceManager.class);
                        resourceManager.tell((Object)new RegisterResourceManagerSuccessful(fakeJobManager.actor(), Collections.emptyList()), fakeJobManager);
                        resourceManager.tell((Object)new TriggerRegistrationAtJobManager(fakeJobManager.actor()), fakeJobManager);
                        this.expectMsgClass(RegisterResourceManager.class);
                    }
                };
            }
        };
    }

    @Test
    public void testTaskManagerRegistration() {
        new JavaTestKit(system){
            {
                new JavaTestKit.Within(4.duration((String)"10 seconds")){

                    protected void run() {
                        fakeJobManager = TestingUtils.createForwardingActor(system, this.getTestActor(), HighAvailabilityServices.DEFAULT_LEADER_ID, (Option<String>)Option.empty());
                        ResourceManagerTest.this.jobManagerLeaderRetrievalService.notifyListener(fakeJobManager.path(), HighAvailabilityServices.DEFAULT_LEADER_ID);
                        resourceManager = TestingUtils.createResourceManager(system, config, ResourceManagerTest.this.highAvailabilityServices);
                        this.expectMsgClass(RegisterResourceManager.class);
                        resourceManager.tell((Object)new RegisterResourceManagerSuccessful(fakeJobManager.actor(), Collections.emptyList()), fakeJobManager);
                        ResourceID resourceID = ResourceID.generate();
                        resourceManager.tell((Object)new NotifyResourceStarted(resourceID), fakeJobManager);
                        this.expectMsgClass(Acknowledge.class);
                        resourceManager.tell((Object)new TestingResourceManager.GetRegisteredResources(), fakeJobManager);
                        TestingResourceManager.GetRegisteredResourcesReply reply = (TestingResourceManager.GetRegisteredResourcesReply)this.expectMsgClass(TestingResourceManager.GetRegisteredResourcesReply.class);
                        Assert.assertEquals((long)1L, (long)reply.resources.size());
                        resourceManager.tell((Object)new NotifyResourceStarted(resourceID), fakeJobManager);
                        this.expectMsgClass(Acknowledge.class);
                        resourceManager.tell((Object)new TestingResourceManager.GetRegisteredResources(), fakeJobManager);
                        reply = (TestingResourceManager.GetRegisteredResourcesReply)this.expectMsgClass(TestingResourceManager.GetRegisteredResourcesReply.class);
                        Assert.assertEquals((long)1L, (long)reply.resources.size());
                        resourceManager.tell((Object)new NotifyResourceStarted(null), fakeJobManager);
                        this.expectMsgClass(Acknowledge.class);
                        resourceManager.tell((Object)new TestingResourceManager.GetRegisteredResources(), fakeJobManager);
                        reply = (TestingResourceManager.GetRegisteredResourcesReply)this.expectMsgClass(TestingResourceManager.GetRegisteredResourcesReply.class);
                        Assert.assertEquals((long)1L, (long)reply.resources.size());
                    }
                };
            }
        };
    }

    @Test
    public void testResourceRemoval() {
        new JavaTestKit(system){
            {
                new JavaTestKit.Within(5.duration((String)"10 seconds")){

                    protected void run() {
                        fakeJobManager = TestingUtils.createForwardingActor(system, this.getTestActor(), HighAvailabilityServices.DEFAULT_LEADER_ID, (Option<String>)Option.empty());
                        ResourceManagerTest.this.jobManagerLeaderRetrievalService.notifyListener(fakeJobManager.path(), HighAvailabilityServices.DEFAULT_LEADER_ID);
                        resourceManager = TestingUtils.createResourceManager(system, config, ResourceManagerTest.this.highAvailabilityServices);
                        this.expectMsgClass(RegisterResourceManager.class);
                        resourceManager.tell((Object)new RegisterResourceManagerSuccessful(fakeJobManager.actor(), Collections.emptyList()), fakeJobManager);
                        ResourceID resourceID = ResourceID.generate();
                        resourceManager.tell((Object)new RemoveResource(resourceID), fakeJobManager);
                        resourceManager.tell((Object)new NotifyResourceStarted(resourceID), fakeJobManager);
                        this.expectMsgClass(Acknowledge.class);
                        resourceManager.tell((Object)new TestingResourceManager.GetRegisteredResources(), fakeJobManager);
                        TestingResourceManager.GetRegisteredResourcesReply reply = (TestingResourceManager.GetRegisteredResourcesReply)this.expectMsgClass(TestingResourceManager.GetRegisteredResourcesReply.class);
                        Assert.assertEquals((long)1L, (long)reply.resources.size());
                        Assert.assertTrue((boolean)reply.resources.contains(resourceID));
                        resourceManager.tell((Object)new RemoveResource(resourceID), fakeJobManager);
                        resourceManager.tell((Object)new TestingResourceManager.GetRegisteredResources(), fakeJobManager);
                        reply = (TestingResourceManager.GetRegisteredResourcesReply)this.expectMsgClass(TestingResourceManager.GetRegisteredResourcesReply.class);
                        Assert.assertEquals((long)0L, (long)reply.resources.size());
                    }
                };
            }
        };
    }

    @Test
    public void testResourceFailureNotification() {
        new JavaTestKit(system){
            {
                new JavaTestKit.Within(6.duration((String)"10 seconds")){

                    protected void run() {
                        fakeJobManager = TestingUtils.createForwardingActor(system, this.getTestActor(), HighAvailabilityServices.DEFAULT_LEADER_ID, (Option<String>)Option.empty());
                        ResourceManagerTest.this.jobManagerLeaderRetrievalService.notifyListener(fakeJobManager.path(), HighAvailabilityServices.DEFAULT_LEADER_ID);
                        resourceManager = TestingUtils.createResourceManager(system, config, ResourceManagerTest.this.highAvailabilityServices);
                        this.expectMsgClass(RegisterResourceManager.class);
                        resourceManager.tell((Object)new RegisterResourceManagerSuccessful(fakeJobManager.actor(), Collections.emptyList()), fakeJobManager);
                        ResourceID resourceID1 = ResourceID.generate();
                        ResourceID resourceID2 = ResourceID.generate();
                        resourceManager.tell((Object)new NotifyResourceStarted(resourceID1), fakeJobManager);
                        this.expectMsgClass(Acknowledge.class);
                        resourceManager.tell((Object)new NotifyResourceStarted(resourceID2), fakeJobManager);
                        this.expectMsgClass(Acknowledge.class);
                        resourceManager.tell((Object)new TestingResourceManager.GetRegisteredResources(), fakeJobManager);
                        TestingResourceManager.GetRegisteredResourcesReply reply = (TestingResourceManager.GetRegisteredResourcesReply)this.expectMsgClass(TestingResourceManager.GetRegisteredResourcesReply.class);
                        Assert.assertEquals((long)2L, (long)reply.resources.size());
                        Assert.assertTrue((boolean)reply.resources.contains(resourceID1));
                        Assert.assertTrue((boolean)reply.resources.contains(resourceID2));
                        resourceManager.tell((Object)new TestingResourceManager.FailResource(resourceID1), fakeJobManager);
                        resourceManager.tell((Object)new TestingResourceManager.FailResource(resourceID2), fakeJobManager);
                        ResourceRemoved answer = (ResourceRemoved)this.expectMsgClass(ResourceRemoved.class);
                        ResourceRemoved answer2 = (ResourceRemoved)this.expectMsgClass(ResourceRemoved.class);
                        Assert.assertEquals((Object)resourceID1, (Object)answer.resourceId());
                        Assert.assertEquals((Object)resourceID2, (Object)answer2.resourceId());
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeartbeatTimeoutWithTaskExecutor() throws Exception {
        String taskManagerAddress = "tm";
        ResourceID taskManagerResourceID = new ResourceID("tm");
        ResourceID resourceManagerResourceID = ResourceID.generate();
        TaskExecutorGateway taskExecutorGateway = (TaskExecutorGateway)Mockito.mock(TaskExecutorGateway.class);
        TestingRpcService rpcService = new TestingRpcService();
        rpcService.registerGateway("tm", (RpcGateway)taskExecutorGateway);
        ResourceManagerConfiguration resourceManagerConfiguration = new ResourceManagerConfiguration(Time.seconds((long)5L), Time.seconds((long)5L));
        TestingLeaderElectionService rmLeaderElectionService = new TestingLeaderElectionService();
        TestingHighAvailabilityServices highAvailabilityServices = new TestingHighAvailabilityServices();
        highAvailabilityServices.setResourceManagerLeaderElectionService(rmLeaderElectionService);
        long heartbeatInterval = 1L;
        long heartbeatTimeout = 5L;
        ScheduledExecutor scheduledExecutor = (ScheduledExecutor)Mockito.mock(ScheduledExecutor.class);
        TestingHeartbeatServices heartbeatServices = new TestingHeartbeatServices(1L, 5L, scheduledExecutor);
        MetricRegistryImpl metricRegistry = (MetricRegistryImpl)Mockito.mock(MetricRegistryImpl.class);
        JobLeaderIdService jobLeaderIdService = (JobLeaderIdService)Mockito.mock(JobLeaderIdService.class);
        TestingFatalErrorHandler testingFatalErrorHandler = new TestingFatalErrorHandler();
        SlotManager slotManager = new SlotManager(rpcService.getScheduledExecutor(), TestingUtils.infiniteTime(), TestingUtils.infiniteTime(), TestingUtils.infiniteTime());
        try {
            StandaloneResourceManager resourceManager = new StandaloneResourceManager((RpcService)rpcService, "resourcemanager", resourceManagerResourceID, resourceManagerConfiguration, (HighAvailabilityServices)highAvailabilityServices, (HeartbeatServices)heartbeatServices, slotManager, (MetricRegistry)metricRegistry, jobLeaderIdService, (FatalErrorHandler)testingFatalErrorHandler);
            resourceManager.start();
            ResourceManagerGateway rmGateway = (ResourceManagerGateway)resourceManager.getSelfGateway(ResourceManagerGateway.class);
            UUID rmLeaderSessionId = UUID.randomUUID();
            rmLeaderElectionService.isLeader(rmLeaderSessionId).get(this.timeout.toMilliseconds(), TimeUnit.MILLISECONDS);
            SlotReport slotReport = new SlotReport();
            CompletableFuture successfulFuture = rmGateway.registerTaskExecutor("tm", taskManagerResourceID, slotReport, this.timeout);
            RegistrationResponse response = (RegistrationResponse)successfulFuture.get(this.timeout.toMilliseconds(), TimeUnit.MILLISECONDS);
            Assert.assertTrue((boolean)(response instanceof TaskExecutorRegistrationSuccess));
            ArgumentCaptor heartbeatRunnableCaptor = ArgumentCaptor.forClass(Runnable.class);
            ((ScheduledExecutor)Mockito.verify((Object)scheduledExecutor, (VerificationMode)Mockito.times((int)2))).scheduleAtFixedRate((Runnable)heartbeatRunnableCaptor.capture(), Matchers.eq((long)0L), Matchers.eq((long)1L), (TimeUnit)((Object)Matchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
            List heartbeatRunnable = heartbeatRunnableCaptor.getAllValues();
            ArgumentCaptor timeoutRunnableCaptor = ArgumentCaptor.forClass(Runnable.class);
            ((ScheduledExecutor)Mockito.verify((Object)scheduledExecutor)).schedule((Runnable)timeoutRunnableCaptor.capture(), Matchers.eq((long)5L), (TimeUnit)((Object)Matchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
            Runnable timeoutRunnable = (Runnable)timeoutRunnableCaptor.getValue();
            for (Runnable runnable : heartbeatRunnable) {
                runnable.run();
            }
            ((TaskExecutorGateway)Mockito.verify((Object)taskExecutorGateway, (VerificationMode)Mockito.times((int)1))).heartbeatFromResourceManager((ResourceID)Matchers.eq((Object)resourceManagerResourceID));
            timeoutRunnable.run();
            ((TaskExecutorGateway)Mockito.verify((Object)taskExecutorGateway, (VerificationMode)Mockito.timeout((long)this.timeout.toMilliseconds()))).disconnectResourceManager((Exception)Matchers.any(TimeoutException.class));
        }
        finally {
            rpcService.stopService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeartbeatTimeoutWithJobManager() throws Exception {
        String jobMasterAddress = "jm";
        ResourceID jmResourceId = new ResourceID("jm");
        ResourceID rmResourceId = ResourceID.generate();
        ResourceManagerId rmLeaderId = ResourceManagerId.generate();
        JobMasterId jobMasterId = JobMasterId.generate();
        JobID jobId = new JobID();
        JobMasterGateway jobMasterGateway = (JobMasterGateway)Mockito.mock(JobMasterGateway.class);
        TestingRpcService rpcService = new TestingRpcService();
        rpcService.registerGateway("jm", (RpcGateway)jobMasterGateway);
        ResourceManagerConfiguration resourceManagerConfiguration = new ResourceManagerConfiguration(Time.seconds((long)5L), Time.seconds((long)5L));
        TestingLeaderElectionService rmLeaderElectionService = new TestingLeaderElectionService();
        TestingLeaderRetrievalService jmLeaderRetrievalService = new TestingLeaderRetrievalService("jm", jobMasterId.toUUID());
        TestingHighAvailabilityServices highAvailabilityServices = new TestingHighAvailabilityServices();
        highAvailabilityServices.setResourceManagerLeaderElectionService(rmLeaderElectionService);
        highAvailabilityServices.setJobMasterLeaderRetriever(jobId, jmLeaderRetrievalService);
        long heartbeatInterval = 1L;
        long heartbeatTimeout = 5L;
        ScheduledExecutor scheduledExecutor = (ScheduledExecutor)Mockito.mock(ScheduledExecutor.class);
        TestingHeartbeatServices heartbeatServices = new TestingHeartbeatServices(1L, 5L, scheduledExecutor);
        MetricRegistryImpl metricRegistry = (MetricRegistryImpl)Mockito.mock(MetricRegistryImpl.class);
        JobLeaderIdService jobLeaderIdService = new JobLeaderIdService((HighAvailabilityServices)highAvailabilityServices, rpcService.getScheduledExecutor(), Time.minutes((long)5L));
        TestingFatalErrorHandler testingFatalErrorHandler = new TestingFatalErrorHandler();
        SlotManager slotManager = new SlotManager(TestingUtils.defaultScheduledExecutor(), TestingUtils.infiniteTime(), TestingUtils.infiniteTime(), TestingUtils.infiniteTime());
        try {
            StandaloneResourceManager resourceManager = new StandaloneResourceManager((RpcService)rpcService, "resourcemanager", rmResourceId, resourceManagerConfiguration, (HighAvailabilityServices)highAvailabilityServices, (HeartbeatServices)heartbeatServices, slotManager, (MetricRegistry)metricRegistry, jobLeaderIdService, (FatalErrorHandler)testingFatalErrorHandler);
            resourceManager.start();
            ResourceManagerGateway rmGateway = (ResourceManagerGateway)resourceManager.getSelfGateway(ResourceManagerGateway.class);
            rmLeaderElectionService.isLeader(rmLeaderId.toUUID()).get(this.timeout.toMilliseconds(), TimeUnit.MILLISECONDS);
            CompletableFuture successfulFuture = rmGateway.registerJobManager(jobMasterId, jmResourceId, "jm", jobId, this.timeout);
            RegistrationResponse response = (RegistrationResponse)successfulFuture.get(this.timeout.toMilliseconds(), TimeUnit.MILLISECONDS);
            Assert.assertTrue((boolean)(response instanceof JobMasterRegistrationSuccess));
            ArgumentCaptor heartbeatRunnableCaptor = ArgumentCaptor.forClass(Runnable.class);
            ((ScheduledExecutor)Mockito.verify((Object)scheduledExecutor, (VerificationMode)Mockito.times((int)2))).scheduleAtFixedRate((Runnable)heartbeatRunnableCaptor.capture(), Matchers.eq((long)0L), Matchers.eq((long)1L), (TimeUnit)((Object)Matchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
            List heartbeatRunnable = heartbeatRunnableCaptor.getAllValues();
            ArgumentCaptor timeoutRunnableCaptor = ArgumentCaptor.forClass(Runnable.class);
            ((ScheduledExecutor)Mockito.verify((Object)scheduledExecutor)).schedule((Runnable)timeoutRunnableCaptor.capture(), Matchers.eq((long)5L), (TimeUnit)((Object)Matchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
            Runnable timeoutRunnable = (Runnable)timeoutRunnableCaptor.getValue();
            for (Runnable runnable : heartbeatRunnable) {
                runnable.run();
            }
            ((JobMasterGateway)Mockito.verify((Object)jobMasterGateway, (VerificationMode)Mockito.times((int)1))).heartbeatFromResourceManager((ResourceID)Matchers.eq((Object)rmResourceId));
            timeoutRunnable.run();
            ((JobMasterGateway)Mockito.verify((Object)jobMasterGateway, (VerificationMode)Mockito.timeout((long)this.timeout.toMilliseconds()))).disconnectResourceManager((ResourceManagerId)Matchers.eq((Object)rmLeaderId), (Exception)Matchers.any(TimeoutException.class));
        }
        finally {
            rpcService.stopService();
        }
    }

    static {
        config = new Configuration();
    }
}

