/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.deployment;

import java.net.InetAddress;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.deployment.InputChannelDeploymentDescriptor;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionEdge;
import org.apache.flink.runtime.executiongraph.ExecutionGraphException;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.IntermediateResult;
import org.apache.flink.runtime.executiongraph.IntermediateResultPartition;
import org.apache.flink.runtime.instance.SimpleSlot;
import org.apache.flink.runtime.io.network.ConnectionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class InputChannelDeploymentDescriptorTest {
    @Test
    public void testMixedLocalRemoteUnknownDeployment() throws Exception {
        boolean allowLazyDeployment = true;
        ResourceID consumerResourceId = ResourceID.generate();
        ExecutionVertex consumer = (ExecutionVertex)Mockito.mock(ExecutionVertex.class);
        SimpleSlot consumerSlot = InputChannelDeploymentDescriptorTest.mockSlot(consumerResourceId);
        for (ExecutionState state : ExecutionState.values()) {
            ExecutionVertex localProducer = InputChannelDeploymentDescriptorTest.mockExecutionVertex(state, consumerResourceId);
            IntermediateResultPartition localPartition = InputChannelDeploymentDescriptorTest.mockPartition(localProducer);
            ResultPartitionID localPartitionId = new ResultPartitionID(localPartition.getPartitionId(), localProducer.getCurrentExecutionAttempt().getAttemptId());
            ExecutionEdge localEdge = new ExecutionEdge(localPartition, consumer, 0);
            ExecutionVertex remoteProducer = InputChannelDeploymentDescriptorTest.mockExecutionVertex(state, ResourceID.generate());
            IntermediateResultPartition remotePartition = InputChannelDeploymentDescriptorTest.mockPartition(remoteProducer);
            ResultPartitionID remotePartitionId = new ResultPartitionID(remotePartition.getPartitionId(), remoteProducer.getCurrentExecutionAttempt().getAttemptId());
            ConnectionID remoteConnectionId = new ConnectionID(remoteProducer.getCurrentAssignedResource().getTaskManagerLocation(), 0);
            ExecutionEdge remoteEdge = new ExecutionEdge(remotePartition, consumer, 1);
            ExecutionVertex unknownProducer = InputChannelDeploymentDescriptorTest.mockExecutionVertex(state, null);
            IntermediateResultPartition unknownPartition = InputChannelDeploymentDescriptorTest.mockPartition(unknownProducer);
            ResultPartitionID unknownPartitionId = new ResultPartitionID(unknownPartition.getPartitionId(), unknownProducer.getCurrentExecutionAttempt().getAttemptId());
            ExecutionEdge unknownEdge = new ExecutionEdge(unknownPartition, consumer, 2);
            InputChannelDeploymentDescriptor[] desc = InputChannelDeploymentDescriptor.fromEdges((ExecutionEdge[])new ExecutionEdge[]{localEdge, remoteEdge, unknownEdge}, (SimpleSlot)consumerSlot, (boolean)allowLazyDeployment);
            Assert.assertEquals((long)3L, (long)desc.length);
            if (state == ExecutionState.RUNNING || state == ExecutionState.FINISHED || state == ExecutionState.SCHEDULED || state == ExecutionState.DEPLOYING) {
                Assert.assertEquals((Object)localPartitionId, (Object)desc[0].getConsumedPartitionId());
                Assert.assertTrue((boolean)desc[0].getConsumedPartitionLocation().isLocal());
                Assert.assertNull((Object)desc[0].getConsumedPartitionLocation().getConnectionId());
                Assert.assertEquals((Object)remotePartitionId, (Object)desc[1].getConsumedPartitionId());
                Assert.assertTrue((boolean)desc[1].getConsumedPartitionLocation().isRemote());
                Assert.assertEquals((Object)remoteConnectionId, (Object)desc[1].getConsumedPartitionLocation().getConnectionId());
            } else {
                Assert.assertEquals((Object)localPartitionId, (Object)desc[0].getConsumedPartitionId());
                Assert.assertTrue((boolean)desc[0].getConsumedPartitionLocation().isUnknown());
                Assert.assertNull((Object)desc[0].getConsumedPartitionLocation().getConnectionId());
                Assert.assertEquals((Object)remotePartitionId, (Object)desc[1].getConsumedPartitionId());
                Assert.assertTrue((boolean)desc[1].getConsumedPartitionLocation().isUnknown());
                Assert.assertNull((Object)desc[1].getConsumedPartitionLocation().getConnectionId());
            }
            Assert.assertEquals((Object)unknownPartitionId, (Object)desc[2].getConsumedPartitionId());
            Assert.assertTrue((boolean)desc[2].getConsumedPartitionLocation().isUnknown());
            Assert.assertNull((Object)desc[2].getConsumedPartitionLocation().getConnectionId());
        }
    }

    @Test
    public void testUnknownChannelWithoutLazyDeploymentThrows() throws Exception {
        ResourceID consumerResourceId = ResourceID.generate();
        ExecutionVertex consumer = (ExecutionVertex)Mockito.mock(ExecutionVertex.class);
        SimpleSlot consumerSlot = InputChannelDeploymentDescriptorTest.mockSlot(consumerResourceId);
        ExecutionVertex unknownProducer = InputChannelDeploymentDescriptorTest.mockExecutionVertex(ExecutionState.CREATED, null);
        IntermediateResultPartition unknownPartition = InputChannelDeploymentDescriptorTest.mockPartition(unknownProducer);
        ResultPartitionID unknownPartitionId = new ResultPartitionID(unknownPartition.getPartitionId(), unknownProducer.getCurrentExecutionAttempt().getAttemptId());
        ExecutionEdge unknownEdge = new ExecutionEdge(unknownPartition, consumer, 2);
        boolean allowLazyDeployment = true;
        InputChannelDeploymentDescriptor[] desc = InputChannelDeploymentDescriptor.fromEdges((ExecutionEdge[])new ExecutionEdge[]{unknownEdge}, (SimpleSlot)consumerSlot, (boolean)allowLazyDeployment);
        Assert.assertEquals((long)1L, (long)desc.length);
        Assert.assertEquals((Object)unknownPartitionId, (Object)desc[0].getConsumedPartitionId());
        Assert.assertTrue((boolean)desc[0].getConsumedPartitionLocation().isUnknown());
        Assert.assertNull((Object)desc[0].getConsumedPartitionLocation().getConnectionId());
        try {
            allowLazyDeployment = false;
            InputChannelDeploymentDescriptor.fromEdges((ExecutionEdge[])new ExecutionEdge[]{unknownEdge}, (SimpleSlot)consumerSlot, (boolean)allowLazyDeployment);
            Assert.fail((String)"Did not throw expected ExecutionGraphException");
        }
        catch (ExecutionGraphException executionGraphException) {
            // empty catch block
        }
    }

    private static SimpleSlot mockSlot(ResourceID resourceId) {
        SimpleSlot slot = (SimpleSlot)Mockito.mock(SimpleSlot.class);
        Mockito.when((Object)slot.getTaskManagerLocation()).thenReturn((Object)new TaskManagerLocation(resourceId, InetAddress.getLoopbackAddress(), 5000));
        Mockito.when((Object)slot.getTaskManagerID()).thenReturn((Object)resourceId);
        return slot;
    }

    private static ExecutionVertex mockExecutionVertex(ExecutionState state, ResourceID resourceId) {
        ExecutionVertex vertex = (ExecutionVertex)Mockito.mock(ExecutionVertex.class);
        Execution exec = (Execution)Mockito.mock(Execution.class);
        Mockito.when((Object)exec.getState()).thenReturn((Object)state);
        Mockito.when((Object)exec.getAttemptId()).thenReturn((Object)new ExecutionAttemptID());
        if (resourceId != null) {
            SimpleSlot slot = InputChannelDeploymentDescriptorTest.mockSlot(resourceId);
            Mockito.when((Object)exec.getAssignedResource()).thenReturn((Object)slot);
            Mockito.when((Object)vertex.getCurrentAssignedResource()).thenReturn((Object)slot);
        } else {
            Mockito.when((Object)exec.getAssignedResource()).thenReturn(null);
            Mockito.when((Object)vertex.getCurrentAssignedResource()).thenReturn(null);
        }
        Mockito.when((Object)vertex.getCurrentExecutionAttempt()).thenReturn((Object)exec);
        return vertex;
    }

    private static IntermediateResultPartition mockPartition(ExecutionVertex producer) {
        IntermediateResultPartition partition = (IntermediateResultPartition)Mockito.mock(IntermediateResultPartition.class);
        Mockito.when((Object)partition.isConsumable()).thenReturn((Object)true);
        IntermediateResult result = (IntermediateResult)Mockito.mock(IntermediateResult.class);
        Mockito.when((Object)result.getConnectionIndex()).thenReturn((Object)0);
        Mockito.when((Object)partition.getIntermediateResult()).thenReturn((Object)result);
        Mockito.when((Object)partition.getPartitionId()).thenReturn((Object)new IntermediateResultPartitionID());
        Mockito.when((Object)partition.getProducer()).thenReturn((Object)producer);
        return partition;
    }
}

