/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.dispatcher.Dispatcher;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.TestingHighAvailabilityServices;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobmanager.OnCompletionActions;
import org.apache.flink.runtime.jobmanager.StandaloneSubmittedJobGraphStore;
import org.apache.flink.runtime.jobmanager.SubmittedJobGraphStore;
import org.apache.flink.runtime.jobmaster.JobManagerRunner;
import org.apache.flink.runtime.jobmaster.JobManagerServices;
import org.apache.flink.runtime.leaderelection.TestingLeaderElectionService;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryImpl;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcEndpoint;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.RpcUtils;
import org.apache.flink.runtime.rpc.TestingRpcService;
import org.apache.flink.runtime.util.TestingFatalErrorHandler;
import org.apache.flink.util.TestLogger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DispatcherTest
extends TestLogger {
    @Rule
    public TestName name = new TestName();
    private static RpcService rpcService;
    private static final Time timeout;

    @BeforeClass
    public static void setup() {
        rpcService = new TestingRpcService();
    }

    @AfterClass
    public static void teardown() {
        if (rpcService != null) {
            rpcService.stopService();
            rpcService = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJobSubmission() throws Exception {
        TestingFatalErrorHandler fatalErrorHandler = new TestingFatalErrorHandler();
        TestingLeaderElectionService dispatcherLeaderElectionService = new TestingLeaderElectionService();
        TestingHighAvailabilityServices haServices = new TestingHighAvailabilityServices();
        haServices.setDispatcherLeaderElectionService(dispatcherLeaderElectionService);
        haServices.setSubmittedJobGraphStore((SubmittedJobGraphStore)new StandaloneSubmittedJobGraphStore());
        HeartbeatServices heartbeatServices = new HeartbeatServices(1000L, 10000L);
        JobManagerRunner jobManagerRunner = (JobManagerRunner)Mockito.mock(JobManagerRunner.class);
        JobGraph jobGraph = (JobGraph)Mockito.mock(JobGraph.class);
        JobID jobId = new JobID();
        Mockito.when((Object)jobGraph.getJobID()).thenReturn((Object)jobId);
        TestingDispatcher dispatcher = new TestingDispatcher(rpcService, "dispatcher_" + this.name.getMethodName(), new Configuration(), haServices, (ResourceManagerGateway)Mockito.mock(ResourceManagerGateway.class), (BlobServer)Mockito.mock(BlobServer.class), heartbeatServices, (MetricRegistry)Mockito.mock(MetricRegistryImpl.class), fatalErrorHandler, jobManagerRunner, jobId);
        try {
            dispatcher.start();
            CompletableFuture<UUID> leaderFuture = dispatcherLeaderElectionService.isLeader(UUID.randomUUID());
            leaderFuture.get();
            DispatcherGateway dispatcherGateway = (DispatcherGateway)dispatcher.getSelfGateway(DispatcherGateway.class);
            CompletableFuture acknowledgeFuture = dispatcherGateway.submitJob(jobGraph, timeout);
            acknowledgeFuture.get();
            ((JobManagerRunner)Mockito.verify((Object)jobManagerRunner, (VerificationMode)Mockito.timeout((long)timeout.toMilliseconds()))).start();
            fatalErrorHandler.rethrowError();
        }
        finally {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint)dispatcher, (Time)timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLeaderElection() throws Exception {
        TestingFatalErrorHandler fatalErrorHandler = new TestingFatalErrorHandler();
        TestingHighAvailabilityServices haServices = new TestingHighAvailabilityServices();
        UUID expectedLeaderSessionId = UUID.randomUUID();
        final CompletableFuture leaderSessionIdFuture = new CompletableFuture();
        SubmittedJobGraphStore mockSubmittedJobGraphStore = (SubmittedJobGraphStore)Mockito.mock(SubmittedJobGraphStore.class);
        TestingLeaderElectionService testingLeaderElectionService = new TestingLeaderElectionService(){

            @Override
            public void confirmLeaderSessionID(UUID leaderSessionId) {
                super.confirmLeaderSessionID(leaderSessionId);
                leaderSessionIdFuture.complete(leaderSessionId);
            }
        };
        haServices.setSubmittedJobGraphStore(mockSubmittedJobGraphStore);
        haServices.setDispatcherLeaderElectionService(testingLeaderElectionService);
        HeartbeatServices heartbeatServices = new HeartbeatServices(1000L, 1000L);
        JobID jobId = new JobID();
        TestingDispatcher dispatcher = new TestingDispatcher(rpcService, "dispatcher_" + this.name.getMethodName(), new Configuration(), haServices, (ResourceManagerGateway)Mockito.mock(ResourceManagerGateway.class), (BlobServer)Mockito.mock(BlobServer.class), heartbeatServices, (MetricRegistry)Mockito.mock(MetricRegistryImpl.class), fatalErrorHandler, (JobManagerRunner)Mockito.mock(JobManagerRunner.class), jobId);
        try {
            dispatcher.start();
            Assert.assertFalse((boolean)leaderSessionIdFuture.isDone());
            testingLeaderElectionService.isLeader(expectedLeaderSessionId);
            UUID actualLeaderSessionId = (UUID)leaderSessionIdFuture.get(timeout.toMilliseconds(), TimeUnit.MILLISECONDS);
            Assert.assertEquals((Object)expectedLeaderSessionId, (Object)actualLeaderSessionId);
            ((SubmittedJobGraphStore)Mockito.verify((Object)mockSubmittedJobGraphStore, (VerificationMode)Mockito.timeout((long)timeout.toMilliseconds()).atLeast(1))).getJobIds();
        }
        finally {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint)dispatcher, (Time)timeout);
        }
    }

    static {
        timeout = Time.seconds((long)10L);
    }

    private static class TestingDispatcher
    extends Dispatcher {
        private final JobManagerRunner jobManagerRunner;
        private final JobID expectedJobId;

        protected TestingDispatcher(RpcService rpcService, String endpointId, Configuration configuration, HighAvailabilityServices highAvailabilityServices, ResourceManagerGateway resourceManagerGateway, BlobServer blobServer, HeartbeatServices heartbeatServices, MetricRegistry metricRegistry, FatalErrorHandler fatalErrorHandler, JobManagerRunner jobManagerRunner, JobID expectedJobId) throws Exception {
            super(rpcService, endpointId, configuration, highAvailabilityServices, resourceManagerGateway, blobServer, heartbeatServices, metricRegistry, fatalErrorHandler, Optional.empty());
            this.jobManagerRunner = jobManagerRunner;
            this.expectedJobId = expectedJobId;
        }

        protected JobManagerRunner createJobManagerRunner(ResourceID resourceId, JobGraph jobGraph, Configuration configuration, RpcService rpcService, HighAvailabilityServices highAvailabilityServices, HeartbeatServices heartbeatServices, JobManagerServices jobManagerServices, MetricRegistry metricRegistry, OnCompletionActions onCompleteActions, FatalErrorHandler fatalErrorHandler) throws Exception {
            Assert.assertEquals((Object)this.expectedJobId, (Object)jobGraph.getJobID());
            return this.jobManagerRunner;
        }
    }
}

