/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.IOException;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.JobException;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ExecutionJobVertexTest {
    private static final int NOT_CONFIGURED = -1;

    @Test
    public void testMaxParallelismDefaulting() throws Exception {
        ExecutionJobVertex executionJobVertex = ExecutionJobVertexTest.createExecutionJobVertex(1, -1);
        Assert.assertEquals((long)128L, (long)executionJobVertex.getMaxParallelism());
        executionJobVertex = ExecutionJobVertexTest.createExecutionJobVertex(171, -1);
        Assert.assertEquals((long)256L, (long)executionJobVertex.getMaxParallelism());
        executionJobVertex = ExecutionJobVertexTest.createExecutionJobVertex(172, -1);
        Assert.assertEquals((long)512L, (long)executionJobVertex.getMaxParallelism());
        executionJobVertex = ExecutionJobVertexTest.createExecutionJobVertex(32768, -1);
        Assert.assertEquals((long)32768L, (long)executionJobVertex.getMaxParallelism());
        try {
            executionJobVertex = ExecutionJobVertexTest.createExecutionJobVertex(32769, -1);
            executionJobVertex.getMaxParallelism();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        executionJobVertex = ExecutionJobVertexTest.createExecutionJobVertex(172, 4);
        Assert.assertEquals((long)4L, (long)executionJobVertex.getMaxParallelism());
        executionJobVertex = ExecutionJobVertexTest.createExecutionJobVertex(4, 32768);
        Assert.assertEquals((long)32768L, (long)executionJobVertex.getMaxParallelism());
        try {
            executionJobVertex = ExecutionJobVertexTest.createExecutionJobVertex(4, 32769);
            Assert.fail((String)String.valueOf(executionJobVertex.getMaxParallelism()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            executionJobVertex = ExecutionJobVertexTest.createExecutionJobVertex(4, 0);
            Assert.fail((String)String.valueOf(executionJobVertex.getMaxParallelism()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        executionJobVertex = ExecutionJobVertexTest.createExecutionJobVertex(4, -1);
        executionJobVertex.setMaxParallelism(7);
        Assert.assertEquals((long)7L, (long)executionJobVertex.getMaxParallelism());
        executionJobVertex = ExecutionJobVertexTest.createExecutionJobVertex(4, -1);
        try {
            executionJobVertex.setMaxParallelism(0);
            Assert.fail((String)String.valueOf(executionJobVertex.getMaxParallelism()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        executionJobVertex = ExecutionJobVertexTest.createExecutionJobVertex(4, -1);
        try {
            executionJobVertex.setMaxParallelism(32769);
            Assert.fail((String)String.valueOf(executionJobVertex.getMaxParallelism()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        executionJobVertex = ExecutionJobVertexTest.createExecutionJobVertex(4, 16);
        try {
            executionJobVertex.setMaxParallelism(7);
            Assert.fail((String)String.valueOf(executionJobVertex.getMaxParallelism()));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private static ExecutionJobVertex createExecutionJobVertex(int parallelism, int preconfiguredMaxParallelism) throws JobException, IOException {
        JobVertex jobVertex = new JobVertex("testVertex");
        jobVertex.setInvokableClass(AbstractInvokable.class);
        jobVertex.setParallelism(parallelism);
        if (-1 != preconfiguredMaxParallelism) {
            jobVertex.setMaxParallelism(preconfiguredMaxParallelism);
        }
        ExecutionGraph executionGraphMock = (ExecutionGraph)Mockito.mock(ExecutionGraph.class);
        Mockito.when((Object)executionGraphMock.getFutureExecutor()).thenReturn((Object)Executors.directExecutor());
        ExecutionJobVertex executionJobVertex = new ExecutionJobVertex(executionGraphMock, jobVertex, 1, Time.seconds((long)10L));
        return executionJobVertex;
    }
}

