/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ProgrammedSlotProvider;
import org.apache.flink.runtime.executiongraph.restart.NoRestartStrategy;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategy;
import org.apache.flink.runtime.executiongraph.utils.SimpleAckingTaskManagerGateway;
import org.apache.flink.runtime.instance.SimpleSlot;
import org.apache.flink.runtime.instance.Slot;
import org.apache.flink.runtime.instance.SlotProvider;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.LocationPreferenceConstraint;
import org.apache.flink.runtime.jobmanager.scheduler.SchedulerTestUtils;
import org.apache.flink.runtime.jobmanager.slots.SlotOwner;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.taskmanager.LocalTaskManagerLocation;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.testtasks.NoOpInvokable;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class ExecutionTest
extends TestLogger {
    @Test
    public void testSlotReleaseOnFailedResourceAssignment() throws Exception {
        JobVertexID jobVertexId = new JobVertexID();
        JobVertex jobVertex = new JobVertex("Test vertex", jobVertexId);
        jobVertex.setInvokableClass(NoOpInvokable.class);
        CompletableFuture<SimpleSlot> slotFuture = new CompletableFuture<SimpleSlot>();
        ProgrammedSlotProvider slotProvider = new ProgrammedSlotProvider(1);
        slotProvider.addSlot(jobVertexId, 0, slotFuture);
        ExecutionGraph executionGraph = ExecutionGraphTestUtils.createSimpleTestGraph(new JobID(), slotProvider, (RestartStrategy)new NoRestartStrategy(), jobVertex);
        ExecutionJobVertex executionJobVertex = executionGraph.getJobVertex(jobVertexId);
        Execution execution = executionJobVertex.getTaskVertices()[0].getCurrentExecutionAttempt();
        TestingSlotOwner slotOwner = new TestingSlotOwner();
        SimpleSlot slot = new SimpleSlot(new JobID(), (SlotOwner)slotOwner, (TaskManagerLocation)new LocalTaskManagerLocation(), 0, (TaskManagerGateway)new SimpleAckingTaskManagerGateway());
        CompletableFuture allocationFuture = execution.allocateAndAssignSlotForExecution((SlotProvider)slotProvider, false, LocationPreferenceConstraint.ALL);
        Assert.assertFalse((boolean)allocationFuture.isDone());
        Assert.assertEquals((Object)ExecutionState.SCHEDULED, (Object)execution.getState());
        execution.cancel();
        Assert.assertEquals((Object)ExecutionState.CANCELED, (Object)execution.getState());
        slotFuture.complete(slot);
        Assert.assertEquals((Object)slot, (Object)slotOwner.getReturnedSlotFuture().get());
    }

    @Test
    public void testSlotReleaseOnExecutionCancellationInScheduled() throws Exception {
        JobVertexID jobVertexId = new JobVertexID();
        JobVertex jobVertex = new JobVertex("Test vertex", jobVertexId);
        jobVertex.setInvokableClass(NoOpInvokable.class);
        TestingSlotOwner slotOwner = new TestingSlotOwner();
        SimpleSlot slot = new SimpleSlot(new JobID(), (SlotOwner)slotOwner, (TaskManagerLocation)new LocalTaskManagerLocation(), 0, (TaskManagerGateway)new SimpleAckingTaskManagerGateway());
        ProgrammedSlotProvider slotProvider = new ProgrammedSlotProvider(1);
        slotProvider.addSlot(jobVertexId, 0, CompletableFuture.completedFuture(slot));
        ExecutionGraph executionGraph = ExecutionGraphTestUtils.createSimpleTestGraph(new JobID(), slotProvider, (RestartStrategy)new NoRestartStrategy(), jobVertex);
        ExecutionJobVertex executionJobVertex = executionGraph.getJobVertex(jobVertexId);
        Execution execution = executionJobVertex.getTaskVertices()[0].getCurrentExecutionAttempt();
        CompletableFuture allocationFuture = execution.allocateAndAssignSlotForExecution((SlotProvider)slotProvider, false, LocationPreferenceConstraint.ALL);
        Assert.assertTrue((boolean)allocationFuture.isDone());
        Assert.assertEquals((Object)ExecutionState.SCHEDULED, (Object)execution.getState());
        Assert.assertEquals((Object)slot, (Object)execution.getAssignedResource());
        execution.cancel();
        Assert.assertEquals((Object)ExecutionState.CANCELED, (Object)execution.getState());
        Assert.assertEquals((Object)slot, (Object)slotOwner.getReturnedSlotFuture().get());
    }

    @Test
    public void testSlotReleaseOnExecutionCancellationInRunning() throws Exception {
        JobVertexID jobVertexId = new JobVertexID();
        JobVertex jobVertex = new JobVertex("Test vertex", jobVertexId);
        jobVertex.setInvokableClass(NoOpInvokable.class);
        TestingSlotOwner slotOwner = new TestingSlotOwner();
        SimpleSlot slot = new SimpleSlot(new JobID(), (SlotOwner)slotOwner, (TaskManagerLocation)new LocalTaskManagerLocation(), 0, (TaskManagerGateway)new SimpleAckingTaskManagerGateway());
        ProgrammedSlotProvider slotProvider = new ProgrammedSlotProvider(1);
        slotProvider.addSlot(jobVertexId, 0, CompletableFuture.completedFuture(slot));
        ExecutionGraph executionGraph = ExecutionGraphTestUtils.createSimpleTestGraph(new JobID(), slotProvider, (RestartStrategy)new NoRestartStrategy(), jobVertex);
        ExecutionJobVertex executionJobVertex = executionGraph.getJobVertex(jobVertexId);
        Execution execution = executionJobVertex.getTaskVertices()[0].getCurrentExecutionAttempt();
        CompletableFuture allocationFuture = execution.allocateAndAssignSlotForExecution((SlotProvider)slotProvider, false, LocationPreferenceConstraint.ALL);
        Assert.assertTrue((boolean)allocationFuture.isDone());
        Assert.assertEquals((Object)ExecutionState.SCHEDULED, (Object)execution.getState());
        Assert.assertEquals((Object)slot, (Object)execution.getAssignedResource());
        execution.deploy();
        execution.switchToRunning();
        execution.cancel();
        Assert.assertEquals((Object)ExecutionState.CANCELING, (Object)execution.getState());
        execution.cancelingComplete();
        Assert.assertEquals((Object)slot, (Object)slotOwner.getReturnedSlotFuture().get());
    }

    @Test
    public void testAllPreferredLocationCalculation() throws ExecutionException, InterruptedException {
        LocalTaskManagerLocation taskManagerLocation1 = new LocalTaskManagerLocation();
        LocalTaskManagerLocation taskManagerLocation2 = new LocalTaskManagerLocation();
        LocalTaskManagerLocation taskManagerLocation3 = new LocalTaskManagerLocation();
        CompletableFuture<LocalTaskManagerLocation> locationFuture1 = CompletableFuture.completedFuture(taskManagerLocation1);
        CompletableFuture<LocalTaskManagerLocation> locationFuture2 = new CompletableFuture<LocalTaskManagerLocation>();
        CompletableFuture<LocalTaskManagerLocation> locationFuture3 = new CompletableFuture<LocalTaskManagerLocation>();
        Execution execution = SchedulerTestUtils.getTestVertex(Arrays.asList(locationFuture1, locationFuture2, locationFuture3));
        CompletableFuture preferredLocationsFuture = execution.calculatePreferredLocations(LocationPreferenceConstraint.ALL);
        Assert.assertFalse((boolean)preferredLocationsFuture.isDone());
        locationFuture3.complete(taskManagerLocation3);
        Assert.assertFalse((boolean)preferredLocationsFuture.isDone());
        locationFuture2.complete(taskManagerLocation2);
        Assert.assertTrue((boolean)preferredLocationsFuture.isDone());
        Collection preferredLocations = (Collection)preferredLocationsFuture.get();
        Assert.assertThat((Object)preferredLocations, (Matcher)Matchers.containsInAnyOrder((Object[])new TaskManagerLocation[]{taskManagerLocation1, taskManagerLocation2, taskManagerLocation3}));
    }

    @Test
    public void testAnyPreferredLocationCalculation() throws ExecutionException, InterruptedException {
        LocalTaskManagerLocation taskManagerLocation1 = new LocalTaskManagerLocation();
        LocalTaskManagerLocation taskManagerLocation3 = new LocalTaskManagerLocation();
        CompletableFuture<LocalTaskManagerLocation> locationFuture1 = CompletableFuture.completedFuture(taskManagerLocation1);
        CompletableFuture locationFuture2 = new CompletableFuture();
        CompletableFuture<LocalTaskManagerLocation> locationFuture3 = CompletableFuture.completedFuture(taskManagerLocation3);
        Execution execution = SchedulerTestUtils.getTestVertex(Arrays.asList(locationFuture1, locationFuture2, locationFuture3));
        CompletableFuture preferredLocationsFuture = execution.calculatePreferredLocations(LocationPreferenceConstraint.ANY);
        Assert.assertTrue((boolean)preferredLocationsFuture.isDone());
        Collection preferredLocations = (Collection)preferredLocationsFuture.get();
        Assert.assertThat((Object)preferredLocations, (Matcher)Matchers.containsInAnyOrder((Object[])new TaskManagerLocation[]{taskManagerLocation1, taskManagerLocation3}));
    }

    public static final class TestingSlotOwner
    implements SlotOwner {
        final CompletableFuture<Slot> returnedSlot = new CompletableFuture();

        public CompletableFuture<Slot> getReturnedSlotFuture() {
            return this.returnedSlot;
        }

        public boolean returnAllocatedSlot(Slot slot) {
            return this.returnedSlot.complete(slot);
        }
    }
}

