/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.instance.SimpleSlot;
import org.apache.flink.runtime.instance.SlotProvider;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.ScheduledUnit;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.Preconditions;

class ProgrammedSlotProvider
implements SlotProvider {
    private final Map<JobVertexID, CompletableFuture<SimpleSlot>[]> slotFutures = new HashMap<JobVertexID, CompletableFuture<SimpleSlot>[]>();
    private final Map<JobVertexID, CompletableFuture<Boolean>[]> slotFutureRequested = new HashMap<JobVertexID, CompletableFuture<Boolean>[]>();
    private final int parallelism;

    public ProgrammedSlotProvider(int parallelism) {
        Preconditions.checkArgument((parallelism > 0 ? 1 : 0) != 0);
        this.parallelism = parallelism;
    }

    public void addSlot(JobVertexID vertex, int subtaskIndex, CompletableFuture<SimpleSlot> future) {
        Preconditions.checkNotNull((Object)vertex);
        Preconditions.checkNotNull(future);
        Preconditions.checkArgument((subtaskIndex >= 0 && subtaskIndex < this.parallelism ? 1 : 0) != 0);
        CompletableFuture<SimpleSlot>[] futures = this.slotFutures.get(vertex);
        CompletableFuture<Boolean>[] requestedFutures = this.slotFutureRequested.get(vertex);
        if (futures == null) {
            CompletableFuture[] newArray = new CompletableFuture[this.parallelism];
            futures = newArray;
            this.slotFutures.put(vertex, futures);
            requestedFutures = new CompletableFuture[this.parallelism];
            this.slotFutureRequested.put(vertex, requestedFutures);
        }
        futures[subtaskIndex] = future;
        requestedFutures[subtaskIndex] = new CompletableFuture();
    }

    public void addSlots(JobVertexID vertex, CompletableFuture<SimpleSlot>[] futures) {
        Preconditions.checkNotNull((Object)vertex);
        Preconditions.checkNotNull(futures);
        Preconditions.checkArgument((futures.length == this.parallelism ? 1 : 0) != 0);
        this.slotFutures.put(vertex, futures);
        CompletableFuture[] requestedFutures = new CompletableFuture[futures.length];
        for (int i = 0; i < futures.length; ++i) {
            requestedFutures[i] = new CompletableFuture();
        }
        this.slotFutureRequested.put(vertex, requestedFutures);
    }

    public CompletableFuture<Boolean> getSlotRequestedFuture(JobVertexID jobVertexId, int subtaskIndex) {
        return this.slotFutureRequested.get(jobVertexId)[subtaskIndex];
    }

    public CompletableFuture<SimpleSlot> allocateSlot(ScheduledUnit task, boolean allowQueued, Collection<TaskManagerLocation> preferredLocations) {
        CompletableFuture<SimpleSlot> future;
        JobVertexID vertexId = task.getTaskToExecute().getVertex().getJobvertexId();
        int subtask = task.getTaskToExecute().getParallelSubtaskIndex();
        CompletableFuture<SimpleSlot>[] forTask = this.slotFutures.get(vertexId);
        if (forTask != null && (future = forTask[subtask]) != null) {
            this.slotFutureRequested.get(vertexId)[subtask].complete(true);
            return future;
        }
        throw new IllegalArgumentException("No registered slot future for task " + vertexId + " (" + subtask + ')');
    }
}

