/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.utils;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.blob.TransientBlobKey;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptor;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.PartitionInfo;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.messages.StackTrace;
import org.apache.flink.runtime.messages.StackTraceSampleResponse;

public class SimpleAckingTaskManagerGateway
implements TaskManagerGateway {
    private final String address = UUID.randomUUID().toString();
    private Optional<Consumer<ExecutionAttemptID>> optSubmitCondition = Optional.empty();
    private Optional<Consumer<ExecutionAttemptID>> optCancelCondition = Optional.empty();

    public void setCondition(Consumer<ExecutionAttemptID> predicate) {
        this.optSubmitCondition = Optional.of(predicate);
    }

    public void setCancelCondition(Consumer<ExecutionAttemptID> predicate) {
        this.optCancelCondition = Optional.of(predicate);
    }

    public String getAddress() {
        return this.address;
    }

    public void disconnectFromJobManager(InstanceID instanceId, Exception cause) {
    }

    public void stopCluster(ApplicationStatus applicationStatus, String message) {
    }

    public CompletableFuture<StackTrace> requestStackTrace(Time timeout) {
        return FutureUtils.completedExceptionally((Throwable)new UnsupportedOperationException());
    }

    public CompletableFuture<StackTraceSampleResponse> requestStackTraceSample(ExecutionAttemptID executionAttemptID, int sampleId, int numSamples, Time delayBetweenSamples, int maxStackTraceDepth, Time timeout) {
        return FutureUtils.completedExceptionally((Throwable)new UnsupportedOperationException());
    }

    public CompletableFuture<Acknowledge> submitTask(TaskDeploymentDescriptor tdd, Time timeout) {
        this.optSubmitCondition.ifPresent(condition -> condition.accept(tdd.getExecutionAttemptId()));
        return CompletableFuture.completedFuture(Acknowledge.get());
    }

    public CompletableFuture<Acknowledge> stopTask(ExecutionAttemptID executionAttemptID, Time timeout) {
        return CompletableFuture.completedFuture(Acknowledge.get());
    }

    public CompletableFuture<Acknowledge> cancelTask(ExecutionAttemptID executionAttemptID, Time timeout) {
        this.optCancelCondition.ifPresent(condition -> condition.accept(executionAttemptID));
        return CompletableFuture.completedFuture(Acknowledge.get());
    }

    public CompletableFuture<Acknowledge> updatePartitions(ExecutionAttemptID executionAttemptID, Iterable<PartitionInfo> partitionInfos, Time timeout) {
        return CompletableFuture.completedFuture(Acknowledge.get());
    }

    public void failPartition(ExecutionAttemptID executionAttemptID) {
    }

    public void notifyCheckpointComplete(ExecutionAttemptID executionAttemptID, JobID jobId, long checkpointId, long timestamp) {
    }

    public void triggerCheckpoint(ExecutionAttemptID executionAttemptID, JobID jobId, long checkpointId, long timestamp, CheckpointOptions checkpointOptions) {
    }

    public CompletableFuture<TransientBlobKey> requestTaskManagerLog(Time timeout) {
        return FutureUtils.completedExceptionally((Throwable)new UnsupportedOperationException());
    }

    public CompletableFuture<TransientBlobKey> requestTaskManagerStdout(Time timeout) {
        return FutureUtils.completedExceptionally((Throwable)new UnsupportedOperationException());
    }
}

