/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.filecache;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.Future;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.cache.DistributedCache;
import org.apache.flink.runtime.filecache.FileCache;
import org.apache.flink.shaded.guava18.com.google.common.base.Charsets;
import org.apache.flink.shaded.guava18.com.google.common.io.Files;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FileCacheDeleteValidationTest {
    private static final String testFileContent = "Goethe - Faust: Der Tragoedie erster Teil\nProlog im Himmel.\nDer Herr. Die himmlischen Heerscharen. Nachher Mephistopheles. Die drei\nErzengel treten vor.\nRAPHAEL: Die Sonne toent, nach alter Weise, In Brudersphaeren Wettgesang,\nUnd ihre vorgeschriebne Reise Vollendet sie mit Donnergang. Ihr Anblick\ngibt den Engeln Staerke, Wenn keiner Sie ergruenden mag; die unbegreiflich\nhohen Werke Sind herrlich wie am ersten Tag.\nGABRIEL: Und schnell und unbegreiflich schnelle Dreht sich umher der Erde\nPracht; Es wechselt Paradieseshelle Mit tiefer, schauervoller Nacht. Es\nschaeumt das Meer in breiten Fluessen Am tiefen Grund der Felsen auf, Und\nFels und Meer wird fortgerissen Im ewig schnellem Sphaerenlauf.\nMICHAEL: Und Stuerme brausen um die Wette Vom Meer aufs Land, vom Land\naufs Meer, und bilden wuetend eine Kette Der tiefsten Wirkung rings umher.\nDa flammt ein blitzendes Verheeren Dem Pfade vor des Donnerschlags. Doch\ndeine Boten, Herr, verehren Das sanfte Wandeln deines Tags.\n";
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private FileCache fileCache;
    private File f;

    @Before
    public void setup() throws IOException {
        String[] tmpDirectories = new String[]{this.temporaryFolder.newFolder().getAbsolutePath()};
        try {
            this.fileCache = new FileCache(tmpDirectories);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Cannot create FileCache: " + e.getMessage()));
        }
        this.f = this.temporaryFolder.newFile("cacheFile");
        try {
            Files.write((CharSequence)testFileContent, (File)this.f, (Charset)Charsets.UTF_8);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the test: " + e.getMessage()));
        }
    }

    @After
    public void shutdown() {
        try {
            this.fileCache.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("FileCache shutdown failed: " + e.getMessage()));
        }
    }

    @Test
    public void testFileReuseForNextTask() {
        try {
            JobID jobID = new JobID();
            String fileName = "test_file";
            String filePath = this.f.toURI().toString();
            Future copyResult = this.fileCache.createTmpFile("test_file", new DistributedCache.DistributedCacheEntry(filePath, Boolean.valueOf(false)), jobID);
            copyResult.get();
            Future copyResult2 = this.fileCache.createTmpFile("test_file", new DistributedCache.DistributedCacheEntry(filePath, Boolean.valueOf(false)), jobID);
            Assert.assertTrue((boolean)copyResult2.isDone());
            this.fileCache.deleteTmpFile("test_file", jobID);
            Assert.assertTrue((boolean)this.fileCache.holdsStillReference("test_file", jobID));
            this.fileCache.deleteTmpFile("test_file", jobID);
            Assert.assertTrue((boolean)this.fileCache.holdsStillReference("test_file", jobID));
            this.fileCache.createTmpFile("test_file", new DistributedCache.DistributedCacheEntry(filePath, Boolean.valueOf(false)), jobID);
            this.fileCache.deleteTmpFile("test_file", jobID);
            long deadline = System.currentTimeMillis() + 20000L;
            do {
                Thread.sleep(5500L);
            } while (this.fileCache.holdsStillReference("test_file", jobID) && System.currentTimeMillis() < deadline);
            Assert.assertFalse((boolean)this.fileCache.holdsStillReference("test_file", jobID));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

