/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability.nonha.embedded;

import java.util.UUID;
import junit.framework.TestCase;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.highavailability.nonha.embedded.EmbeddedHaServices;
import org.apache.flink.runtime.leaderelection.LeaderContender;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalListener;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.util.TestLogger;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class EmbeddedHaServicesTest
extends TestLogger {
    private EmbeddedHaServices embeddedHaServices;

    @Before
    public void setupTest() {
        this.embeddedHaServices = new EmbeddedHaServices(Executors.directExecutor());
    }

    @After
    public void teardownTest() throws Exception {
        if (this.embeddedHaServices != null) {
            this.embeddedHaServices.closeAndCleanupAllData();
            this.embeddedHaServices = null;
        }
    }

    @Test
    public void testJobManagerLeaderElection() throws Exception {
        JobID jobId1 = new JobID();
        JobID jobId2 = new JobID();
        LeaderContender leaderContender1 = (LeaderContender)Mockito.mock(LeaderContender.class);
        LeaderContender leaderContender2 = (LeaderContender)Mockito.mock(LeaderContender.class);
        LeaderContender leaderContenderDifferentJobId = (LeaderContender)Mockito.mock(LeaderContender.class);
        LeaderElectionService leaderElectionService1 = this.embeddedHaServices.getJobManagerLeaderElectionService(jobId1);
        LeaderElectionService leaderElectionService2 = this.embeddedHaServices.getJobManagerLeaderElectionService(jobId1);
        LeaderElectionService leaderElectionServiceDifferentJobId = this.embeddedHaServices.getJobManagerLeaderElectionService(jobId2);
        leaderElectionService1.start(leaderContender1);
        leaderElectionService2.start(leaderContender2);
        leaderElectionServiceDifferentJobId.start(leaderContenderDifferentJobId);
        ArgumentCaptor leaderIdArgumentCaptor1 = ArgumentCaptor.forClass(UUID.class);
        ArgumentCaptor leaderIdArgumentCaptor2 = ArgumentCaptor.forClass(UUID.class);
        ((LeaderContender)Mockito.verify((Object)leaderContender1, (VerificationMode)Mockito.atLeast((int)0))).grantLeadership((UUID)leaderIdArgumentCaptor1.capture());
        ((LeaderContender)Mockito.verify((Object)leaderContender2, (VerificationMode)Mockito.atLeast((int)0))).grantLeadership((UUID)leaderIdArgumentCaptor2.capture());
        TestCase.assertTrue((boolean)(leaderIdArgumentCaptor1.getAllValues().isEmpty() ^ leaderIdArgumentCaptor2.getAllValues().isEmpty()));
        ((LeaderContender)Mockito.verify((Object)leaderContenderDifferentJobId)).grantLeadership((UUID)Matchers.any(UUID.class));
    }

    @Test
    public void testResourceManagerLeaderElection() throws Exception {
        LeaderContender leaderContender1 = (LeaderContender)Mockito.mock(LeaderContender.class);
        LeaderContender leaderContender2 = (LeaderContender)Mockito.mock(LeaderContender.class);
        LeaderElectionService leaderElectionService1 = this.embeddedHaServices.getResourceManagerLeaderElectionService();
        LeaderElectionService leaderElectionService2 = this.embeddedHaServices.getResourceManagerLeaderElectionService();
        leaderElectionService1.start(leaderContender1);
        leaderElectionService2.start(leaderContender2);
        ArgumentCaptor leaderIdArgumentCaptor1 = ArgumentCaptor.forClass(UUID.class);
        ArgumentCaptor leaderIdArgumentCaptor2 = ArgumentCaptor.forClass(UUID.class);
        ((LeaderContender)Mockito.verify((Object)leaderContender1, (VerificationMode)Mockito.atLeast((int)0))).grantLeadership((UUID)leaderIdArgumentCaptor1.capture());
        ((LeaderContender)Mockito.verify((Object)leaderContender2, (VerificationMode)Mockito.atLeast((int)0))).grantLeadership((UUID)leaderIdArgumentCaptor2.capture());
        TestCase.assertTrue((boolean)(leaderIdArgumentCaptor1.getAllValues().isEmpty() ^ leaderIdArgumentCaptor2.getAllValues().isEmpty()));
    }

    @Test
    public void testJobManagerLeaderRetrieval() throws Exception {
        String address = "foobar";
        JobID jobId = new JobID();
        LeaderRetrievalListener leaderRetrievalListener = (LeaderRetrievalListener)Mockito.mock(LeaderRetrievalListener.class);
        LeaderContender leaderContender = (LeaderContender)Mockito.mock(LeaderContender.class);
        Mockito.when((Object)leaderContender.getAddress()).thenReturn((Object)"foobar");
        LeaderElectionService leaderElectionService = this.embeddedHaServices.getJobManagerLeaderElectionService(jobId);
        LeaderRetrievalService leaderRetrievalService = this.embeddedHaServices.getJobManagerLeaderRetriever(jobId);
        leaderRetrievalService.start(leaderRetrievalListener);
        leaderElectionService.start(leaderContender);
        ArgumentCaptor leaderIdArgumentCaptor = ArgumentCaptor.forClass(UUID.class);
        ((LeaderContender)Mockito.verify((Object)leaderContender)).grantLeadership((UUID)leaderIdArgumentCaptor.capture());
        UUID leaderId = (UUID)leaderIdArgumentCaptor.getValue();
        leaderElectionService.confirmLeaderSessionID(leaderId);
        ((LeaderRetrievalListener)Mockito.verify((Object)leaderRetrievalListener)).notifyLeaderAddress((String)Matchers.eq((Object)"foobar"), (UUID)Matchers.eq((Object)leaderId));
    }

    @Test
    public void testResourceManagerLeaderRetrieval() throws Exception {
        String address = "foobar";
        LeaderRetrievalListener leaderRetrievalListener = (LeaderRetrievalListener)Mockito.mock(LeaderRetrievalListener.class);
        LeaderContender leaderContender = (LeaderContender)Mockito.mock(LeaderContender.class);
        Mockito.when((Object)leaderContender.getAddress()).thenReturn((Object)"foobar");
        LeaderElectionService leaderElectionService = this.embeddedHaServices.getResourceManagerLeaderElectionService();
        LeaderRetrievalService leaderRetrievalService = this.embeddedHaServices.getResourceManagerLeaderRetriever();
        leaderRetrievalService.start(leaderRetrievalListener);
        leaderElectionService.start(leaderContender);
        ArgumentCaptor leaderIdArgumentCaptor = ArgumentCaptor.forClass(UUID.class);
        ((LeaderContender)Mockito.verify((Object)leaderContender)).grantLeadership((UUID)leaderIdArgumentCaptor.capture());
        UUID leaderId = (UUID)leaderIdArgumentCaptor.getValue();
        leaderElectionService.confirmLeaderSessionID(leaderId);
        ((LeaderRetrievalListener)Mockito.verify((Object)leaderRetrievalListener)).notifyLeaderAddress((String)Matchers.eq((Object)"foobar"), (UUID)Matchers.eq((Object)leaderId));
    }
}

