/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability.nonha.leaderelection;

import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Executor;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.highavailability.nonha.leaderelection.SingleLeaderElectionService;
import org.apache.flink.runtime.leaderelection.LeaderContender;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalListener;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class SingleLeaderElectionServiceTest {
    private static final Random RND = new Random();
    private final Executor executor = Executors.directExecutor();

    @Test
    public void testStartStopAssignLeadership() throws Exception {
        UUID uuid = UUID.randomUUID();
        SingleLeaderElectionService service = new SingleLeaderElectionService(this.executor, uuid);
        LeaderContender contender = SingleLeaderElectionServiceTest.mockContender((LeaderElectionService)service);
        LeaderContender otherContender = SingleLeaderElectionServiceTest.mockContender((LeaderElectionService)service);
        service.start(contender);
        ((LeaderContender)Mockito.verify((Object)contender, (VerificationMode)Mockito.times((int)1))).grantLeadership(uuid);
        service.stop();
        ((LeaderContender)Mockito.verify((Object)contender, (VerificationMode)Mockito.times((int)1))).revokeLeadership();
        service.start(otherContender);
        ((LeaderContender)Mockito.verify((Object)otherContender, (VerificationMode)Mockito.times((int)1))).grantLeadership(uuid);
        ((LeaderContender)Mockito.verify((Object)contender, (VerificationMode)Mockito.times((int)1))).grantLeadership(uuid);
        ((LeaderContender)Mockito.verify((Object)contender, (VerificationMode)Mockito.times((int)1))).revokeLeadership();
    }

    @Test
    public void testStopBeforeConfirmingLeadership() throws Exception {
        UUID uuid = UUID.randomUUID();
        SingleLeaderElectionService service = new SingleLeaderElectionService(this.executor, uuid);
        LeaderContender contender = (LeaderContender)Mockito.mock(LeaderContender.class);
        service.start(contender);
        ((LeaderContender)Mockito.verify((Object)contender, (VerificationMode)Mockito.times((int)1))).grantLeadership(uuid);
        service.stop();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{contender});
    }

    @Test
    public void testStartOnlyOnce() throws Exception {
        UUID uuid = UUID.randomUUID();
        SingleLeaderElectionService service = new SingleLeaderElectionService(this.executor, uuid);
        LeaderContender contender = (LeaderContender)Mockito.mock(LeaderContender.class);
        LeaderContender otherContender = (LeaderContender)Mockito.mock(LeaderContender.class);
        service.start(contender);
        ((LeaderContender)Mockito.verify((Object)contender, (VerificationMode)Mockito.times((int)1))).grantLeadership(uuid);
        try {
            service.start(otherContender);
            Assert.fail((String)"should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            service.start(contender);
            Assert.fail((String)"should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testShutdown() throws Exception {
        UUID uuid = UUID.randomUUID();
        SingleLeaderElectionService service = new SingleLeaderElectionService(this.executor, uuid);
        LeaderContender contender = SingleLeaderElectionServiceTest.mockContender((LeaderElectionService)service);
        service.start(contender);
        ((LeaderContender)Mockito.verify((Object)contender, (VerificationMode)Mockito.times((int)1))).grantLeadership(uuid);
        LeaderRetrievalListener listener1 = (LeaderRetrievalListener)Mockito.mock(LeaderRetrievalListener.class);
        LeaderRetrievalListener listener2 = (LeaderRetrievalListener)Mockito.mock(LeaderRetrievalListener.class);
        LeaderRetrievalService listenerService1 = service.createLeaderRetrievalService();
        LeaderRetrievalService listenerService2 = service.createLeaderRetrievalService();
        listenerService1.start(listener1);
        listenerService2.start(listener2);
        listenerService1.stop();
        service.shutdown();
        ((LeaderContender)Mockito.verify((Object)contender, (VerificationMode)Mockito.times((int)1))).handleError((Exception)Mockito.any(Exception.class));
        ((LeaderRetrievalListener)Mockito.verify((Object)listener2, (VerificationMode)Mockito.times((int)1))).handleError((Exception)Mockito.any(Exception.class));
        ((LeaderRetrievalListener)Mockito.verify((Object)listener1, (VerificationMode)Mockito.times((int)0))).handleError((Exception)Mockito.any(Exception.class));
        try {
            service.start(contender);
            Assert.fail((String)"should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ((LeaderContender)Mockito.verify((Object)contender, (VerificationMode)Mockito.times((int)1))).grantLeadership((UUID)Mockito.any(UUID.class));
    }

    @Test
    public void testImmediateShutdown() throws Exception {
        UUID uuid = UUID.randomUUID();
        SingleLeaderElectionService service = new SingleLeaderElectionService(this.executor, uuid);
        service.shutdown();
        LeaderContender contender = (LeaderContender)Mockito.mock(LeaderContender.class);
        try {
            service.start(contender);
            Assert.fail((String)"should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ((LeaderContender)Mockito.verify((Object)contender, (VerificationMode)Mockito.times((int)0))).grantLeadership((UUID)Mockito.any(UUID.class));
    }

    private static LeaderContender mockContender(LeaderElectionService service) {
        String address = StringUtils.getRandomString((Random)RND, (int)5, (int)10, (char)'a', (char)'z');
        return SingleLeaderElectionServiceTest.mockContender(service, address);
    }

    private static LeaderContender mockContender(final LeaderElectionService service, String address) {
        LeaderContender mockContender = (LeaderContender)Mockito.mock(LeaderContender.class);
        Mockito.when((Object)mockContender.getAddress()).thenReturn((Object)address);
        ((LeaderContender)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                UUID uuid = (UUID)invocation.getArguments()[0];
                service.confirmLeaderSessionID(uuid);
                return null;
            }
        }).when((Object)mockContender)).grantLeadership((UUID)Mockito.any(UUID.class));
        return mockContender;
    }
}

