/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network;

import org.apache.flink.api.common.JobID;
import org.apache.flink.core.memory.MemoryType;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.ConnectionManager;
import org.apache.flink.runtime.io.network.LocalConnectionManager;
import org.apache.flink.runtime.io.network.NetworkEnvironment;
import org.apache.flink.runtime.io.network.TaskEventDispatcher;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.buffer.NetworkBufferPool;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionConsumableNotifier;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.runtime.query.KvStateRegistry;
import org.apache.flink.runtime.taskmanager.Task;
import org.apache.flink.runtime.taskmanager.TaskActions;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class NetworkEnvironmentTest {
    private static final int numBuffers = 1024;
    private static final int memorySegmentSize = 128;

    @Test
    public void testRegisterTaskUsesBoundedBuffers() throws Exception {
        NetworkEnvironment network = new NetworkEnvironment(new NetworkBufferPool(1024, 128, MemoryType.HEAP), (ConnectionManager)new LocalConnectionManager(), new ResultPartitionManager(), new TaskEventDispatcher(), new KvStateRegistry(), null, null, IOManager.IOMode.SYNC, 0, 0, 2, 8);
        ResultPartition rp1 = NetworkEnvironmentTest.createResultPartition(ResultPartitionType.PIPELINED, 2);
        ResultPartition rp2 = NetworkEnvironmentTest.createResultPartition(ResultPartitionType.BLOCKING, 2);
        ResultPartition rp3 = NetworkEnvironmentTest.createResultPartition(ResultPartitionType.PIPELINED_BOUNDED, 2);
        ResultPartition rp4 = NetworkEnvironmentTest.createResultPartition(ResultPartitionType.PIPELINED_BOUNDED, 8);
        ResultPartition[] resultPartitions = new ResultPartition[]{rp1, rp2, rp3, rp4};
        ResultPartitionWriter[] resultPartitionWriters = new ResultPartitionWriter[]{new ResultPartitionWriter(rp1), new ResultPartitionWriter(rp2), new ResultPartitionWriter(rp3), new ResultPartitionWriter(rp4)};
        SingleInputGate ig1 = NetworkEnvironmentTest.createSingleInputGateMock(ResultPartitionType.PIPELINED, 2);
        SingleInputGate ig2 = NetworkEnvironmentTest.createSingleInputGateMock(ResultPartitionType.BLOCKING, 2);
        SingleInputGate ig3 = NetworkEnvironmentTest.createSingleInputGateMock(ResultPartitionType.PIPELINED_BOUNDED, 2);
        SingleInputGate ig4 = NetworkEnvironmentTest.createSingleInputGateMock(ResultPartitionType.PIPELINED_CREDIT_BASED, 8);
        SingleInputGate[] inputGates = new SingleInputGate[]{ig1, ig2, ig3, ig4};
        Task task = (Task)Mockito.mock(Task.class);
        Mockito.when((Object)task.getProducedPartitions()).thenReturn((Object)resultPartitions);
        Mockito.when((Object)task.getAllWriters()).thenReturn((Object)resultPartitionWriters);
        Mockito.when((Object)task.getAllInputGates()).thenReturn((Object)inputGates);
        network.registerTask(task);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)rp1.getBufferPool().getMaxNumberOfMemorySegments());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)rp2.getBufferPool().getMaxNumberOfMemorySegments());
        Assert.assertEquals((long)12L, (long)rp3.getBufferPool().getMaxNumberOfMemorySegments());
        Assert.assertEquals((long)24L, (long)rp4.getBufferPool().getMaxNumberOfMemorySegments());
        ((SingleInputGate)Mockito.verify((Object)ig4, (VerificationMode)Mockito.times((int)1))).assignExclusiveSegments(network.getNetworkBufferPool(), 2);
        network.shutdown();
    }

    private static ResultPartition createResultPartition(ResultPartitionType partitionType, int channels) {
        return new ResultPartition("TestTask-" + partitionType + ":" + channels, (TaskActions)Mockito.mock(TaskActions.class), new JobID(), new ResultPartitionID(), partitionType, channels, channels, (ResultPartitionManager)Mockito.mock(ResultPartitionManager.class), (ResultPartitionConsumableNotifier)Mockito.mock(ResultPartitionConsumableNotifier.class), (IOManager)Mockito.mock(IOManager.class), false);
    }

    private static SingleInputGate createSingleInputGateMock(final ResultPartitionType partitionType, final int channels) {
        SingleInputGate ig = (SingleInputGate)Mockito.mock(SingleInputGate.class);
        Mockito.when((Object)ig.getConsumedPartitionType()).thenReturn((Object)partitionType);
        Mockito.when((Object)ig.getNumberOfInputChannels()).thenReturn((Object)channels);
        ((SingleInputGate)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                BufferPool bp = (BufferPool)invocation.getArgumentAt(0, BufferPool.class);
                if (partitionType == ResultPartitionType.PIPELINED_BOUNDED) {
                    Assert.assertEquals((long)(channels * 2 + 8), (long)bp.getMaxNumberOfMemorySegments());
                } else if (partitionType == ResultPartitionType.PIPELINED_CREDIT_BASED) {
                    Assert.assertEquals((long)8L, (long)bp.getMaxNumberOfMemorySegments());
                } else {
                    Assert.assertEquals((long)Integer.MAX_VALUE, (long)bp.getMaxNumberOfMemorySegments());
                }
                return null;
            }
        }).when((Object)ig)).setBufferPool((BufferPool)Matchers.any(BufferPool.class));
        return ig;
    }
}

