/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.serialization;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.memory.AbstractPagedInputView;
import org.apache.flink.runtime.memory.AbstractPagedOutputView;
import org.apache.flink.testutils.serialization.types.SerializationTestType;
import org.apache.flink.testutils.serialization.types.SerializationTestTypeFactory;
import org.apache.flink.testutils.serialization.types.Util;
import org.junit.Assert;
import org.junit.Test;

public class PagedViewsTest {
    @Test
    public void testSequenceOfIntegersWithAlignedBuffers() {
        try {
            int NUM_INTS = 1000000;
            PagedViewsTest.testSequenceOfTypes((Iterable<SerializationTestType>)Util.randomRecords((int)1000000, (SerializationTestTypeFactory)SerializationTestTypeFactory.INT), 2048);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Test encountered an unexpected exception.");
        }
    }

    @Test
    public void testSequenceOfIntegersWithUnalignedBuffers() {
        try {
            int NUM_INTS = 1000000;
            PagedViewsTest.testSequenceOfTypes((Iterable<SerializationTestType>)Util.randomRecords((int)1000000, (SerializationTestTypeFactory)SerializationTestTypeFactory.INT), 2047);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Test encountered an unexpected exception.");
        }
    }

    @Test
    public void testRandomTypes() {
        try {
            int NUM_TYPES = 100000;
            PagedViewsTest.testSequenceOfTypes((Iterable<SerializationTestType>)Util.randomRecords((int)100000), 57);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Test encountered an unexpected exception.");
        }
    }

    @Test
    public void testReadFully() {
        int bufferSize = 100;
        byte[] expected = new byte[bufferSize];
        new Random().nextBytes(expected);
        TestOutputView outputView = new TestOutputView(bufferSize);
        try {
            outputView.write(expected);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception: Could not write to TestOutputView.");
        }
        outputView.close();
        TestInputView inputView = new TestInputView(outputView.segments);
        byte[] buffer = new byte[bufferSize];
        try {
            inputView.readFully(buffer);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception: Could not read TestInputView.");
        }
        Assert.assertEquals((long)inputView.getCurrentPositionInSegment(), (long)bufferSize);
        Assert.assertArrayEquals((byte[])expected, (byte[])buffer);
    }

    @Test
    public void testReadFullyAcrossSegments() {
        int bufferSize = 100;
        int segmentSize = 30;
        byte[] expected = new byte[bufferSize];
        new Random().nextBytes(expected);
        TestOutputView outputView = new TestOutputView(segmentSize);
        try {
            outputView.write(expected);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception: Could not write to TestOutputView.");
        }
        outputView.close();
        TestInputView inputView = new TestInputView(outputView.segments);
        byte[] buffer = new byte[bufferSize];
        try {
            inputView.readFully(buffer);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception: Could not read TestInputView.");
        }
        Assert.assertEquals((long)inputView.getCurrentPositionInSegment(), (long)(bufferSize % segmentSize));
        Assert.assertArrayEquals((byte[])expected, (byte[])buffer);
    }

    @Test
    public void testReadAcrossSegments() {
        int bufferSize = 100;
        int bytes2Write = 75;
        int segmentSize = 30;
        byte[] expected = new byte[bytes2Write];
        new Random().nextBytes(expected);
        TestOutputView outputView = new TestOutputView(segmentSize);
        try {
            outputView.write(expected);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception: Could not write to TestOutputView.");
        }
        outputView.close();
        TestInputView inputView = new TestInputView(outputView.segments);
        byte[] buffer = new byte[bufferSize];
        int bytesRead = 0;
        try {
            bytesRead = inputView.read(buffer);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception: Could not read TestInputView.");
        }
        Assert.assertEquals((long)bytes2Write, (long)bytesRead);
        Assert.assertEquals((long)inputView.getCurrentPositionInSegment(), (long)(bytes2Write % segmentSize));
        byte[] tempBuffer = new byte[bytesRead];
        System.arraycopy(buffer, 0, tempBuffer, 0, bytesRead);
        Assert.assertArrayEquals((byte[])expected, (byte[])tempBuffer);
    }

    @Test
    public void testEmptyingInputView() {
        int bufferSize = 100;
        int bytes2Write = 75;
        int segmentSize = 30;
        byte[] expected = new byte[bytes2Write];
        new Random().nextBytes(expected);
        TestOutputView outputView = new TestOutputView(segmentSize);
        try {
            outputView.write(expected);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception: Could not write to TestOutputView.");
        }
        outputView.close();
        TestInputView inputView = new TestInputView(outputView.segments);
        byte[] buffer = new byte[bufferSize];
        int bytesRead = 0;
        try {
            bytesRead = inputView.read(buffer);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception: Could not read TestInputView.");
        }
        Assert.assertEquals((long)bytes2Write, (long)bytesRead);
        byte[] tempBuffer = new byte[bytesRead];
        System.arraycopy(buffer, 0, tempBuffer, 0, bytesRead);
        Assert.assertArrayEquals((byte[])expected, (byte[])tempBuffer);
        try {
            bytesRead = inputView.read(buffer);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception: Input view should be empty and thus return -1.");
        }
        Assert.assertEquals((long)-1L, (long)bytesRead);
        Assert.assertEquals((long)inputView.getCurrentPositionInSegment(), (long)(bytes2Write % segmentSize));
    }

    @Test
    public void testReadFullyWithNotEnoughData() {
        int bufferSize = 100;
        int bytes2Write = 99;
        int segmentSize = 30;
        byte[] expected = new byte[bytes2Write];
        new Random().nextBytes(expected);
        TestOutputView outputView = new TestOutputView(segmentSize);
        try {
            outputView.write(expected);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception: Could not write to TestOutputView.");
        }
        outputView.close();
        TestInputView inputView = new TestInputView(outputView.segments);
        byte[] buffer = new byte[bufferSize];
        boolean eofException = false;
        try {
            inputView.readFully(buffer);
        }
        catch (EOFException e) {
            eofException = true;
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception: Could not read TestInputView.");
        }
        Assert.assertTrue((String)"EOFException should have occurred.", (boolean)eofException);
        int bytesRead = 0;
        try {
            bytesRead = inputView.read(buffer);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception: Could not read TestInputView.");
        }
        Assert.assertEquals((long)-1L, (long)bytesRead);
    }

    @Test
    public void testReadFullyWithOffset() {
        int bufferSize = 100;
        int segmentSize = 30;
        byte[] expected = new byte[bufferSize];
        new Random().nextBytes(expected);
        TestOutputView outputView = new TestOutputView(segmentSize);
        try {
            outputView.write(expected);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception: Could not write to TestOutputView.");
        }
        outputView.close();
        TestInputView inputView = new TestInputView(outputView.segments);
        byte[] buffer = new byte[2 * bufferSize];
        try {
            inputView.readFully(buffer, bufferSize, bufferSize);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception: Could not read TestInputView.");
        }
        Assert.assertEquals((long)inputView.getCurrentPositionInSegment(), (long)(bufferSize % segmentSize));
        byte[] tempBuffer = new byte[bufferSize];
        System.arraycopy(buffer, bufferSize, tempBuffer, 0, bufferSize);
        Assert.assertArrayEquals((byte[])expected, (byte[])tempBuffer);
    }

    @Test
    public void testReadFullyEmptyView() {
        int segmentSize = 30;
        TestOutputView outputView = new TestOutputView(segmentSize);
        outputView.close();
        TestInputView inputView = new TestInputView(outputView.segments);
        byte[] buffer = new byte[segmentSize];
        boolean eofException = false;
        try {
            inputView.readFully(buffer);
        }
        catch (EOFException e) {
            eofException = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception: Could not read TestInputView.");
        }
        Assert.assertTrue((String)"EOFException expected.", (boolean)eofException);
    }

    private static void testSequenceOfTypes(Iterable<SerializationTestType> sequence, int segmentSize) throws Exception {
        ArrayList<SerializationTestType> elements = new ArrayList<SerializationTestType>(512);
        TestOutputView outView = new TestOutputView(segmentSize);
        for (SerializationTestType type : sequence) {
            type.write((DataOutputView)outView);
            elements.add(type);
        }
        outView.close();
        TestInputView inView = new TestInputView(outView.segments);
        for (SerializationTestType reference : elements) {
            SerializationTestType result = (SerializationTestType)reference.getClass().newInstance();
            result.read((DataInputView)inView);
            Assert.assertEquals((Object)reference, (Object)result);
        }
    }

    private static final class TestInputView
    extends AbstractPagedInputView {
        private final List<SegmentWithPosition> segments;
        private int num;

        private TestInputView(List<SegmentWithPosition> segments) {
            super(segments.get(0).segment, segments.get(0).position, 0);
            this.segments = segments;
            this.num = 0;
        }

        protected MemorySegment nextSegment(MemorySegment current) throws IOException {
            ++this.num;
            if (this.num < this.segments.size()) {
                return this.segments.get(this.num).segment;
            }
            throw new EOFException();
        }

        protected int getLimitForSegment(MemorySegment segment) {
            return this.segments.get(this.num).position;
        }
    }

    private static final class TestOutputView
    extends AbstractPagedOutputView {
        private final List<SegmentWithPosition> segments = new ArrayList<SegmentWithPosition>();
        private final int segmentSize;

        private TestOutputView(int segmentSize) {
            super(MemorySegmentFactory.allocateUnpooledSegment((int)segmentSize), segmentSize, 0);
            this.segmentSize = segmentSize;
        }

        protected MemorySegment nextSegment(MemorySegment current, int positionInCurrent) throws IOException {
            this.segments.add(new SegmentWithPosition(current, positionInCurrent));
            return MemorySegmentFactory.allocateUnpooledSegment((int)this.segmentSize);
        }

        public void close() {
            this.segments.add(new SegmentWithPosition(this.getCurrentSegment(), this.getCurrentPositionInSegment()));
        }
    }

    private static final class SegmentWithPosition {
        private final MemorySegment segment;
        private final int position;

        public SegmentWithPosition(MemorySegment segment, int position) {
            this.segment = segment;
            this.position = position;
        }
    }
}

