/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.core.memory.MemoryType;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.buffer.LocalBufferPool;
import org.apache.flink.runtime.io.network.buffer.NetworkBufferPool;
import org.junit.Assert;
import org.junit.Test;

public class LocalBufferPoolDestroyTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDestroyWhileBlockingRequest() throws Exception {
        AtomicReference<Exception> asyncException = new AtomicReference<Exception>();
        NetworkBufferPool networkBufferPool = null;
        LocalBufferPool localBufferPool = null;
        try {
            StackTraceElement[] stackTrace;
            networkBufferPool = new NetworkBufferPool(1, 4096, MemoryType.HEAP);
            localBufferPool = new LocalBufferPool(networkBufferPool, 1);
            Assert.assertNotNull((Object)localBufferPool.requestBuffer());
            Assert.assertNull((Object)localBufferPool.requestBuffer());
            Thread thread = new Thread(new BufferRequestTask((BufferPool)localBufferPool, asyncException));
            thread.start();
            boolean success = false;
            for (int i = 0; i < 50 && !(success = this.isInBlockingBufferRequest(stackTrace = thread.getStackTrace())); ++i) {
                Thread.sleep(500L);
            }
            Assert.assertTrue((String)"Did not trigger blocking buffer request.", (boolean)success);
            localBufferPool.lazyDestroy();
            thread.join();
            Assert.assertNotNull((String)"Did not throw expected Exception", (Object)asyncException.get());
            Assert.assertTrue((boolean)(asyncException.get() instanceof IllegalStateException));
        }
        finally {
            if (localBufferPool != null) {
                localBufferPool.lazyDestroy();
            }
            if (networkBufferPool != null) {
                networkBufferPool.destroyAllBufferPools();
                networkBufferPool.destroy();
            }
        }
    }

    private boolean isInBlockingBufferRequest(StackTraceElement[] stackTrace) {
        if (stackTrace.length >= 3) {
            return stackTrace[0].getMethodName().equals("wait") && stackTrace[1].getMethodName().equals("requestBuffer") && stackTrace[2].getMethodName().equals("requestBufferBlocking");
        }
        return false;
    }

    private static class BufferRequestTask
    implements Runnable {
        private final BufferPool bufferPool;
        private final AtomicReference<Exception> asyncException;

        public BufferRequestTask(BufferPool bufferPool, AtomicReference<Exception> asyncException) {
            this.bufferPool = bufferPool;
            this.asyncException = asyncException;
        }

        @Override
        public void run() {
            try {
                String msg = "Test assumption violated: expected no available buffer";
                Assert.assertNull((String)msg, (Object)this.bufferPool.requestBuffer());
                this.bufferPool.requestBufferBlocking();
            }
            catch (Exception t) {
                this.asyncException.set(t);
            }
        }
    }
}

