/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferListener;
import org.apache.flink.runtime.io.network.buffer.BufferProvider;
import org.apache.flink.runtime.io.network.netty.NettyMessage;
import org.apache.flink.runtime.io.network.netty.PartitionRequestClientHandler;
import org.apache.flink.runtime.io.network.partition.PartitionNotFoundException;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannelID;
import org.apache.flink.runtime.io.network.partition.consumer.RemoteInputChannel;
import org.apache.flink.runtime.io.network.util.TestBufferFactory;
import org.apache.flink.runtime.testutils.DiscardingRecycler;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBufAllocator;
import org.apache.flink.shaded.netty4.io.netty.buffer.UnpooledByteBufAllocator;
import org.apache.flink.shaded.netty4.io.netty.channel.Channel;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.channel.embedded.EmbeddedChannel;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class PartitionRequestClientHandlerTest {
    @Test(timeout=60000L)
    public void testReleaseInputChannelDuringDecode() throws Exception {
        BufferProvider bufferProvider = (BufferProvider)Mockito.mock(BufferProvider.class);
        Mockito.when((Object)bufferProvider.requestBuffer()).thenReturn(null);
        Mockito.when((Object)bufferProvider.isDestroyed()).thenReturn((Object)true);
        Mockito.when((Object)bufferProvider.addBufferListener((BufferListener)Matchers.any(BufferListener.class))).thenReturn((Object)false);
        RemoteInputChannel inputChannel = (RemoteInputChannel)Mockito.mock(RemoteInputChannel.class);
        Mockito.when((Object)inputChannel.getInputChannelId()).thenReturn((Object)new InputChannelID());
        Mockito.when((Object)inputChannel.getBufferProvider()).thenReturn((Object)bufferProvider);
        NettyMessage.BufferResponse ReceivedBuffer = this.createBufferResponse(TestBufferFactory.createBuffer(), 0, inputChannel.getInputChannelId());
        PartitionRequestClientHandler client = new PartitionRequestClientHandler();
        client.addInputChannel(inputChannel);
        client.channelRead((ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class), (Object)ReceivedBuffer);
    }

    @Test
    public void testReceiveEmptyBuffer() throws Exception {
        BufferProvider bufferProvider = (BufferProvider)Mockito.mock(BufferProvider.class);
        Mockito.when((Object)bufferProvider.requestBuffer()).thenReturn((Object)TestBufferFactory.createBuffer());
        RemoteInputChannel inputChannel = (RemoteInputChannel)Mockito.mock(RemoteInputChannel.class);
        Mockito.when((Object)inputChannel.getInputChannelId()).thenReturn((Object)new InputChannelID());
        Mockito.when((Object)inputChannel.getBufferProvider()).thenReturn((Object)bufferProvider);
        Buffer emptyBuffer = TestBufferFactory.createBuffer();
        emptyBuffer.setSize(0);
        NettyMessage.BufferResponse receivedBuffer = this.createBufferResponse(emptyBuffer, 0, inputChannel.getInputChannelId());
        PartitionRequestClientHandler client = new PartitionRequestClientHandler();
        client.addInputChannel(inputChannel);
        client.channelRead((ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class), (Object)receivedBuffer);
        ((RemoteInputChannel)Mockito.verify((Object)inputChannel, (VerificationMode)Mockito.never())).onError((Throwable)Matchers.any(Throwable.class));
    }

    @Test
    public void testReceivePartitionNotFoundException() throws Exception {
        BufferProvider bufferProvider = (BufferProvider)Mockito.mock(BufferProvider.class);
        Mockito.when((Object)bufferProvider.requestBuffer()).thenReturn((Object)TestBufferFactory.createBuffer());
        RemoteInputChannel inputChannel = (RemoteInputChannel)Mockito.mock(RemoteInputChannel.class);
        Mockito.when((Object)inputChannel.getInputChannelId()).thenReturn((Object)new InputChannelID());
        Mockito.when((Object)inputChannel.getBufferProvider()).thenReturn((Object)bufferProvider);
        NettyMessage.ErrorResponse partitionNotFound = new NettyMessage.ErrorResponse((Throwable)new PartitionNotFoundException(new ResultPartitionID()), inputChannel.getInputChannelId());
        PartitionRequestClientHandler client = new PartitionRequestClientHandler();
        client.addInputChannel(inputChannel);
        ChannelHandlerContext ctx = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        Mockito.when((Object)ctx.channel()).thenReturn(Mockito.mock(Channel.class));
        client.channelActive(ctx);
        client.channelRead(ctx, (Object)partitionNotFound);
        ((RemoteInputChannel)Mockito.verify((Object)inputChannel, (VerificationMode)Mockito.times((int)1))).onFailedPartitionRequest();
    }

    @Test
    public void testCancelBeforeActive() throws Exception {
        RemoteInputChannel inputChannel = (RemoteInputChannel)Mockito.mock(RemoteInputChannel.class);
        Mockito.when((Object)inputChannel.getInputChannelId()).thenReturn((Object)new InputChannelID());
        PartitionRequestClientHandler client = new PartitionRequestClientHandler();
        client.addInputChannel(inputChannel);
        client.cancelRequestFor(null);
        client.cancelRequestFor(inputChannel.getInputChannelId());
    }

    @Test
    public void testAutoReadAfterUnsuccessfulStagedMessage() throws Exception {
        PartitionRequestClientHandler handler = new PartitionRequestClientHandler();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{handler});
        final AtomicReference listener = new AtomicReference();
        BufferProvider bufferProvider = (BufferProvider)Mockito.mock(BufferProvider.class);
        Mockito.when((Object)bufferProvider.addBufferListener((BufferListener)Matchers.any(BufferListener.class))).thenAnswer((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                listener.set((BufferListener)invocation.getArguments()[0]);
                return true;
            }
        });
        Mockito.when((Object)bufferProvider.requestBuffer()).thenReturn(null);
        InputChannelID channelId = new InputChannelID(0L, 0L);
        RemoteInputChannel inputChannel = (RemoteInputChannel)Mockito.mock(RemoteInputChannel.class);
        Mockito.when((Object)inputChannel.getInputChannelId()).thenReturn((Object)channelId);
        Mockito.when((Object)inputChannel.getBufferProvider()).thenReturn((Object)bufferProvider, (Object[])new BufferProvider[]{bufferProvider, null});
        handler.addInputChannel(inputChannel);
        NettyMessage.BufferResponse msg = this.createBufferResponse(PartitionRequestClientHandlerTest.createBuffer(true), 0, channelId);
        Assert.assertTrue((boolean)channel.config().isAutoRead());
        channel.writeInbound(new Object[]{msg});
        Assert.assertFalse((boolean)channel.config().isAutoRead());
        msg = this.createBufferResponse(PartitionRequestClientHandlerTest.createBuffer(true), 1, channelId);
        channel.writeInbound(new Object[]{msg});
        msg = this.createBufferResponse(PartitionRequestClientHandlerTest.createBuffer(true), 2, channelId);
        channel.writeInbound(new Object[]{msg});
        Buffer availableBuffer = PartitionRequestClientHandlerTest.createBuffer(false);
        ((BufferListener)listener.get()).notifyBufferAvailable(availableBuffer);
        Mockito.when((Object)bufferProvider.addBufferListener((BufferListener)Matchers.any(BufferListener.class))).thenReturn((Object)false);
        Mockito.when((Object)bufferProvider.isDestroyed()).thenReturn((Object)true);
        channel.runPendingTasks();
        Assert.assertTrue((boolean)channel.config().isAutoRead());
    }

    private static Buffer createBuffer(boolean fill) {
        MemorySegment segment = MemorySegmentFactory.allocateUnpooledSegment((int)1024, null);
        if (fill) {
            for (int i = 0; i < 1024; ++i) {
                segment.put(i, (byte)i);
            }
        }
        return new Buffer(segment, DiscardingRecycler.INSTANCE, true);
    }

    private NettyMessage.BufferResponse createBufferResponse(Buffer buffer, int sequenceNumber, InputChannelID receivingChannelId) throws IOException {
        NettyMessage.BufferResponse resp = new NettyMessage.BufferResponse(buffer, sequenceNumber, receivingChannelId);
        ByteBuf serialized = resp.write((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        serialized.readBytes(9);
        NettyMessage.BufferResponse deserialized = NettyMessage.BufferResponse.readFrom((ByteBuf)serialized);
        return deserialized;
    }
}

