/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import org.apache.flink.runtime.io.network.ConnectionID;
import org.apache.flink.runtime.io.network.ConnectionManager;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.netty.PartitionRequestClient;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

class InputChannelTestUtils {
    public static Buffer createMockBuffer(int size) {
        Buffer mockBuffer = (Buffer)Mockito.mock(Buffer.class);
        Mockito.when((Object)mockBuffer.isBuffer()).thenReturn((Object)true);
        Mockito.when((Object)mockBuffer.getSize()).thenReturn((Object)size);
        Mockito.when((Object)mockBuffer.isRecycled()).thenReturn((Object)false);
        return mockBuffer;
    }

    public static ResultPartitionManager createResultPartitionManager(final ResultSubpartition[] sources) throws Exception {
        Answer<ResultSubpartitionView> viewCreator = new Answer<ResultSubpartitionView>(){
            private int num = 0;

            public ResultSubpartitionView answer(InvocationOnMock invocation) throws Throwable {
                BufferAvailabilityListener channel = (BufferAvailabilityListener)invocation.getArguments()[2];
                return sources[this.num++].createReadView(channel);
            }
        };
        ResultPartitionManager manager = (ResultPartitionManager)Mockito.mock(ResultPartitionManager.class);
        Mockito.when((Object)manager.createSubpartitionView((ResultPartitionID)Matchers.any(ResultPartitionID.class), Matchers.anyInt(), (BufferAvailabilityListener)Matchers.any(BufferAvailabilityListener.class))).thenAnswer((Answer)viewCreator);
        return manager;
    }

    public static ConnectionManager createDummyConnectionManager() throws Exception {
        PartitionRequestClient mockClient = (PartitionRequestClient)Mockito.mock(PartitionRequestClient.class);
        ConnectionManager connManager = (ConnectionManager)Mockito.mock(ConnectionManager.class);
        Mockito.when((Object)connManager.createPartitionRequestClient((ConnectionID)Matchers.any(ConnectionID.class))).thenReturn((Object)mockClient);
        return connManager;
    }

    private InputChannelTestUtils() {
    }
}

