/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.runtime.io.network.util.TestBufferFactory;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public abstract class SubpartitionTestBase
extends TestLogger {
    abstract ResultSubpartition createSubpartition();

    @Test
    public void testAddAfterFinish() throws Exception {
        ResultSubpartition subpartition = this.createSubpartition();
        try {
            subpartition.finish();
            Assert.assertEquals((long)1L, (long)subpartition.getTotalNumberOfBuffers());
            Assert.assertEquals((long)4L, (long)subpartition.getTotalNumberOfBytes());
            Assert.assertFalse((boolean)subpartition.add((Buffer)Mockito.mock(Buffer.class)));
            Assert.assertEquals((long)1L, (long)subpartition.getTotalNumberOfBuffers());
            Assert.assertEquals((long)4L, (long)subpartition.getTotalNumberOfBytes());
        }
        finally {
            if (subpartition != null) {
                subpartition.release();
            }
        }
    }

    @Test
    public void testAddAfterRelease() throws Exception {
        ResultSubpartition subpartition = this.createSubpartition();
        try {
            subpartition.release();
            Assert.assertEquals((long)0L, (long)subpartition.getTotalNumberOfBuffers());
            Assert.assertEquals((long)0L, (long)subpartition.getTotalNumberOfBytes());
            Assert.assertFalse((boolean)subpartition.add((Buffer)Mockito.mock(Buffer.class)));
            Assert.assertEquals((long)0L, (long)subpartition.getTotalNumberOfBuffers());
            Assert.assertEquals((long)0L, (long)subpartition.getTotalNumberOfBytes());
        }
        finally {
            if (subpartition != null) {
                subpartition.release();
            }
        }
    }

    @Test
    public void testReleaseParent() throws Exception {
        ResultSubpartition partition = this.createSubpartition();
        this.verifyViewReleasedAfterParentRelease(partition);
    }

    @Test
    public void testReleaseParentAfterSpilled() throws Exception {
        ResultSubpartition partition = this.createSubpartition();
        partition.releaseMemory();
        this.verifyViewReleasedAfterParentRelease(partition);
    }

    private void verifyViewReleasedAfterParentRelease(ResultSubpartition partition) throws Exception {
        Buffer buffer = TestBufferFactory.createBuffer();
        partition.add(buffer);
        partition.finish();
        BufferAvailabilityListener listener = (BufferAvailabilityListener)Mockito.mock(BufferAvailabilityListener.class);
        ResultSubpartitionView view = partition.createReadView(listener);
        Assert.assertNotNull((Object)view.getNextBuffer());
        Assert.assertNotNull((Object)view.getNextBuffer());
        Assert.assertFalse((boolean)view.isReleased());
        partition.release();
        Assert.assertTrue((boolean)view.isReleased());
    }
}

