/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.util;

import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferListener;
import org.apache.flink.runtime.io.network.buffer.BufferProvider;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.util.TestBufferFactory;

public class TestInfiniteBufferProvider
implements BufferProvider {
    private final ConcurrentLinkedQueue<Buffer> buffers = new ConcurrentLinkedQueue();
    private final TestBufferFactory bufferFactory = new TestBufferFactory(32768, new InfiniteBufferProviderRecycler(this.buffers));

    public Buffer requestBuffer() throws IOException {
        Buffer buffer = this.buffers.poll();
        if (buffer != null) {
            return buffer;
        }
        return this.bufferFactory.create();
    }

    public Buffer requestBufferBlocking() throws IOException, InterruptedException {
        return this.requestBuffer();
    }

    public boolean addBufferListener(BufferListener listener) {
        return false;
    }

    public boolean isDestroyed() {
        return false;
    }

    public int getMemorySegmentSize() {
        return this.bufferFactory.getBufferSize();
    }

    private static class InfiniteBufferProviderRecycler
    implements BufferRecycler {
        private final ConcurrentLinkedQueue<Buffer> buffers;

        public InfiniteBufferProviderRecycler(ConcurrentLinkedQueue<Buffer> buffers) {
            this.buffers = buffers;
        }

        public void recycle(MemorySegment segment) {
            this.buffers.add(new Buffer(segment, (BufferRecycler)this));
        }
    }
}

