/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.memory;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemoryType;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.memory.MemoryAllocationException;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.operators.testutils.DummyInvokable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MemoryManagerLazyAllocationTest {
    private static final long RANDOM_SEED = 643196033469871L;
    private static final int MEMORY_SIZE = 0x4800000;
    private static final int PAGE_SIZE = 32768;
    private static final int NUM_PAGES = 2304;
    private MemoryManager memoryManager;
    private Random random;

    @Before
    public void setUp() {
        this.memoryManager = new MemoryManager(0x4800000L, 1, 32768, MemoryType.HEAP, false);
        this.random = new Random(643196033469871L);
    }

    @After
    public void tearDown() {
        if (!this.memoryManager.verifyEmpty()) {
            Assert.fail((String)"Memory manager is not complete empty and valid at the end of the test.");
        }
        this.memoryManager = null;
        this.random = null;
    }

    @Test
    public void allocateAllSingle() {
        try {
            DummyInvokable mockInvoke = new DummyInvokable();
            ArrayList segments = new ArrayList();
            try {
                for (int i = 0; i < 2304; ++i) {
                    segments.add(this.memoryManager.allocatePages((Object)mockInvoke, 1).get(0));
                }
            }
            catch (MemoryAllocationException e) {
                Assert.fail((String)"Unable to allocate memory");
            }
            for (MemorySegment seg : segments) {
                this.memoryManager.release(seg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void allocateAllMulti() {
        try {
            DummyInvokable mockInvoke = new DummyInvokable();
            ArrayList segments = new ArrayList();
            try {
                for (int i = 0; i < 1152; ++i) {
                    segments.addAll(this.memoryManager.allocatePages((Object)mockInvoke, 2));
                }
            }
            catch (MemoryAllocationException e) {
                Assert.fail((String)"Unable to allocate memory");
            }
            this.memoryManager.release(segments);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void allocateMultipleOwners() {
        int numOwners = 17;
        try {
            int i;
            AbstractInvokable[] owners = new AbstractInvokable[17];
            List[] mems = new List[17];
            for (i = 0; i < 17; ++i) {
                owners[i] = new DummyInvokable();
                mems[i] = new ArrayList(64);
            }
            for (i = 0; i < 2304; ++i) {
                int owner = this.random.nextInt(17);
                mems[owner].addAll(this.memoryManager.allocatePages((Object)owners[owner], 1));
            }
            for (i = 0; i < 17; ++i) {
                this.memoryManager.releaseAll((Object)owners[i]);
                owners[i] = null;
                Assert.assertTrue((String)"Released memory segments have not been destroyed.", (boolean)this.allMemorySegmentsFreed(mems[i]));
                mems[i] = null;
                for (int k = i + 1; k < 17; ++k) {
                    Assert.assertTrue((String)"Non-released memory segments are accidentaly destroyed.", (boolean)this.allMemorySegmentsValid(mems[k]));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void allocateTooMuch() {
        try {
            DummyInvokable mockInvoke = new DummyInvokable();
            List segs = this.memoryManager.allocatePages((Object)mockInvoke, 2304);
            try {
                this.memoryManager.allocatePages((Object)mockInvoke, 1);
                Assert.fail((String)"Expected MemoryAllocationException.");
            }
            catch (MemoryAllocationException memoryAllocationException) {
                // empty catch block
            }
            Assert.assertTrue((String)"The previously allocated segments were not valid any more.", (boolean)this.allMemorySegmentsValid(segs));
            this.memoryManager.releaseAll((Object)mockInvoke);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private boolean allMemorySegmentsValid(List<MemorySegment> memSegs) {
        for (MemorySegment seg : memSegs) {
            if (!seg.isFreed()) continue;
            return false;
        }
        return true;
    }

    private boolean allMemorySegmentsFreed(List<MemorySegment> memSegs) {
        for (MemorySegment seg : memSegs) {
            if (seg.isFreed()) continue;
            return false;
        }
        return true;
    }
}

