/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.messages;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.checkpoint.CheckpointCoordinatorTest;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.TaskStateSnapshot;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.messages.checkpoint.AcknowledgeCheckpoint;
import org.apache.flink.runtime.messages.checkpoint.NotifyCheckpointComplete;
import org.apache.flink.runtime.messages.checkpoint.TriggerCheckpoint;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.junit.Assert;
import org.junit.Test;

public class CheckpointMessagesTest {
    @Test
    public void testTriggerAndConfirmCheckpoint() {
        try {
            NotifyCheckpointComplete cc = new NotifyCheckpointComplete(new JobID(), new ExecutionAttemptID(), 45287698767345L, 467L);
            CheckpointMessagesTest.testSerializabilityEqualsHashCode((Serializable)cc);
            TriggerCheckpoint tc = new TriggerCheckpoint(new JobID(), new ExecutionAttemptID(), 347652734L, 7576752L, CheckpointOptions.forCheckpoint());
            CheckpointMessagesTest.testSerializabilityEqualsHashCode((Serializable)tc);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testConfirmTaskCheckpointed() {
        try {
            AcknowledgeCheckpoint noState = new AcknowledgeCheckpoint(new JobID(), new ExecutionAttemptID(), 569345L);
            KeyGroupRange keyGroupRange = KeyGroupRange.of((int)42, (int)42);
            TaskStateSnapshot checkpointStateHandles = new TaskStateSnapshot();
            checkpointStateHandles.putSubtaskStateByOperatorID(new OperatorID(), new OperatorSubtaskState(CheckpointCoordinatorTest.generatePartitionableStateHandle(new JobVertexID(), 0, 2, 8, false), null, (KeyedStateHandle)CheckpointCoordinatorTest.generateKeyGroupState(keyGroupRange, Collections.singletonList(new MyHandle())), null));
            AcknowledgeCheckpoint withState = new AcknowledgeCheckpoint(new JobID(), new ExecutionAttemptID(), 87658976143L, new CheckpointMetrics(), checkpointStateHandles);
            CheckpointMessagesTest.testSerializabilityEqualsHashCode((Serializable)noState);
            CheckpointMessagesTest.testSerializabilityEqualsHashCode((Serializable)withState);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private static void testSerializabilityEqualsHashCode(Serializable o) throws IOException {
        Serializable copy = CommonTestUtils.createCopySerializable((Serializable)o);
        Assert.assertEquals((Object)o, (Object)copy);
        Assert.assertEquals((long)o.hashCode(), (long)copy.hashCode());
        Assert.assertNotNull((Object)o.toString());
        Assert.assertNotNull((Object)copy.toString());
    }

    public static class MyHandle
    implements StreamStateHandle {
        private static final long serialVersionUID = 8128146204128728332L;

        public Serializable get(ClassLoader userCodeClassLoader) {
            return null;
        }

        public boolean equals(Object obj) {
            return obj.getClass() == this.getClass();
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        public void discardState() throws Exception {
        }

        public long getStateSize() {
            return 0L;
        }

        public FSDataInputStream openInputStream() throws IOException {
            return null;
        }
    }
}

