/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.messages.webmonitor;

import java.util.Collections;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.messages.webmonitor.JobDetails;
import org.apache.flink.runtime.messages.webmonitor.MultipleJobsDetails;
import org.apache.flink.runtime.rest.util.RestMapperUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.TreeNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class MultipleJobsDetailsTest
extends TestLogger {
    @Test
    public void testMultipleJobsDetailsMarshalling() throws JsonProcessingException {
        int[] verticesPerState = new int[ExecutionState.values().length];
        for (int i = 0; i < verticesPerState.length; ++i) {
            verticesPerState[i] = i;
        }
        JobDetails running = new JobDetails(new JobID(), "running", 1L, -1L, 9L, JobStatus.RUNNING, 9L, verticesPerState, 9);
        JobDetails finished = new JobDetails(new JobID(), "finished", 1L, 5L, 4L, JobStatus.FINISHED, 8L, verticesPerState, 4);
        MultipleJobsDetails expected = new MultipleJobsDetails(Collections.singleton(running), Collections.singleton(finished));
        ObjectMapper objectMapper = RestMapperUtils.getStrictObjectMapper();
        JsonNode marshalled = objectMapper.valueToTree((Object)expected);
        MultipleJobsDetails unmarshalled = (MultipleJobsDetails)objectMapper.treeToValue((TreeNode)marshalled, MultipleJobsDetails.class);
        Assert.assertEquals((Object)expected, (Object)unmarshalled);
    }
}

