/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.testkit.JavaTestKit;
import java.net.InetAddress;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.nonha.embedded.EmbeddedHaServices;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.NetworkEnvironment;
import org.apache.flink.runtime.jobmanager.JobManager;
import org.apache.flink.runtime.jobmanager.MemoryArchivist;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.messages.TaskManagerMessages;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryConfiguration;
import org.apache.flink.runtime.metrics.MetricRegistryImpl;
import org.apache.flink.runtime.metrics.NoOpMetricRegistry;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.metrics.util.MetricUtils;
import org.apache.flink.runtime.taskexecutor.TaskManagerConfiguration;
import org.apache.flink.runtime.taskexecutor.TaskManagerServices;
import org.apache.flink.runtime.taskexecutor.TaskManagerServicesConfiguration;
import org.apache.flink.runtime.taskmanager.TaskManager;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import scala.Option;
import scala.concurrent.duration.FiniteDuration;

public class TaskManagerMetricsTest
extends TestLogger {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetricRegistryLifeCycle() throws Exception {
        ActorSystem actorSystem = null;
        EmbeddedHaServices highAvailabilityServices = new EmbeddedHaServices((Executor)TestingUtils.defaultExecutor());
        MetricRegistryImpl metricRegistry = new MetricRegistryImpl(MetricRegistryConfiguration.fromConfiguration((Configuration)new Configuration()));
        try {
            actorSystem = AkkaUtils.createLocalActorSystem((Configuration)new Configuration());
            final ActorRef jobManager = (ActorRef)JobManager.startJobManagerActors((Configuration)new Configuration(), (ActorSystem)actorSystem, (ScheduledExecutorService)TestingUtils.defaultExecutor(), (Executor)TestingUtils.defaultExecutor(), (HighAvailabilityServices)highAvailabilityServices, (MetricRegistry)new NoOpMetricRegistry(), (Option)Option.empty(), JobManager.class, MemoryArchivist.class)._1();
            Configuration config = new Configuration();
            ResourceID tmResourceID = ResourceID.generate();
            TaskManagerServicesConfiguration taskManagerServicesConfiguration = TaskManagerServicesConfiguration.fromConfiguration((Configuration)config, (InetAddress)InetAddress.getLocalHost(), (boolean)false);
            TaskManagerConfiguration taskManagerConfiguration = TaskManagerConfiguration.fromConfiguration((Configuration)config);
            TaskManagerServices taskManagerServices = TaskManagerServices.fromConfiguration((TaskManagerServicesConfiguration)taskManagerServicesConfiguration, (ResourceID)tmResourceID);
            TaskManagerMetricGroup taskManagerMetricGroup = MetricUtils.instantiateTaskManagerMetricGroup((MetricRegistry)metricRegistry, (TaskManagerLocation)taskManagerServices.getTaskManagerLocation(), (NetworkEnvironment)taskManagerServices.getNetworkEnvironment());
            Props tmProps = TaskManager.getTaskManagerProps(TaskManager.class, (TaskManagerConfiguration)taskManagerConfiguration, (ResourceID)tmResourceID, (TaskManagerLocation)taskManagerServices.getTaskManagerLocation(), (MemoryManager)taskManagerServices.getMemoryManager(), (IOManager)taskManagerServices.getIOManager(), (NetworkEnvironment)taskManagerServices.getNetworkEnvironment(), (HighAvailabilityServices)highAvailabilityServices, (TaskManagerMetricGroup)taskManagerMetricGroup);
            final ActorRef taskManager = actorSystem.actorOf(tmProps);
            new JavaTestKit(actorSystem){
                {
                    super(x0);
                    new JavaTestKit.Within(new FiniteDuration(5000L, TimeUnit.SECONDS)){

                        protected void run() {
                            taskManager.tell((Object)TaskManagerMessages.getNotifyWhenRegisteredAtJobManagerMessage(), this.getTestActor());
                            TaskManagerMessages.RegisteredAtJobManager registeredAtJobManager = (TaskManagerMessages.RegisteredAtJobManager)this.expectMsgClass(TaskManagerMessages.RegisteredAtJobManager.class);
                            UUID leaderId = registeredAtJobManager.leaderId();
                            taskManager.tell((Object)new TaskManagerMessages.JobManagerLeaderAddress(jobManager.path().toString(), leaderId), jobManager);
                            taskManager.tell((Object)TaskManagerMessages.getNotifyWhenRegisteredAtJobManagerMessage(), this.getTestActor());
                            this.expectMsgClass(TaskManagerMessages.RegisteredAtJobManager.class);
                        }
                    };
                }
            };
            Assert.assertFalse((boolean)metricRegistry.isShutdown());
            actorSystem.shutdown();
            actorSystem.awaitTermination();
        }
        finally {
            if (actorSystem != null) {
                actorSystem.shutdown();
            }
            if (highAvailabilityServices != null) {
                highAvailabilityServices.closeAndCleanupAllData();
            }
            metricRegistry.shutdown();
        }
    }
}

