/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.metrics.Metric;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryConfiguration;
import org.apache.flink.runtime.metrics.MetricRegistryImpl;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.groups.AbstractMetricGroup;
import org.apache.flink.runtime.metrics.groups.OperatorMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerJobMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;
import org.apache.flink.runtime.metrics.util.DummyCharacterFilter;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class TaskMetricGroupTest
extends TestLogger {
    @Test
    public void testGenerateScopeDefault() {
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryConfiguration.defaultMetricRegistryConfiguration());
        JobVertexID vertexId = new JobVertexID();
        AbstractID executionId = new AbstractID();
        TaskManagerMetricGroup tmGroup = new TaskManagerMetricGroup((MetricRegistry)registry, "theHostName", "test-tm-id");
        TaskManagerJobMetricGroup jmGroup = new TaskManagerJobMetricGroup((MetricRegistry)registry, tmGroup, new JobID(), "myJobName");
        TaskMetricGroup taskGroup = new TaskMetricGroup((MetricRegistry)registry, jmGroup, vertexId, executionId, "aTaskName", 13, 2);
        Assert.assertArrayEquals((Object[])new String[]{"theHostName", "taskmanager", "test-tm-id", "myJobName", "aTaskName", "13"}, (Object[])taskGroup.getScopeComponents());
        Assert.assertEquals((Object)"theHostName.taskmanager.test-tm-id.myJobName.aTaskName.13.name", (Object)taskGroup.getMetricIdentifier("name"));
        registry.shutdown();
    }

    @Test
    public void testGenerateScopeCustom() {
        Configuration cfg = new Configuration();
        cfg.setString(MetricOptions.SCOPE_NAMING_TM, "abc");
        cfg.setString(MetricOptions.SCOPE_NAMING_TM_JOB, "def");
        cfg.setString(MetricOptions.SCOPE_NAMING_TASK, "<tm_id>.<job_id>.<task_id>.<task_attempt_id>");
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryConfiguration.fromConfiguration((Configuration)cfg));
        JobID jid = new JobID();
        JobVertexID vertexId = new JobVertexID();
        AbstractID executionId = new AbstractID();
        TaskManagerMetricGroup tmGroup = new TaskManagerMetricGroup((MetricRegistry)registry, "theHostName", "test-tm-id");
        TaskManagerJobMetricGroup jmGroup = new TaskManagerJobMetricGroup((MetricRegistry)registry, tmGroup, jid, "myJobName");
        TaskMetricGroup taskGroup = new TaskMetricGroup((MetricRegistry)registry, jmGroup, vertexId, executionId, "aTaskName", 13, 2);
        Assert.assertArrayEquals((Object[])new String[]{"test-tm-id", jid.toString(), vertexId.toString(), executionId.toString()}, (Object[])taskGroup.getScopeComponents());
        Assert.assertEquals((Object)String.format("test-tm-id.%s.%s.%s.name", jid, vertexId, executionId), (Object)taskGroup.getMetricIdentifier("name"));
        registry.shutdown();
    }

    @Test
    public void testGenerateScopeWilcard() {
        Configuration cfg = new Configuration();
        cfg.setString(MetricOptions.SCOPE_NAMING_TASK, "*.<task_attempt_id>.<subtask_index>");
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryConfiguration.fromConfiguration((Configuration)cfg));
        AbstractID executionId = new AbstractID();
        TaskManagerMetricGroup tmGroup = new TaskManagerMetricGroup((MetricRegistry)registry, "theHostName", "test-tm-id");
        TaskManagerJobMetricGroup jmGroup = new TaskManagerJobMetricGroup((MetricRegistry)registry, tmGroup, new JobID(), "myJobName");
        TaskMetricGroup taskGroup = new TaskMetricGroup((MetricRegistry)registry, jmGroup, new JobVertexID(), executionId, "aTaskName", 13, 1);
        Assert.assertArrayEquals((Object[])new String[]{"theHostName", "taskmanager", "test-tm-id", "myJobName", executionId.toString(), "13"}, (Object[])taskGroup.getScopeComponents());
        Assert.assertEquals((Object)("theHostName.taskmanager.test-tm-id.myJobName." + executionId + ".13.name"), (Object)taskGroup.getMetricIdentifier("name"));
        registry.shutdown();
    }

    @Test
    public void testCreateQueryServiceMetricInfo() {
        JobID jid = new JobID();
        JobVertexID vid = new JobVertexID();
        AbstractID eid = new AbstractID();
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryConfiguration.defaultMetricRegistryConfiguration());
        TaskManagerMetricGroup tm = new TaskManagerMetricGroup((MetricRegistry)registry, "host", "id");
        TaskManagerJobMetricGroup job = new TaskManagerJobMetricGroup((MetricRegistry)registry, tm, jid, "jobname");
        TaskMetricGroup task = new TaskMetricGroup((MetricRegistry)registry, job, vid, eid, "taskName", 4, 5);
        QueryScopeInfo.TaskQueryScopeInfo info = task.createQueryServiceMetricInfo((CharacterFilter)new DummyCharacterFilter());
        Assert.assertEquals((Object)"", (Object)info.scope);
        Assert.assertEquals((Object)jid.toString(), (Object)info.jobID);
        Assert.assertEquals((Object)vid.toString(), (Object)info.vertexID);
        Assert.assertEquals((long)4L, (long)info.subtaskIndex);
    }

    @Test
    public void testTaskMetricGroupCleanup() {
        CountingMetricRegistry registry = new CountingMetricRegistry(new Configuration());
        TaskManagerMetricGroup taskManagerMetricGroup = new TaskManagerMetricGroup((MetricRegistry)registry, "localhost", "0");
        TaskManagerJobMetricGroup taskManagerJobMetricGroup = new TaskManagerJobMetricGroup((MetricRegistry)registry, taskManagerMetricGroup, new JobID(), "job");
        TaskMetricGroup taskMetricGroup = new TaskMetricGroup((MetricRegistry)registry, taskManagerJobMetricGroup, new JobVertexID(), new AbstractID(), "task", 0, 0);
        Assert.assertTrue((registry.getNumberRegisteredMetrics() > 0 ? 1 : 0) != 0);
        taskMetricGroup.close();
        Assert.assertEquals((long)0L, (long)registry.getNumberRegisteredMetrics());
        registry.shutdown();
    }

    @Test
    public void testOperatorNameTruncation() {
        Configuration cfg = new Configuration();
        cfg.setString(MetricOptions.SCOPE_NAMING_OPERATOR, ScopeFormat.SCOPE_OPERATOR_NAME);
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryConfiguration.fromConfiguration((Configuration)cfg));
        TaskManagerMetricGroup tm = new TaskManagerMetricGroup((MetricRegistry)registry, "host", "id");
        TaskManagerJobMetricGroup job = new TaskManagerJobMetricGroup((MetricRegistry)registry, tm, new JobID(), "jobname");
        TaskMetricGroup taskMetricGroup = new TaskMetricGroup((MetricRegistry)registry, job, new JobVertexID(), new AbstractID(), "task", 0, 0);
        String originalName = new String(new char[100]).replace("\u0000", "-");
        OperatorMetricGroup operatorMetricGroup = taskMetricGroup.addOperator(originalName);
        String storedName = operatorMetricGroup.getScopeComponents()[0];
        Assert.assertEquals((long)80L, (long)storedName.length());
        Assert.assertEquals((Object)originalName.substring(0, 80), (Object)storedName);
    }

    private static class CountingMetricRegistry
    extends MetricRegistryImpl {
        private int counter = 0;

        CountingMetricRegistry(Configuration config) {
            super(MetricRegistryConfiguration.fromConfiguration((Configuration)config));
        }

        public void register(Metric metric, String metricName, AbstractMetricGroup group) {
            super.register(metric, metricName, group);
            ++this.counter;
        }

        public void unregister(Metric metric, String metricName, AbstractMetricGroup group) {
            super.unregister(metric, metricName, group);
            --this.counter;
        }

        int getNumberRegisteredMetrics() {
            return this.counter;
        }
    }
}

