/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.net;

import java.net.ServerSocket;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocket;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.runtime.net.SSLUtils;
import org.junit.Assert;
import org.junit.Test;

public class SSLUtilsTest {
    @Test
    public void testCreateSSLClientContext() throws Exception {
        Configuration clientConfig = new Configuration();
        clientConfig.setBoolean(SecurityOptions.SSL_ENABLED, true);
        clientConfig.setString(SecurityOptions.SSL_TRUSTSTORE, "src/test/resources/local127.truststore");
        clientConfig.setString(SecurityOptions.SSL_TRUSTSTORE_PASSWORD, "password");
        SSLContext clientContext = SSLUtils.createSSLClientContext((Configuration)clientConfig);
        Assert.assertNotNull((Object)clientContext);
    }

    @Test
    public void testCreateSSLClientContextWithSSLDisabled() throws Exception {
        Configuration clientConfig = new Configuration();
        clientConfig.setBoolean(SecurityOptions.SSL_ENABLED, false);
        SSLContext clientContext = SSLUtils.createSSLClientContext((Configuration)clientConfig);
        Assert.assertNull((Object)clientContext);
    }

    @Test
    public void testCreateSSLClientContextMisconfiguration() {
        Configuration clientConfig = new Configuration();
        clientConfig.setBoolean(SecurityOptions.SSL_ENABLED, true);
        clientConfig.setString(SecurityOptions.SSL_TRUSTSTORE, "src/test/resources/local127.truststore");
        clientConfig.setString(SecurityOptions.SSL_TRUSTSTORE_PASSWORD, "badpassword");
        try {
            SSLContext clientContext = SSLUtils.createSSLClientContext((Configuration)clientConfig);
            Assert.fail((String)"SSL client context created even with bad SSL configuration ");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testCreateSSLServerContext() throws Exception {
        Configuration serverConfig = new Configuration();
        serverConfig.setBoolean(SecurityOptions.SSL_ENABLED, true);
        serverConfig.setString(SecurityOptions.SSL_KEYSTORE, "src/test/resources/local127.keystore");
        serverConfig.setString(SecurityOptions.SSL_KEYSTORE_PASSWORD, "password");
        serverConfig.setString(SecurityOptions.SSL_KEY_PASSWORD, "password");
        SSLContext serverContext = SSLUtils.createSSLServerContext((Configuration)serverConfig);
        Assert.assertNotNull((Object)serverContext);
    }

    @Test
    public void testCreateSSLServerContextWithSSLDisabled() throws Exception {
        Configuration serverConfig = new Configuration();
        serverConfig.setBoolean(SecurityOptions.SSL_ENABLED, false);
        SSLContext serverContext = SSLUtils.createSSLServerContext((Configuration)serverConfig);
        Assert.assertNull((Object)serverContext);
    }

    @Test
    public void testCreateSSLServerContextMisconfiguration() {
        Configuration serverConfig = new Configuration();
        serverConfig.setBoolean(SecurityOptions.SSL_ENABLED, true);
        serverConfig.setString(SecurityOptions.SSL_KEYSTORE, "src/test/resources/local127.keystore");
        serverConfig.setString(SecurityOptions.SSL_KEYSTORE_PASSWORD, "badpassword");
        serverConfig.setString(SecurityOptions.SSL_KEY_PASSWORD, "badpassword");
        try {
            SSLContext serverContext = SSLUtils.createSSLServerContext((Configuration)serverConfig);
            Assert.fail((String)"SSL server context created even with bad SSL configuration ");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testCreateSSLServerContextWithMultiProtocols() {
        Configuration serverConfig = new Configuration();
        serverConfig.setBoolean(SecurityOptions.SSL_ENABLED, true);
        serverConfig.setString(SecurityOptions.SSL_KEYSTORE, "src/test/resources/local127.keystore");
        serverConfig.setString(SecurityOptions.SSL_KEYSTORE_PASSWORD, "password");
        serverConfig.setString(SecurityOptions.SSL_KEY_PASSWORD, "password");
        serverConfig.setString(SecurityOptions.SSL_PROTOCOL, "TLSv1,TLSv1.2");
        try {
            SSLContext serverContext = SSLUtils.createSSLServerContext((Configuration)serverConfig);
            Assert.fail((String)"SSL server context created even with multiple protocols set ");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetSSLVersionAndCipherSuitesForSSLServerSocket() throws Exception {
        Configuration serverConfig = new Configuration();
        serverConfig.setBoolean(SecurityOptions.SSL_ENABLED, true);
        serverConfig.setString(SecurityOptions.SSL_KEYSTORE, "src/test/resources/local127.keystore");
        serverConfig.setString(SecurityOptions.SSL_KEYSTORE_PASSWORD, "password");
        serverConfig.setString(SecurityOptions.SSL_KEY_PASSWORD, "password");
        serverConfig.setString(SecurityOptions.SSL_PROTOCOL, "TLSv1.1");
        serverConfig.setString(SecurityOptions.SSL_ALGORITHMS, "TLS_RSA_WITH_AES_128_CBC_SHA,TLS_RSA_WITH_AES_128_CBC_SHA256");
        SSLContext serverContext = SSLUtils.createSSLServerContext((Configuration)serverConfig);
        try (ServerSocket socket = null;){
            socket = serverContext.getServerSocketFactory().createServerSocket(0);
            String[] protocols = ((SSLServerSocket)socket).getEnabledProtocols();
            String[] algorithms = ((SSLServerSocket)socket).getEnabledCipherSuites();
            Assert.assertNotEquals((long)1L, (long)protocols.length);
            Assert.assertNotEquals((long)2L, (long)algorithms.length);
            SSLUtils.setSSLVerAndCipherSuites((ServerSocket)socket, (Configuration)serverConfig);
            protocols = ((SSLServerSocket)socket).getEnabledProtocols();
            algorithms = ((SSLServerSocket)socket).getEnabledCipherSuites();
            Assert.assertEquals((long)1L, (long)protocols.length);
            Assert.assertEquals((Object)"TLSv1.1", (Object)protocols[0]);
            Assert.assertEquals((long)2L, (long)algorithms.length);
            Assert.assertTrue((algorithms[0].equals("TLS_RSA_WITH_AES_128_CBC_SHA") || algorithms[0].equals("TLS_RSA_WITH_AES_128_CBC_SHA256") ? 1 : 0) != 0);
            Assert.assertTrue((algorithms[1].equals("TLS_RSA_WITH_AES_128_CBC_SHA") || algorithms[1].equals("TLS_RSA_WITH_AES_128_CBC_SHA256") ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSetSSLVersionAndCipherSuitesForSSLEngine() throws Exception {
        Configuration serverConfig = new Configuration();
        serverConfig.setBoolean(SecurityOptions.SSL_ENABLED, true);
        serverConfig.setString(SecurityOptions.SSL_KEYSTORE, "src/test/resources/local127.keystore");
        serverConfig.setString(SecurityOptions.SSL_KEYSTORE_PASSWORD, "password");
        serverConfig.setString(SecurityOptions.SSL_KEY_PASSWORD, "password");
        serverConfig.setString(SecurityOptions.SSL_PROTOCOL, "TLSv1");
        serverConfig.setString(SecurityOptions.SSL_ALGORITHMS, "TLS_DHE_RSA_WITH_AES_128_CBC_SHA,TLS_DHE_RSA_WITH_AES_128_CBC_SHA256");
        SSLContext serverContext = SSLUtils.createSSLServerContext((Configuration)serverConfig);
        SSLEngine engine = serverContext.createSSLEngine();
        String[] protocols = engine.getEnabledProtocols();
        String[] algorithms = engine.getEnabledCipherSuites();
        Assert.assertNotEquals((long)1L, (long)protocols.length);
        Assert.assertNotEquals((long)2L, (long)algorithms.length);
        SSLUtils.setSSLVerAndCipherSuites((SSLEngine)engine, (Configuration)serverConfig);
        protocols = engine.getEnabledProtocols();
        algorithms = engine.getEnabledCipherSuites();
        Assert.assertEquals((long)1L, (long)protocols.length);
        Assert.assertEquals((Object)"TLSv1", (Object)protocols[0]);
        Assert.assertEquals((long)2L, (long)algorithms.length);
        Assert.assertTrue((algorithms[0].equals("TLS_DHE_RSA_WITH_AES_128_CBC_SHA") || algorithms[0].equals("TLS_DHE_RSA_WITH_AES_128_CBC_SHA256") ? 1 : 0) != 0);
        Assert.assertTrue((algorithms[1].equals("TLS_DHE_RSA_WITH_AES_128_CBC_SHA") || algorithms[1].equals("TLS_DHE_RSA_WITH_AES_128_CBC_SHA256") ? 1 : 0) != 0);
    }
}

