/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.rest.HttpMethodWrapper;
import org.apache.flink.runtime.rest.RestClient;
import org.apache.flink.runtime.rest.RestClientConfiguration;
import org.apache.flink.runtime.rest.RestServerEndpoint;
import org.apache.flink.runtime.rest.RestServerEndpointConfiguration;
import org.apache.flink.runtime.rest.handler.AbstractRestHandler;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.RestHandlerSpecification;
import org.apache.flink.runtime.rest.messages.ConversionException;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameter;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.MessagePathParameter;
import org.apache.flink.runtime.rest.messages.MessageQueryParameter;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.util.RestClientException;
import org.apache.flink.runtime.rpc.RpcUtils;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelInboundHandler;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TestLogger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class RestEndpointITCase
extends TestLogger {
    private static final JobID PATH_JOB_ID = new JobID();
    private static final JobID QUERY_JOB_ID = new JobID();
    private static final String JOB_ID_KEY = "jobid";
    private static final Time timeout = Time.seconds((long)10L);
    private RestServerEndpoint serverEndpoint;
    private RestClient clientEndpoint;

    @Before
    public void setup() throws Exception {
        Configuration config = new Configuration();
        RestServerEndpointConfiguration serverConfig = RestServerEndpointConfiguration.fromConfiguration((Configuration)config);
        RestClientConfiguration clientConfig = RestClientConfiguration.fromConfiguration((Configuration)config);
        String restAddress = "http://localhost:1234";
        RestfulGateway mockRestfulGateway = (RestfulGateway)Mockito.mock(RestfulGateway.class);
        Mockito.when((Object)mockRestfulGateway.requestRestAddress((Time)Matchers.any(Time.class))).thenReturn(CompletableFuture.completedFuture("http://localhost:1234"));
        GatewayRetriever mockGatewayRetriever = (GatewayRetriever)Mockito.mock(GatewayRetriever.class);
        Mockito.when((Object)mockGatewayRetriever.getNow()).thenReturn(Optional.of(mockRestfulGateway));
        TestHandler testHandler = new TestHandler(CompletableFuture.completedFuture("http://localhost:1234"), (GatewayRetriever<RestfulGateway>)mockGatewayRetriever, RpcUtils.INF_TIMEOUT);
        this.serverEndpoint = new TestRestServerEndpoint(serverConfig, testHandler);
        this.clientEndpoint = new TestRestClient(clientConfig);
        this.serverEndpoint.start();
    }

    @After
    public void teardown() {
        if (this.clientEndpoint != null) {
            this.clientEndpoint.shutdown(timeout);
            this.clientEndpoint = null;
        }
        if (this.serverEndpoint != null) {
            this.serverEndpoint.shutdown(timeout);
            this.serverEndpoint = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRequestInterleaving() throws Exception {
        CompletableFuture response1;
        TestParameters parameters = new TestParameters();
        parameters.jobIDPathParameter.resolve(PATH_JOB_ID);
        parameters.jobIDQueryParameter.resolve(Collections.singletonList(QUERY_JOB_ID));
        InetSocketAddress serverAddress = this.serverEndpoint.getServerAddress();
        Object object = TestHandler.LOCK;
        synchronized (object) {
            response1 = this.clientEndpoint.sendRequest(serverAddress.getHostName(), serverAddress.getPort(), (MessageHeaders)new TestHeaders(), (MessageParameters)parameters, (RequestBody)new TestRequest(1));
            TestHandler.LOCK.wait();
        }
        CompletableFuture response2 = this.clientEndpoint.sendRequest(serverAddress.getHostName(), serverAddress.getPort(), (MessageHeaders)new TestHeaders(), (MessageParameters)parameters, (RequestBody)new TestRequest(2));
        Assert.assertEquals((long)2L, (long)((TestResponse)response2.get()).id);
        Object object2 = TestHandler.LOCK;
        synchronized (object2) {
            TestHandler.LOCK.notifyAll();
        }
        Assert.assertEquals((long)1L, (long)((TestResponse)response1.get()).id);
    }

    @Test
    public void testBadHandlerRequest() throws Exception {
        InetSocketAddress serverAddress = this.serverEndpoint.getServerAddress();
        FaultyTestParameters parameters = new FaultyTestParameters();
        parameters.faultyJobIDPathParameter.resolve(PATH_JOB_ID);
        ((TestParameters)parameters).jobIDQueryParameter.resolve(Collections.singletonList(QUERY_JOB_ID));
        CompletableFuture response = this.clientEndpoint.sendRequest(serverAddress.getHostName(), serverAddress.getPort(), (MessageHeaders)new TestHeaders(), (MessageParameters)parameters, (RequestBody)new TestRequest(2));
        try {
            response.get();
            Assert.fail((String)"The request should fail with a bad request return code.");
        }
        catch (ExecutionException ee) {
            Throwable t = ExceptionUtils.stripExecutionException((Throwable)ee);
            Assert.assertTrue((boolean)(t instanceof RestClientException));
            RestClientException rce = (RestClientException)t;
            Assert.assertEquals((Object)HttpResponseStatus.BAD_REQUEST, (Object)rce.getHttpResponseStatus());
        }
    }

    static class JobIDQueryParameter
    extends MessageQueryParameter<JobID> {
        JobIDQueryParameter() {
            super(RestEndpointITCase.JOB_ID_KEY, MessageParameter.MessageParameterRequisiteness.MANDATORY);
        }

        public JobID convertValueFromString(String value) {
            return JobID.fromHexString((String)value);
        }

        public String convertStringToValue(JobID value) {
            return value.toString();
        }
    }

    static class FaultyJobIDPathParameter
    extends MessagePathParameter<JobID> {
        FaultyJobIDPathParameter() {
            super(RestEndpointITCase.JOB_ID_KEY);
        }

        protected JobID convertFromString(String value) throws ConversionException {
            return JobID.fromHexString((String)value);
        }

        protected String convertToString(JobID value) {
            return "foobar";
        }
    }

    static class JobIDPathParameter
    extends MessagePathParameter<JobID> {
        JobIDPathParameter() {
            super(RestEndpointITCase.JOB_ID_KEY);
        }

        public JobID convertFromString(String value) {
            return JobID.fromHexString((String)value);
        }

        protected String convertToString(JobID value) {
            return value.toString();
        }
    }

    private static class FaultyTestParameters
    extends TestParameters {
        private final FaultyJobIDPathParameter faultyJobIDPathParameter = new FaultyJobIDPathParameter();

        private FaultyTestParameters() {
        }

        @Override
        public Collection<MessagePathParameter<?>> getPathParameters() {
            return Collections.singleton(this.faultyJobIDPathParameter);
        }
    }

    private static class TestParameters
    extends MessageParameters {
        private final JobIDPathParameter jobIDPathParameter = new JobIDPathParameter();
        private final JobIDQueryParameter jobIDQueryParameter = new JobIDQueryParameter();

        private TestParameters() {
        }

        public Collection<MessagePathParameter<?>> getPathParameters() {
            return Collections.singleton(this.jobIDPathParameter);
        }

        public Collection<MessageQueryParameter<?>> getQueryParameters() {
            return Collections.singleton(this.jobIDQueryParameter);
        }
    }

    private static class TestHeaders
    implements MessageHeaders<TestRequest, TestResponse, TestParameters> {
        private TestHeaders() {
        }

        public HttpMethodWrapper getHttpMethod() {
            return HttpMethodWrapper.POST;
        }

        public String getTargetRestEndpointURL() {
            return "/test/:jobid";
        }

        public Class<TestRequest> getRequestClass() {
            return TestRequest.class;
        }

        public Class<TestResponse> getResponseClass() {
            return TestResponse.class;
        }

        public HttpResponseStatus getResponseStatusCode() {
            return HttpResponseStatus.OK;
        }

        public TestParameters getUnresolvedMessageParameters() {
            return new TestParameters();
        }
    }

    private static class TestResponse
    implements ResponseBody {
        public final int id;

        @JsonCreator
        public TestResponse(@JsonProperty(value="id") int id) {
            this.id = id;
        }
    }

    private static class TestRequest
    implements RequestBody {
        public final int id;

        @JsonCreator
        public TestRequest(@JsonProperty(value="id") int id) {
            this.id = id;
        }
    }

    private static class TestRestClient
    extends RestClient {
        TestRestClient(RestClientConfiguration configuration) {
            super(configuration, (Executor)TestingUtils.defaultExecutor());
        }
    }

    private static class TestHandler
    extends AbstractRestHandler<RestfulGateway, TestRequest, TestResponse, TestParameters> {
        public static final Object LOCK = new Object();

        TestHandler(CompletableFuture<String> localAddressFuture, GatewayRetriever<RestfulGateway> leaderRetriever, Time timeout) {
            super(localAddressFuture, leaderRetriever, timeout, (MessageHeaders)new TestHeaders());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CompletableFuture<TestResponse> handleRequest(@Nonnull HandlerRequest<TestRequest, TestParameters> request, RestfulGateway gateway) throws RestHandlerException {
            Assert.assertEquals((Object)request.getPathParameter(JobIDPathParameter.class), (Object)PATH_JOB_ID);
            Assert.assertEquals(request.getQueryParameter(JobIDQueryParameter.class).get(0), (Object)QUERY_JOB_ID);
            if (((TestRequest)request.getRequestBody()).id == 1) {
                Object object = LOCK;
                synchronized (object) {
                    try {
                        LOCK.notifyAll();
                        LOCK.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            return CompletableFuture.completedFuture(new TestResponse(((TestRequest)request.getRequestBody()).id));
        }
    }

    private static class TestRestServerEndpoint
    extends RestServerEndpoint {
        private final TestHandler testHandler;

        TestRestServerEndpoint(RestServerEndpointConfiguration configuration, TestHandler testHandler) {
            super(configuration);
            this.testHandler = (TestHandler)((Object)Preconditions.checkNotNull((Object)((Object)testHandler)));
        }

        protected Collection<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> initializeHandlers(CompletableFuture<String> restAddressFuture) {
            return Collections.singleton(Tuple2.of((Object)new TestHeaders(), (Object)((Object)this.testHandler)));
        }
    }
}

