/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.job.JobSubmitHandler;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.job.JobSubmitRequestBody;
import org.apache.flink.runtime.rpc.RpcUtils;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class JobSubmitHandlerTest
extends TestLogger {
    @Test
    public void testSerializationFailureHandling() throws Exception {
        DispatcherGateway mockGateway = (DispatcherGateway)Mockito.mock(DispatcherGateway.class);
        Mockito.when((Object)mockGateway.submitJob((JobGraph)Matchers.any(JobGraph.class), (Time)Matchers.any(Time.class))).thenReturn(CompletableFuture.completedFuture(Acknowledge.get()));
        GatewayRetriever mockGatewayRetriever = (GatewayRetriever)Mockito.mock(GatewayRetriever.class);
        JobSubmitHandler handler = new JobSubmitHandler(CompletableFuture.completedFuture("http://localhost:1234"), mockGatewayRetriever, RpcUtils.INF_TIMEOUT);
        JobSubmitRequestBody request = new JobSubmitRequestBody(new byte[0]);
        try {
            handler.handleRequest(new HandlerRequest((RequestBody)request, (MessageParameters)EmptyMessageParameters.getInstance()), mockGateway);
            Assert.fail();
        }
        catch (RestHandlerException rhe) {
            Assert.assertEquals((Object)HttpResponseStatus.BAD_REQUEST, (Object)rhe.getHttpResponseStatus());
        }
    }

    @Test
    public void testSuccessfulJobSubmission() throws Exception {
        DispatcherGateway mockGateway = (DispatcherGateway)Mockito.mock(DispatcherGateway.class);
        Mockito.when((Object)mockGateway.submitJob((JobGraph)Matchers.any(JobGraph.class), (Time)Matchers.any(Time.class))).thenReturn(CompletableFuture.completedFuture(Acknowledge.get()));
        GatewayRetriever mockGatewayRetriever = (GatewayRetriever)Mockito.mock(GatewayRetriever.class);
        JobSubmitHandler handler = new JobSubmitHandler(CompletableFuture.completedFuture("http://localhost:1234"), mockGatewayRetriever, RpcUtils.INF_TIMEOUT);
        JobGraph job = new JobGraph("testjob");
        JobSubmitRequestBody request = new JobSubmitRequestBody(job);
        handler.handleRequest(new HandlerRequest((RequestBody)request, (MessageParameters)EmptyMessageParameters.getInstance()), mockGateway).get();
    }
}

