/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.io.IOException;
import java.util.Collection;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.JobAccumulatorsHandler;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedJobGenerationUtils;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class JobAccumulatorsHandlerTest {
    @Test
    public void testArchiver() throws Exception {
        JobAccumulatorsHandler.JobAccumulatorsJsonArchivist archivist = new JobAccumulatorsHandler.JobAccumulatorsJsonArchivist();
        AccessExecutionGraph originalJob = ArchivedJobGenerationUtils.getTestJob();
        Collection archives = archivist.archiveJsonWithPath(originalJob);
        Assert.assertEquals((long)1L, (long)archives.size());
        ArchivedJson archive = (ArchivedJson)archives.iterator().next();
        Assert.assertEquals((Object)("/jobs/" + originalJob.getJobID() + "/accumulators"), (Object)archive.getPath());
        JobAccumulatorsHandlerTest.compareAccumulators(originalJob, archive.getJson());
    }

    @Test
    public void testGetPaths() {
        JobAccumulatorsHandler handler = new JobAccumulatorsHandler((ExecutionGraphCache)Mockito.mock(ExecutionGraphCache.class), Executors.directExecutor());
        String[] paths = handler.getPaths();
        Assert.assertEquals((long)1L, (long)paths.length);
        Assert.assertEquals((Object)"/jobs/:jobid/accumulators", (Object)paths[0]);
    }

    @Test
    public void testJsonGeneration() throws Exception {
        AccessExecutionGraph originalJob = ArchivedJobGenerationUtils.getTestJob();
        String json = JobAccumulatorsHandler.createJobAccumulatorsJson((AccessExecutionGraph)originalJob);
        JobAccumulatorsHandlerTest.compareAccumulators(originalJob, json);
    }

    private static void compareAccumulators(AccessExecutionGraph originalJob, String json) throws IOException {
        JsonNode result = ArchivedJobGenerationUtils.MAPPER.readTree(json);
        ArrayNode accs = (ArrayNode)result.get("job-accumulators");
        Assert.assertEquals((long)0L, (long)accs.size());
        Assert.assertTrue((originalJob.getAccumulatorResultsStringified().length > 0 ? 1 : 0) != 0);
        ArchivedJobGenerationUtils.compareStringifiedAccumulators(originalJob.getAccumulatorResultsStringified(), (ArrayNode)result.get("user-task-accumulators"));
    }
}

