/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.io.IOException;
import java.util.Collection;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.JobVertexDetailsHandler;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedJobGenerationUtils;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class JobVertexDetailsHandlerTest {
    @Test
    public void testArchiver() throws Exception {
        JobVertexDetailsHandler.JobVertexDetailsJsonArchivist archivist = new JobVertexDetailsHandler.JobVertexDetailsJsonArchivist();
        AccessExecutionGraph originalJob = ArchivedJobGenerationUtils.getTestJob();
        AccessExecutionJobVertex originalTask = ArchivedJobGenerationUtils.getTestTask();
        Collection archives = archivist.archiveJsonWithPath(originalJob);
        Assert.assertEquals((long)1L, (long)archives.size());
        ArchivedJson archive = (ArchivedJson)archives.iterator().next();
        Assert.assertEquals((Object)("/jobs/" + originalJob.getJobID() + "/vertices/" + originalTask.getJobVertexId()), (Object)archive.getPath());
        JobVertexDetailsHandlerTest.compareVertexDetails(originalTask, archive.getJson());
    }

    @Test
    public void testGetPaths() {
        JobVertexDetailsHandler handler = new JobVertexDetailsHandler((ExecutionGraphCache)Mockito.mock(ExecutionGraphCache.class), Executors.directExecutor(), null);
        String[] paths = handler.getPaths();
        Assert.assertEquals((long)1L, (long)paths.length);
        Assert.assertEquals((Object)"/jobs/:jobid/vertices/:vertexid", (Object)paths[0]);
    }

    @Test
    public void testJsonGeneration() throws Exception {
        AccessExecutionJobVertex originalTask = ArchivedJobGenerationUtils.getTestTask();
        String json = JobVertexDetailsHandler.createVertexDetailsJson((AccessExecutionJobVertex)originalTask, (String)ArchivedJobGenerationUtils.getTestJob().getJobID().toString(), null);
        JobVertexDetailsHandlerTest.compareVertexDetails(originalTask, json);
    }

    private static void compareVertexDetails(AccessExecutionJobVertex originalTask, String json) throws IOException {
        JsonNode result = ArchivedJobGenerationUtils.MAPPER.readTree(json);
        Assert.assertEquals((Object)originalTask.getJobVertexId().toString(), (Object)result.get("id").asText());
        Assert.assertEquals((Object)originalTask.getName(), (Object)result.get("name").asText());
        Assert.assertEquals((long)originalTask.getParallelism(), (long)result.get("parallelism").asInt());
        Assert.assertTrue((result.get("now").asLong() > 0L ? 1 : 0) != 0);
        ArrayNode subtasks = (ArrayNode)result.get("subtasks");
        Assert.assertEquals((long)originalTask.getTaskVertices().length, (long)subtasks.size());
        for (int x = 0; x < originalTask.getTaskVertices().length; ++x) {
            AccessExecutionVertex expectedSubtask = originalTask.getTaskVertices()[x];
            JsonNode subtask = subtasks.get(x);
            Assert.assertEquals((long)x, (long)subtask.get("subtask").asInt());
            Assert.assertEquals((Object)expectedSubtask.getExecutionState().name(), (Object)subtask.get("status").asText());
            Assert.assertEquals((long)expectedSubtask.getCurrentExecutionAttempt().getAttemptNumber(), (long)subtask.get("attempt").asInt());
            TaskManagerLocation location = expectedSubtask.getCurrentAssignedResourceLocation();
            String expectedLocationString = location.getHostname() + ":" + location.dataPort();
            Assert.assertEquals((Object)expectedLocationString, (Object)subtask.get("host").asText());
            long start = expectedSubtask.getStateTimestamp(ExecutionState.DEPLOYING);
            Assert.assertEquals((long)start, (long)subtask.get("start-time").asLong());
            long end = expectedSubtask.getStateTimestamp(ExecutionState.FINISHED);
            Assert.assertEquals((long)end, (long)subtask.get("end-time").asLong());
            Assert.assertEquals((long)(end - start), (long)subtask.get("duration").asLong());
            ArchivedJobGenerationUtils.compareIoMetrics(expectedSubtask.getCurrentExecutionAttempt().getIOMetrics(), subtask.get("metrics"));
        }
    }
}

