/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecution;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.SubtaskExecutionAttemptDetailsHandler;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedJobGenerationUtils;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class SubtaskExecutionAttemptDetailsHandlerTest
extends TestLogger {
    @Test
    public void testArchiver() throws Exception {
        SubtaskExecutionAttemptDetailsHandler.SubtaskExecutionAttemptDetailsJsonArchivist archivist = new SubtaskExecutionAttemptDetailsHandler.SubtaskExecutionAttemptDetailsJsonArchivist();
        AccessExecutionGraph originalJob = ArchivedJobGenerationUtils.getTestJob();
        AccessExecutionJobVertex originalTask = ArchivedJobGenerationUtils.getTestTask();
        AccessExecution originalAttempt = ArchivedJobGenerationUtils.getTestAttempt();
        Collection archives = archivist.archiveJsonWithPath(originalJob);
        Assert.assertEquals((long)2L, (long)archives.size());
        Iterator iterator = archives.iterator();
        ArchivedJson archive1 = (ArchivedJson)iterator.next();
        Assert.assertEquals((Object)("/jobs/" + originalJob.getJobID() + "/vertices/" + originalTask.getJobVertexId() + "/subtasks/" + originalAttempt.getParallelSubtaskIndex()), (Object)archive1.getPath());
        SubtaskExecutionAttemptDetailsHandlerTest.compareAttemptDetails(originalAttempt, archive1.getJson());
        ArchivedJson archive2 = (ArchivedJson)iterator.next();
        Assert.assertEquals((Object)("/jobs/" + originalJob.getJobID() + "/vertices/" + originalTask.getJobVertexId() + "/subtasks/" + originalAttempt.getParallelSubtaskIndex() + "/attempts/" + originalAttempt.getAttemptNumber()), (Object)archive2.getPath());
        SubtaskExecutionAttemptDetailsHandlerTest.compareAttemptDetails(originalAttempt, archive2.getJson());
    }

    @Test
    public void testGetPaths() {
        SubtaskExecutionAttemptDetailsHandler handler = new SubtaskExecutionAttemptDetailsHandler((ExecutionGraphCache)Mockito.mock(ExecutionGraphCache.class), Executors.directExecutor(), null);
        String[] paths = handler.getPaths();
        Assert.assertEquals((long)1L, (long)paths.length);
        Assert.assertEquals((Object)"/jobs/:jobid/vertices/:vertexid/subtasks/:subtasknum/attempts/:attempt", (Object)paths[0]);
    }

    @Test
    public void testJsonGeneration() throws Exception {
        AccessExecutionGraph originalJob = ArchivedJobGenerationUtils.getTestJob();
        AccessExecutionJobVertex originalTask = ArchivedJobGenerationUtils.getTestTask();
        AccessExecution originalAttempt = ArchivedJobGenerationUtils.getTestAttempt();
        String json = SubtaskExecutionAttemptDetailsHandler.createAttemptDetailsJson((AccessExecution)originalAttempt, (String)originalJob.getJobID().toString(), (String)originalTask.getJobVertexId().toString(), null);
        SubtaskExecutionAttemptDetailsHandlerTest.compareAttemptDetails(originalAttempt, json);
    }

    private static void compareAttemptDetails(AccessExecution originalAttempt, String json) throws IOException {
        JsonNode result = ArchivedJobGenerationUtils.MAPPER.readTree(json);
        Assert.assertEquals((long)originalAttempt.getParallelSubtaskIndex(), (long)result.get("subtask").asInt());
        Assert.assertEquals((Object)originalAttempt.getState().name(), (Object)result.get("status").asText());
        Assert.assertEquals((long)originalAttempt.getAttemptNumber(), (long)result.get("attempt").asInt());
        Assert.assertEquals((Object)originalAttempt.getAssignedResourceLocation().getHostname(), (Object)result.get("host").asText());
        long start = originalAttempt.getStateTimestamp(ExecutionState.DEPLOYING);
        Assert.assertEquals((long)start, (long)result.get("start-time").asLong());
        long end = originalAttempt.getStateTimestamp(ExecutionState.FINISHED);
        Assert.assertEquals((long)end, (long)result.get("end-time").asLong());
        Assert.assertEquals((long)(end - start), (long)result.get("duration").asLong());
        ArchivedJobGenerationUtils.compareIoMetrics(originalAttempt.getIOMetrics(), result.get("metrics"));
    }
}

