/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.io.IOException;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.JobManagerGateway;
import org.apache.flink.runtime.rest.handler.legacy.TaskManagerLogHandler;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.DefaultFullHttpRequest;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpMethod;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpVersion;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.router.Routed;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.powermock.api.mockito.PowerMockito;

public class TaskManagerLogHandlerTest {
    @Test
    public void testGetPaths() {
        TaskManagerLogHandler handlerLog = new TaskManagerLogHandler((GatewayRetriever)PowerMockito.mock(GatewayRetriever.class), Executors.directExecutor(), CompletableFuture.completedFuture("/jm/address"), TestingUtils.TIMEOUT(), TaskManagerLogHandler.FileMode.LOG, new Configuration());
        String[] pathsLog = handlerLog.getPaths();
        Assert.assertEquals((long)1L, (long)pathsLog.length);
        Assert.assertEquals((Object)"/taskmanagers/:taskmanagerid/log", (Object)pathsLog[0]);
        TaskManagerLogHandler handlerOut = new TaskManagerLogHandler((GatewayRetriever)PowerMockito.mock(GatewayRetriever.class), Executors.directExecutor(), CompletableFuture.completedFuture("/jm/address"), TestingUtils.TIMEOUT(), TaskManagerLogHandler.FileMode.STDOUT, new Configuration());
        String[] pathsOut = handlerOut.getPaths();
        Assert.assertEquals((long)1L, (long)pathsOut.length);
        Assert.assertEquals((Object)"/taskmanagers/:taskmanagerid/stdout", (Object)pathsOut[0]);
    }

    @Test
    public void testLogFetchingFailure() throws Exception {
        InstanceID tmID = new InstanceID();
        ResourceID tmRID = new ResourceID(tmID.toString());
        TaskManagerGateway taskManagerGateway = (TaskManagerGateway)PowerMockito.mock(TaskManagerGateway.class);
        PowerMockito.when((Object)taskManagerGateway.getAddress()).thenReturn((Object)"/tm/address");
        Instance taskManager = (Instance)PowerMockito.mock(Instance.class);
        PowerMockito.when((Object)taskManager.getId()).thenReturn((Object)tmID);
        PowerMockito.when((Object)taskManager.getTaskManagerID()).thenReturn((Object)tmRID);
        PowerMockito.when((Object)taskManager.getTaskManagerGateway()).thenReturn((Object)taskManagerGateway);
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(new IOException("failure"));
        PowerMockito.when((Object)taskManagerGateway.requestTaskManagerLog((Time)Matchers.any(Time.class))).thenReturn(future);
        JobManagerGateway jobManagerGateway = (JobManagerGateway)PowerMockito.mock(JobManagerGateway.class);
        PowerMockito.when((Object)jobManagerGateway.requestBlobServerPort((Time)Matchers.any(Time.class))).thenReturn(CompletableFuture.completedFuture(1337));
        PowerMockito.when((Object)jobManagerGateway.getHostname()).thenReturn((Object)"localhost");
        PowerMockito.when((Object)jobManagerGateway.requestTaskManagerInstance((ResourceID)Matchers.any(ResourceID.class), (Time)Matchers.any(Time.class))).thenReturn(CompletableFuture.completedFuture(Optional.of(taskManager)));
        GatewayRetriever retriever = (GatewayRetriever)PowerMockito.mock(GatewayRetriever.class);
        PowerMockito.when((Object)retriever.getNow()).thenReturn(Optional.of(jobManagerGateway));
        TaskManagerLogHandler handler = new TaskManagerLogHandler(retriever, Executors.directExecutor(), CompletableFuture.completedFuture("/jm/address"), TestingUtils.TIMEOUT(), TaskManagerLogHandler.FileMode.LOG, new Configuration());
        final AtomicReference exception = new AtomicReference();
        ChannelHandlerContext ctx = (ChannelHandlerContext)PowerMockito.mock(ChannelHandlerContext.class);
        PowerMockito.when((Object)ctx.write(Matchers.isA(ByteBuf.class))).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                ByteBuf data = (ByteBuf)invocationOnMock.getArgumentAt(0, ByteBuf.class);
                exception.set(new String(data.array(), ConfigConstants.DEFAULT_CHARSET));
                return null;
            }
        });
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("taskmanagerid", tmID.toString());
        Routed routed = (Routed)PowerMockito.mock(Routed.class);
        PowerMockito.when((Object)routed.pathParams()).thenReturn(pathParams);
        PowerMockito.when((Object)routed.request()).thenReturn((Object)new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/taskmanagers/" + tmID + "/log"));
        handler.respondAsLeader(ctx, routed, jobManagerGateway);
        Assert.assertEquals((Object)"Fetching TaskManager log failed.", exception.get());
    }
}

