/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy.checkpoints;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.jobgraph.tasks.CheckpointCoordinatorConfiguration;
import org.apache.flink.runtime.jobgraph.tasks.ExternalizedCheckpointSettings;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.checkpoints.CheckpointConfigHandler;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class CheckpointConfigHandlerTest {
    @Test
    public void testArchiver() throws IOException {
        CheckpointConfigHandler.CheckpointConfigJsonArchivist archivist = new CheckpointConfigHandler.CheckpointConfigJsonArchivist();
        GraphAndSettings graphAndSettings = CheckpointConfigHandlerTest.createGraphAndSettings(true, true);
        AccessExecutionGraph graph = graphAndSettings.graph;
        Mockito.when((Object)graph.getJobID()).thenReturn((Object)new JobID());
        CheckpointCoordinatorConfiguration chkConfig = graphAndSettings.jobCheckpointingConfiguration;
        ExternalizedCheckpointSettings externalizedSettings = graphAndSettings.externalizedSettings;
        Collection archives = archivist.archiveJsonWithPath(graph);
        Assert.assertEquals((long)1L, (long)archives.size());
        ArchivedJson archive = (ArchivedJson)archives.iterator().next();
        Assert.assertEquals((Object)("/jobs/" + graph.getJobID() + "/checkpoints/config"), (Object)archive.getPath());
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = mapper.readTree(archive.getJson());
        Assert.assertEquals((Object)"exactly_once", (Object)rootNode.get("mode").asText());
        Assert.assertEquals((long)chkConfig.getCheckpointInterval(), (long)rootNode.get("interval").asLong());
        Assert.assertEquals((long)chkConfig.getCheckpointTimeout(), (long)rootNode.get("timeout").asLong());
        Assert.assertEquals((long)chkConfig.getMinPauseBetweenCheckpoints(), (long)rootNode.get("min_pause").asLong());
        Assert.assertEquals((long)chkConfig.getMaxConcurrentCheckpoints(), (long)rootNode.get("max_concurrent").asInt());
        JsonNode externalizedNode = rootNode.get("externalization");
        Assert.assertNotNull((Object)externalizedNode);
        Assert.assertEquals((Object)externalizedSettings.externalizeCheckpoints(), (Object)externalizedNode.get("enabled").asBoolean());
        Assert.assertEquals((Object)externalizedSettings.deleteOnCancellation(), (Object)externalizedNode.get("delete_on_cancellation").asBoolean());
    }

    @Test
    public void testGetPaths() {
        CheckpointConfigHandler handler = new CheckpointConfigHandler((ExecutionGraphCache)Mockito.mock(ExecutionGraphCache.class), Executors.directExecutor());
        String[] paths = handler.getPaths();
        Assert.assertEquals((long)1L, (long)paths.length);
        Assert.assertEquals((Object)"/jobs/:jobid/checkpoints/config", (Object)paths[0]);
    }

    @Test
    public void testSimpleConfig() throws Exception {
        GraphAndSettings graphAndSettings = CheckpointConfigHandlerTest.createGraphAndSettings(false, true);
        AccessExecutionGraph graph = graphAndSettings.graph;
        CheckpointCoordinatorConfiguration chkConfig = graphAndSettings.jobCheckpointingConfiguration;
        CheckpointConfigHandler handler = new CheckpointConfigHandler((ExecutionGraphCache)Mockito.mock(ExecutionGraphCache.class), Executors.directExecutor());
        String json = (String)handler.handleRequest(graph, Collections.emptyMap()).get();
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = mapper.readTree(json);
        Assert.assertEquals((Object)"exactly_once", (Object)rootNode.get("mode").asText());
        Assert.assertEquals((long)chkConfig.getCheckpointInterval(), (long)rootNode.get("interval").asLong());
        Assert.assertEquals((long)chkConfig.getCheckpointTimeout(), (long)rootNode.get("timeout").asLong());
        Assert.assertEquals((long)chkConfig.getMinPauseBetweenCheckpoints(), (long)rootNode.get("min_pause").asLong());
        Assert.assertEquals((long)chkConfig.getMaxConcurrentCheckpoints(), (long)rootNode.get("max_concurrent").asInt());
        JsonNode externalizedNode = rootNode.get("externalization");
        Assert.assertNotNull((Object)externalizedNode);
        Assert.assertEquals((Object)false, (Object)externalizedNode.get("enabled").asBoolean());
    }

    @Test
    public void testAtLeastOnce() throws Exception {
        GraphAndSettings graphAndSettings = CheckpointConfigHandlerTest.createGraphAndSettings(false, false);
        AccessExecutionGraph graph = graphAndSettings.graph;
        CheckpointConfigHandler handler = new CheckpointConfigHandler((ExecutionGraphCache)Mockito.mock(ExecutionGraphCache.class), Executors.directExecutor());
        String json = (String)handler.handleRequest(graph, Collections.emptyMap()).get();
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = mapper.readTree(json);
        Assert.assertEquals((Object)"at_least_once", (Object)rootNode.get("mode").asText());
    }

    @Test
    public void testEnabledExternalizedCheckpointSettings() throws Exception {
        GraphAndSettings graphAndSettings = CheckpointConfigHandlerTest.createGraphAndSettings(true, false);
        AccessExecutionGraph graph = graphAndSettings.graph;
        ExternalizedCheckpointSettings externalizedSettings = graphAndSettings.externalizedSettings;
        CheckpointConfigHandler handler = new CheckpointConfigHandler((ExecutionGraphCache)Mockito.mock(ExecutionGraphCache.class), Executors.directExecutor());
        String json = (String)handler.handleRequest(graph, Collections.emptyMap()).get();
        ObjectMapper mapper = new ObjectMapper();
        JsonNode externalizedNode = mapper.readTree(json).get("externalization");
        Assert.assertNotNull((Object)externalizedNode);
        Assert.assertEquals((Object)externalizedSettings.externalizeCheckpoints(), (Object)externalizedNode.get("enabled").asBoolean());
        Assert.assertEquals((Object)externalizedSettings.deleteOnCancellation(), (Object)externalizedNode.get("delete_on_cancellation").asBoolean());
    }

    private static GraphAndSettings createGraphAndSettings(boolean externalized, boolean exactlyOnce) {
        long interval = 18231823L;
        long timeout = 996979L;
        long minPause = 119191919L;
        int maxConcurrent = 12929329;
        ExternalizedCheckpointSettings externalizedSetting = externalized ? ExternalizedCheckpointSettings.externalizeCheckpoints((boolean)true) : ExternalizedCheckpointSettings.none();
        CheckpointCoordinatorConfiguration chkConfig = new CheckpointCoordinatorConfiguration(interval, timeout, minPause, maxConcurrent, externalizedSetting, exactlyOnce);
        AccessExecutionGraph graph = (AccessExecutionGraph)Mockito.mock(AccessExecutionGraph.class);
        Mockito.when((Object)graph.getCheckpointCoordinatorConfiguration()).thenReturn((Object)chkConfig);
        return new GraphAndSettings(graph, chkConfig, externalizedSetting);
    }

    private static class GraphAndSettings {
        public final AccessExecutionGraph graph;
        public final CheckpointCoordinatorConfiguration jobCheckpointingConfiguration;
        public final ExternalizedCheckpointSettings externalizedSettings;

        public GraphAndSettings(AccessExecutionGraph graph, CheckpointCoordinatorConfiguration jobCheckpointingConfiguration, ExternalizedCheckpointSettings externalizedSettings) {
            this.graph = graph;
            this.jobCheckpointingConfiguration = jobCheckpointingConfiguration;
            this.externalizedSettings = externalizedSettings;
        }
    }
}

