/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy.checkpoints;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.AbstractCheckpointStats;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CheckpointStatsHistory;
import org.apache.flink.runtime.checkpoint.CheckpointStatsSnapshot;
import org.apache.flink.runtime.checkpoint.CheckpointStatsStatus;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStats;
import org.apache.flink.runtime.checkpoint.FailedCheckpointStats;
import org.apache.flink.runtime.checkpoint.PendingCheckpointStats;
import org.apache.flink.runtime.checkpoint.TaskStateStats;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.rest.handler.job.checkpoints.CheckpointStatsCache;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.checkpoints.CheckpointStatsDetailsHandler;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class CheckpointStatsDetailsHandlerTest {
    @Test
    public void testArchiver() throws IOException {
        CheckpointStatsDetailsHandler.CheckpointStatsDetailsJsonArchivist archivist = new CheckpointStatsDetailsHandler.CheckpointStatsDetailsJsonArchivist();
        CompletedCheckpointStats completedCheckpoint = CheckpointStatsDetailsHandlerTest.createCompletedCheckpoint();
        FailedCheckpointStats failedCheckpoint = CheckpointStatsDetailsHandlerTest.createFailedCheckpoint();
        ArrayList<Object> checkpoints = new ArrayList<Object>();
        checkpoints.add(failedCheckpoint);
        checkpoints.add(completedCheckpoint);
        CheckpointStatsHistory history = (CheckpointStatsHistory)Mockito.mock(CheckpointStatsHistory.class);
        Mockito.when((Object)history.getCheckpoints()).thenReturn(checkpoints);
        CheckpointStatsSnapshot snapshot = (CheckpointStatsSnapshot)Mockito.mock(CheckpointStatsSnapshot.class);
        Mockito.when((Object)snapshot.getHistory()).thenReturn((Object)history);
        AccessExecutionGraph graph = (AccessExecutionGraph)Mockito.mock(AccessExecutionGraph.class);
        Mockito.when((Object)graph.getCheckpointStatsSnapshot()).thenReturn((Object)snapshot);
        Mockito.when((Object)graph.getJobID()).thenReturn((Object)new JobID());
        ObjectMapper mapper = new ObjectMapper();
        Collection archives = archivist.archiveJsonWithPath(graph);
        Assert.assertEquals((long)2L, (long)archives.size());
        Iterator iterator = archives.iterator();
        ArchivedJson archive1 = (ArchivedJson)iterator.next();
        Assert.assertEquals((Object)("/jobs/" + graph.getJobID() + "/checkpoints/details/" + failedCheckpoint.getCheckpointId()), (Object)archive1.getPath());
        CheckpointStatsDetailsHandlerTest.compareFailedCheckpoint(failedCheckpoint, mapper.readTree(archive1.getJson()));
        ArchivedJson archive2 = (ArchivedJson)iterator.next();
        Assert.assertEquals((Object)("/jobs/" + graph.getJobID() + "/checkpoints/details/" + completedCheckpoint.getCheckpointId()), (Object)archive2.getPath());
        CheckpointStatsDetailsHandlerTest.compareCompletedCheckpoint(completedCheckpoint, mapper.readTree(archive2.getJson()));
    }

    @Test
    public void testGetPaths() {
        CheckpointStatsDetailsHandler handler = new CheckpointStatsDetailsHandler((ExecutionGraphCache)Mockito.mock(ExecutionGraphCache.class), Executors.directExecutor(), new CheckpointStatsCache(0));
        String[] paths = handler.getPaths();
        Assert.assertEquals((long)1L, (long)paths.length);
        Assert.assertEquals((Object)"/jobs/:jobid/checkpoints/details/:checkpointid", (Object)paths[0]);
    }

    @Test
    public void testIllegalCheckpointId() throws Exception {
        AccessExecutionGraph graph = (AccessExecutionGraph)Mockito.mock(AccessExecutionGraph.class);
        CheckpointStatsDetailsHandler handler = new CheckpointStatsDetailsHandler((ExecutionGraphCache)Mockito.mock(ExecutionGraphCache.class), Executors.directExecutor(), new CheckpointStatsCache(0));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("checkpointid", "illegal checkpoint");
        String json = (String)handler.handleRequest(graph, params).get();
        Assert.assertEquals((Object)"{}", (Object)json);
    }

    @Test
    public void testNoCheckpointIdParam() throws Exception {
        AccessExecutionGraph graph = (AccessExecutionGraph)Mockito.mock(AccessExecutionGraph.class);
        CheckpointStatsDetailsHandler handler = new CheckpointStatsDetailsHandler((ExecutionGraphCache)Mockito.mock(ExecutionGraphCache.class), Executors.directExecutor(), new CheckpointStatsCache(0));
        String json = (String)handler.handleRequest(graph, Collections.emptyMap()).get();
        Assert.assertEquals((Object)"{}", (Object)json);
    }

    @Test
    public void testCheckpointNotFound() throws Exception {
        CheckpointStatsHistory history = (CheckpointStatsHistory)Mockito.mock(CheckpointStatsHistory.class);
        Mockito.when((Object)history.getCheckpointById(Matchers.anyLong())).thenReturn(null);
        CheckpointStatsSnapshot snapshot = (CheckpointStatsSnapshot)Mockito.mock(CheckpointStatsSnapshot.class);
        Mockito.when((Object)snapshot.getHistory()).thenReturn((Object)history);
        AccessExecutionGraph graph = (AccessExecutionGraph)Mockito.mock(AccessExecutionGraph.class);
        Mockito.when((Object)graph.getCheckpointStatsSnapshot()).thenReturn((Object)snapshot);
        CheckpointStatsDetailsHandler handler = new CheckpointStatsDetailsHandler((ExecutionGraphCache)Mockito.mock(ExecutionGraphCache.class), Executors.directExecutor(), new CheckpointStatsCache(0));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("checkpointid", "123");
        String json = (String)handler.handleRequest(graph, params).get();
        Assert.assertEquals((Object)"{}", (Object)json);
        ((CheckpointStatsHistory)Mockito.verify((Object)history, (VerificationMode)Mockito.times((int)1))).getCheckpointById(Matchers.anyLong());
    }

    @Test
    public void testCheckpointDetailsRequestInProgressCheckpoint() throws Exception {
        PendingCheckpointStats checkpoint = (PendingCheckpointStats)Mockito.mock(PendingCheckpointStats.class);
        Mockito.when((Object)checkpoint.getCheckpointId()).thenReturn((Object)1992139L);
        Mockito.when((Object)checkpoint.getStatus()).thenReturn((Object)CheckpointStatsStatus.IN_PROGRESS);
        Mockito.when((Object)checkpoint.getProperties()).thenReturn((Object)CheckpointProperties.forStandardCheckpoint());
        Mockito.when((Object)checkpoint.getTriggerTimestamp()).thenReturn((Object)1919191900L);
        Mockito.when((Object)checkpoint.getLatestAckTimestamp()).thenReturn((Object)1977791901L);
        Mockito.when((Object)checkpoint.getStateSize()).thenReturn((Object)111939272822L);
        Mockito.when((Object)checkpoint.getEndToEndDuration()).thenReturn((Object)121191L);
        Mockito.when((Object)checkpoint.getAlignmentBuffered()).thenReturn((Object)1L);
        Mockito.when((Object)checkpoint.getNumberOfSubtasks()).thenReturn((Object)501);
        Mockito.when((Object)checkpoint.getNumberOfAcknowledgedSubtasks()).thenReturn((Object)101);
        ArrayList<TaskStateStats> taskStats = new ArrayList<TaskStateStats>();
        TaskStateStats task1 = CheckpointStatsDetailsHandlerTest.createTaskStateStats();
        TaskStateStats task2 = CheckpointStatsDetailsHandlerTest.createTaskStateStats();
        taskStats.add(task1);
        taskStats.add(task2);
        Mockito.when((Object)checkpoint.getAllTaskStateStats()).thenReturn(taskStats);
        JsonNode rootNode = CheckpointStatsDetailsHandlerTest.triggerRequest((AbstractCheckpointStats)checkpoint);
        Assert.assertEquals((long)checkpoint.getCheckpointId(), (long)rootNode.get("id").asLong());
        Assert.assertEquals((Object)checkpoint.getStatus().toString(), (Object)rootNode.get("status").asText());
        Assert.assertEquals((Object)checkpoint.getProperties().isSavepoint(), (Object)rootNode.get("is_savepoint").asBoolean());
        Assert.assertEquals((long)checkpoint.getTriggerTimestamp(), (long)rootNode.get("trigger_timestamp").asLong());
        Assert.assertEquals((long)checkpoint.getLatestAckTimestamp(), (long)rootNode.get("latest_ack_timestamp").asLong());
        Assert.assertEquals((long)checkpoint.getStateSize(), (long)rootNode.get("state_size").asLong());
        Assert.assertEquals((long)checkpoint.getEndToEndDuration(), (long)rootNode.get("end_to_end_duration").asLong());
        Assert.assertEquals((long)checkpoint.getAlignmentBuffered(), (long)rootNode.get("alignment_buffered").asLong());
        Assert.assertEquals((long)checkpoint.getNumberOfSubtasks(), (long)rootNode.get("num_subtasks").asInt());
        Assert.assertEquals((long)checkpoint.getNumberOfAcknowledgedSubtasks(), (long)rootNode.get("num_acknowledged_subtasks").asInt());
        CheckpointStatsDetailsHandlerTest.verifyTaskNodes(taskStats, rootNode);
    }

    @Test
    public void testCheckpointDetailsRequestCompletedCheckpoint() throws Exception {
        CompletedCheckpointStats checkpoint = CheckpointStatsDetailsHandlerTest.createCompletedCheckpoint();
        JsonNode rootNode = CheckpointStatsDetailsHandlerTest.triggerRequest((AbstractCheckpointStats)checkpoint);
        CheckpointStatsDetailsHandlerTest.compareCompletedCheckpoint(checkpoint, rootNode);
        CheckpointStatsDetailsHandlerTest.verifyTaskNodes(checkpoint.getAllTaskStateStats(), rootNode);
    }

    @Test
    public void testCheckpointDetailsRequestFailedCheckpoint() throws Exception {
        FailedCheckpointStats checkpoint = CheckpointStatsDetailsHandlerTest.createFailedCheckpoint();
        JsonNode rootNode = CheckpointStatsDetailsHandlerTest.triggerRequest((AbstractCheckpointStats)checkpoint);
        CheckpointStatsDetailsHandlerTest.compareFailedCheckpoint(checkpoint, rootNode);
        CheckpointStatsDetailsHandlerTest.verifyTaskNodes(checkpoint.getAllTaskStateStats(), rootNode);
    }

    private static CompletedCheckpointStats createCompletedCheckpoint() {
        CompletedCheckpointStats checkpoint = (CompletedCheckpointStats)Mockito.mock(CompletedCheckpointStats.class);
        Mockito.when((Object)checkpoint.getCheckpointId()).thenReturn((Object)1818213L);
        Mockito.when((Object)checkpoint.getStatus()).thenReturn((Object)CheckpointStatsStatus.COMPLETED);
        Mockito.when((Object)checkpoint.getProperties()).thenReturn((Object)CheckpointProperties.forStandardSavepoint());
        Mockito.when((Object)checkpoint.getTriggerTimestamp()).thenReturn((Object)1818L);
        Mockito.when((Object)checkpoint.getLatestAckTimestamp()).thenReturn((Object)11029222L);
        Mockito.when((Object)checkpoint.getStateSize()).thenReturn((Object)925281L);
        Mockito.when((Object)checkpoint.getEndToEndDuration()).thenReturn((Object)181819L);
        Mockito.when((Object)checkpoint.getAlignmentBuffered()).thenReturn((Object)1010198L);
        Mockito.when((Object)checkpoint.getNumberOfSubtasks()).thenReturn((Object)181271);
        Mockito.when((Object)checkpoint.getNumberOfAcknowledgedSubtasks()).thenReturn((Object)29821);
        Mockito.when((Object)checkpoint.isDiscarded()).thenReturn((Object)true);
        Mockito.when((Object)checkpoint.getExternalPath()).thenReturn((Object)"checkpoint-external-path");
        ArrayList<TaskStateStats> taskStats = new ArrayList<TaskStateStats>();
        TaskStateStats task1 = CheckpointStatsDetailsHandlerTest.createTaskStateStats();
        TaskStateStats task2 = CheckpointStatsDetailsHandlerTest.createTaskStateStats();
        taskStats.add(task1);
        taskStats.add(task2);
        Mockito.when((Object)checkpoint.getAllTaskStateStats()).thenReturn(taskStats);
        return checkpoint;
    }

    private static void compareCompletedCheckpoint(CompletedCheckpointStats checkpoint, JsonNode rootNode) {
        Assert.assertEquals((long)checkpoint.getCheckpointId(), (long)rootNode.get("id").asLong());
        Assert.assertEquals((Object)checkpoint.getStatus().toString(), (Object)rootNode.get("status").asText());
        Assert.assertEquals((Object)checkpoint.getProperties().isSavepoint(), (Object)rootNode.get("is_savepoint").asBoolean());
        Assert.assertEquals((long)checkpoint.getTriggerTimestamp(), (long)rootNode.get("trigger_timestamp").asLong());
        Assert.assertEquals((long)checkpoint.getLatestAckTimestamp(), (long)rootNode.get("latest_ack_timestamp").asLong());
        Assert.assertEquals((long)checkpoint.getStateSize(), (long)rootNode.get("state_size").asLong());
        Assert.assertEquals((long)checkpoint.getEndToEndDuration(), (long)rootNode.get("end_to_end_duration").asLong());
        Assert.assertEquals((long)checkpoint.getAlignmentBuffered(), (long)rootNode.get("alignment_buffered").asLong());
        Assert.assertEquals((Object)checkpoint.isDiscarded(), (Object)rootNode.get("discarded").asBoolean());
        Assert.assertEquals((Object)checkpoint.getExternalPath(), (Object)rootNode.get("external_path").asText());
        Assert.assertEquals((long)checkpoint.getNumberOfSubtasks(), (long)rootNode.get("num_subtasks").asInt());
        Assert.assertEquals((long)checkpoint.getNumberOfAcknowledgedSubtasks(), (long)rootNode.get("num_acknowledged_subtasks").asInt());
    }

    private static FailedCheckpointStats createFailedCheckpoint() {
        FailedCheckpointStats checkpoint = (FailedCheckpointStats)Mockito.mock(FailedCheckpointStats.class);
        Mockito.when((Object)checkpoint.getCheckpointId()).thenReturn((Object)1818214L);
        Mockito.when((Object)checkpoint.getStatus()).thenReturn((Object)CheckpointStatsStatus.FAILED);
        Mockito.when((Object)checkpoint.getProperties()).thenReturn((Object)CheckpointProperties.forStandardSavepoint());
        Mockito.when((Object)checkpoint.getTriggerTimestamp()).thenReturn((Object)1818L);
        Mockito.when((Object)checkpoint.getLatestAckTimestamp()).thenReturn((Object)11029222L);
        Mockito.when((Object)checkpoint.getStateSize()).thenReturn((Object)925281L);
        Mockito.when((Object)checkpoint.getEndToEndDuration()).thenReturn((Object)181819L);
        Mockito.when((Object)checkpoint.getAlignmentBuffered()).thenReturn((Object)1010198L);
        Mockito.when((Object)checkpoint.getNumberOfSubtasks()).thenReturn((Object)181271);
        Mockito.when((Object)checkpoint.getNumberOfAcknowledgedSubtasks()).thenReturn((Object)29821);
        Mockito.when((Object)checkpoint.getFailureTimestamp()).thenReturn((Object)123012890312093L);
        Mockito.when((Object)checkpoint.getFailureMessage()).thenReturn((Object)"failure-message");
        ArrayList<TaskStateStats> taskStats = new ArrayList<TaskStateStats>();
        TaskStateStats task1 = CheckpointStatsDetailsHandlerTest.createTaskStateStats();
        TaskStateStats task2 = CheckpointStatsDetailsHandlerTest.createTaskStateStats();
        taskStats.add(task1);
        taskStats.add(task2);
        Mockito.when((Object)checkpoint.getAllTaskStateStats()).thenReturn(taskStats);
        return checkpoint;
    }

    private static void compareFailedCheckpoint(FailedCheckpointStats checkpoint, JsonNode rootNode) {
        Assert.assertEquals((long)checkpoint.getCheckpointId(), (long)rootNode.get("id").asLong());
        Assert.assertEquals((Object)checkpoint.getStatus().toString(), (Object)rootNode.get("status").asText());
        Assert.assertEquals((Object)checkpoint.getProperties().isSavepoint(), (Object)rootNode.get("is_savepoint").asBoolean());
        Assert.assertEquals((long)checkpoint.getTriggerTimestamp(), (long)rootNode.get("trigger_timestamp").asLong());
        Assert.assertEquals((long)checkpoint.getLatestAckTimestamp(), (long)rootNode.get("latest_ack_timestamp").asLong());
        Assert.assertEquals((long)checkpoint.getStateSize(), (long)rootNode.get("state_size").asLong());
        Assert.assertEquals((long)checkpoint.getEndToEndDuration(), (long)rootNode.get("end_to_end_duration").asLong());
        Assert.assertEquals((long)checkpoint.getAlignmentBuffered(), (long)rootNode.get("alignment_buffered").asLong());
        Assert.assertEquals((long)checkpoint.getFailureTimestamp(), (long)rootNode.get("failure_timestamp").asLong());
        Assert.assertEquals((Object)checkpoint.getFailureMessage(), (Object)rootNode.get("failure_message").asText());
        Assert.assertEquals((long)checkpoint.getNumberOfSubtasks(), (long)rootNode.get("num_subtasks").asInt());
        Assert.assertEquals((long)checkpoint.getNumberOfAcknowledgedSubtasks(), (long)rootNode.get("num_acknowledged_subtasks").asInt());
    }

    private static JsonNode triggerRequest(AbstractCheckpointStats checkpoint) throws Exception {
        CheckpointStatsHistory history = (CheckpointStatsHistory)Mockito.mock(CheckpointStatsHistory.class);
        Mockito.when((Object)history.getCheckpointById(Matchers.anyLong())).thenReturn((Object)checkpoint);
        CheckpointStatsSnapshot snapshot = (CheckpointStatsSnapshot)Mockito.mock(CheckpointStatsSnapshot.class);
        Mockito.when((Object)snapshot.getHistory()).thenReturn((Object)history);
        AccessExecutionGraph graph = (AccessExecutionGraph)Mockito.mock(AccessExecutionGraph.class);
        Mockito.when((Object)graph.getCheckpointStatsSnapshot()).thenReturn((Object)snapshot);
        CheckpointStatsDetailsHandler handler = new CheckpointStatsDetailsHandler((ExecutionGraphCache)Mockito.mock(ExecutionGraphCache.class), Executors.directExecutor(), new CheckpointStatsCache(0));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("checkpointid", "123");
        String json = (String)handler.handleRequest(graph, params).get();
        ObjectMapper mapper = new ObjectMapper();
        return mapper.readTree(json);
    }

    private static void verifyTaskNodes(Collection<TaskStateStats> tasks, JsonNode parentNode) {
        for (TaskStateStats task : tasks) {
            long duration = ThreadLocalRandom.current().nextInt(128);
            JsonNode taskNode = parentNode.get("tasks").get(task.getJobVertexId().toString());
            Assert.assertEquals((long)task.getLatestAckTimestamp(), (long)taskNode.get("latest_ack_timestamp").asLong());
            Assert.assertEquals((long)task.getStateSize(), (long)taskNode.get("state_size").asLong());
            Assert.assertEquals((long)task.getEndToEndDuration(task.getLatestAckTimestamp() - duration), (long)taskNode.get("end_to_end_duration").asLong());
            Assert.assertEquals((long)task.getAlignmentBuffered(), (long)taskNode.get("alignment_buffered").asLong());
            Assert.assertEquals((long)task.getNumberOfSubtasks(), (long)taskNode.get("num_subtasks").asInt());
            Assert.assertEquals((long)task.getNumberOfAcknowledgedSubtasks(), (long)taskNode.get("num_acknowledged_subtasks").asInt());
        }
    }

    private static TaskStateStats createTaskStateStats() {
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        TaskStateStats task = (TaskStateStats)Mockito.mock(TaskStateStats.class);
        Mockito.when((Object)task.getJobVertexId()).thenReturn((Object)new JobVertexID());
        Mockito.when((Object)task.getLatestAckTimestamp()).thenReturn((Object)(rand.nextLong(1024L) + 1L));
        Mockito.when((Object)task.getStateSize()).thenReturn((Object)(rand.nextLong(1024L) + 1L));
        Mockito.when((Object)task.getEndToEndDuration(Matchers.anyLong())).thenReturn((Object)(rand.nextLong(1024L) + 1L));
        Mockito.when((Object)task.getAlignmentBuffered()).thenReturn((Object)(rand.nextLong(1024L) + 1L));
        Mockito.when((Object)task.getNumberOfSubtasks()).thenReturn((Object)(rand.nextInt(1024) + 1));
        Mockito.when((Object)task.getNumberOfAcknowledgedSubtasks()).thenReturn((Object)(rand.nextInt(1024) + 1));
        return task;
    }
}

