/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy.checkpoints;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CheckpointStatsCounts;
import org.apache.flink.runtime.checkpoint.CheckpointStatsHistory;
import org.apache.flink.runtime.checkpoint.CheckpointStatsSnapshot;
import org.apache.flink.runtime.checkpoint.CheckpointStatsStatus;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStats;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStatsSummary;
import org.apache.flink.runtime.checkpoint.FailedCheckpointStats;
import org.apache.flink.runtime.checkpoint.MinMaxAvgStats;
import org.apache.flink.runtime.checkpoint.PendingCheckpointStats;
import org.apache.flink.runtime.checkpoint.RestoredCheckpointStats;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.checkpoints.CheckpointStatsDetailsHandler;
import org.apache.flink.runtime.rest.handler.legacy.checkpoints.CheckpointStatsHandler;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class CheckpointStatsHandlerTest {
    @Test
    public void testArchiver() throws IOException {
        CheckpointStatsDetailsHandler.CheckpointStatsDetailsJsonArchivist archivist = new CheckpointStatsDetailsHandler.CheckpointStatsDetailsJsonArchivist();
        TestCheckpointStats testCheckpointStats = CheckpointStatsHandlerTest.createTestCheckpointStats();
        Mockito.when((Object)testCheckpointStats.graph.getJobID()).thenReturn((Object)new JobID());
        Collection archives = archivist.archiveJsonWithPath(testCheckpointStats.graph);
        Assert.assertEquals((long)3L, (long)archives.size());
        ObjectMapper mapper = new ObjectMapper();
        Iterator iterator = archives.iterator();
        ArchivedJson archive1 = (ArchivedJson)iterator.next();
        Assert.assertEquals((Object)("/jobs/" + testCheckpointStats.graph.getJobID() + "/checkpoints/details/" + testCheckpointStats.inProgress.getCheckpointId()), (Object)archive1.getPath());
        CheckpointStatsHandlerTest.compareInProgressCheckpoint(testCheckpointStats.inProgress, mapper.readTree(archive1.getJson()));
        ArchivedJson archive2 = (ArchivedJson)iterator.next();
        Assert.assertEquals((Object)("/jobs/" + testCheckpointStats.graph.getJobID() + "/checkpoints/details/" + testCheckpointStats.completedSavepoint.getCheckpointId()), (Object)archive2.getPath());
        CheckpointStatsHandlerTest.compareCompletedSavepoint(testCheckpointStats.completedSavepoint, mapper.readTree(archive2.getJson()));
        ArchivedJson archive3 = (ArchivedJson)iterator.next();
        Assert.assertEquals((Object)("/jobs/" + testCheckpointStats.graph.getJobID() + "/checkpoints/details/" + testCheckpointStats.failed.getCheckpointId()), (Object)archive3.getPath());
        CheckpointStatsHandlerTest.compareFailedCheckpoint(testCheckpointStats.failed, mapper.readTree(archive3.getJson()));
    }

    @Test
    public void testGetPaths() {
        CheckpointStatsHandler handler = new CheckpointStatsHandler((ExecutionGraphCache)Mockito.mock(ExecutionGraphCache.class), Executors.directExecutor());
        String[] paths = handler.getPaths();
        Assert.assertEquals((long)1L, (long)paths.length);
        Assert.assertEquals((Object)"/jobs/:jobid/checkpoints", (Object)paths[0]);
    }

    @Test
    public void testCheckpointStatsRequest() throws Exception {
        TestCheckpointStats testCheckpointStats = CheckpointStatsHandlerTest.createTestCheckpointStats();
        CheckpointStatsHandler handler = new CheckpointStatsHandler((ExecutionGraphCache)Mockito.mock(ExecutionGraphCache.class), Executors.directExecutor());
        String json = (String)handler.handleRequest(testCheckpointStats.graph, Collections.emptyMap()).get();
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = mapper.readTree(json);
        CheckpointStatsHandlerTest.compareCheckpointStats(testCheckpointStats, rootNode);
    }

    private static TestCheckpointStats createTestCheckpointStats() {
        CheckpointStatsCounts counts = (CheckpointStatsCounts)Mockito.mock(CheckpointStatsCounts.class);
        Mockito.when((Object)counts.getNumberOfRestoredCheckpoints()).thenReturn((Object)123123123L);
        Mockito.when((Object)counts.getTotalNumberOfCheckpoints()).thenReturn((Object)12981231203L);
        Mockito.when((Object)counts.getNumberOfInProgressCheckpoints()).thenReturn((Object)191919);
        Mockito.when((Object)counts.getNumberOfCompletedCheckpoints()).thenReturn((Object)882828200L);
        Mockito.when((Object)counts.getNumberOfFailedCheckpoints()).thenReturn((Object)99171510L);
        CompletedCheckpointStatsSummary summary = (CompletedCheckpointStatsSummary)Mockito.mock(CompletedCheckpointStatsSummary.class);
        MinMaxAvgStats stateSizeSummary = (MinMaxAvgStats)Mockito.mock(MinMaxAvgStats.class);
        Mockito.when((Object)stateSizeSummary.getMinimum()).thenReturn((Object)81238123L);
        Mockito.when((Object)stateSizeSummary.getMaximum()).thenReturn((Object)19919191999L);
        Mockito.when((Object)stateSizeSummary.getAverage()).thenReturn((Object)1133L);
        MinMaxAvgStats durationSummary = (MinMaxAvgStats)Mockito.mock(MinMaxAvgStats.class);
        Mockito.when((Object)durationSummary.getMinimum()).thenReturn((Object)1182L);
        Mockito.when((Object)durationSummary.getMaximum()).thenReturn((Object)88654L);
        Mockito.when((Object)durationSummary.getAverage()).thenReturn((Object)171L);
        MinMaxAvgStats alignmentBufferedSummary = (MinMaxAvgStats)Mockito.mock(MinMaxAvgStats.class);
        Mockito.when((Object)alignmentBufferedSummary.getMinimum()).thenReturn((Object)81818181899L);
        Mockito.when((Object)alignmentBufferedSummary.getMaximum()).thenReturn((Object)89999911118654L);
        Mockito.when((Object)alignmentBufferedSummary.getAverage()).thenReturn((Object)11203131L);
        Mockito.when((Object)summary.getStateSizeStats()).thenReturn((Object)stateSizeSummary);
        Mockito.when((Object)summary.getEndToEndDurationStats()).thenReturn((Object)durationSummary);
        Mockito.when((Object)summary.getAlignmentBufferedStats()).thenReturn((Object)alignmentBufferedSummary);
        CompletedCheckpointStats latestCompleted = (CompletedCheckpointStats)Mockito.mock(CompletedCheckpointStats.class);
        Mockito.when((Object)latestCompleted.getCheckpointId()).thenReturn((Object)1992139L);
        Mockito.when((Object)latestCompleted.getTriggerTimestamp()).thenReturn((Object)1919191900L);
        Mockito.when((Object)latestCompleted.getLatestAckTimestamp()).thenReturn((Object)1977791901L);
        Mockito.when((Object)latestCompleted.getStateSize()).thenReturn((Object)111939272822L);
        Mockito.when((Object)latestCompleted.getEndToEndDuration()).thenReturn((Object)121191L);
        Mockito.when((Object)latestCompleted.getAlignmentBuffered()).thenReturn((Object)1L);
        Mockito.when((Object)latestCompleted.getExternalPath()).thenReturn((Object)"latest-completed-external-path");
        CompletedCheckpointStats latestSavepoint = (CompletedCheckpointStats)Mockito.mock(CompletedCheckpointStats.class);
        Mockito.when((Object)latestSavepoint.getCheckpointId()).thenReturn((Object)1992140L);
        Mockito.when((Object)latestSavepoint.getTriggerTimestamp()).thenReturn((Object)1919191900L);
        Mockito.when((Object)latestSavepoint.getLatestAckTimestamp()).thenReturn((Object)1977791901L);
        Mockito.when((Object)latestSavepoint.getStateSize()).thenReturn((Object)111939272822L);
        Mockito.when((Object)latestSavepoint.getEndToEndDuration()).thenReturn((Object)121191L);
        Mockito.when((Object)latestCompleted.getAlignmentBuffered()).thenReturn((Object)182813L);
        Mockito.when((Object)latestSavepoint.getExternalPath()).thenReturn((Object)"savepoint-external-path");
        FailedCheckpointStats latestFailed = (FailedCheckpointStats)Mockito.mock(FailedCheckpointStats.class);
        Mockito.when((Object)latestFailed.getCheckpointId()).thenReturn((Object)1112L);
        Mockito.when((Object)latestFailed.getTriggerTimestamp()).thenReturn((Object)12828L);
        Mockito.when((Object)latestFailed.getLatestAckTimestamp()).thenReturn((Object)1901L);
        Mockito.when((Object)latestFailed.getFailureTimestamp()).thenReturn((Object)11999976L);
        Mockito.when((Object)latestFailed.getStateSize()).thenReturn((Object)111L);
        Mockito.when((Object)latestFailed.getEndToEndDuration()).thenReturn((Object)12L);
        Mockito.when((Object)latestFailed.getAlignmentBuffered()).thenReturn((Object)2L);
        Mockito.when((Object)latestFailed.getFailureMessage()).thenReturn((Object)"expected cause");
        RestoredCheckpointStats latestRestored = (RestoredCheckpointStats)Mockito.mock(RestoredCheckpointStats.class);
        Mockito.when((Object)latestRestored.getCheckpointId()).thenReturn((Object)1199L);
        Mockito.when((Object)latestRestored.getRestoreTimestamp()).thenReturn((Object)434242L);
        Mockito.when((Object)latestRestored.getProperties()).thenReturn((Object)CheckpointProperties.forStandardSavepoint());
        Mockito.when((Object)latestRestored.getExternalPath()).thenReturn((Object)"restored savepoint path");
        CheckpointStatsHistory history = (CheckpointStatsHistory)Mockito.mock(CheckpointStatsHistory.class);
        ArrayList<Object> checkpoints = new ArrayList<Object>();
        PendingCheckpointStats inProgress = (PendingCheckpointStats)Mockito.mock(PendingCheckpointStats.class);
        Mockito.when((Object)inProgress.getCheckpointId()).thenReturn((Object)1992141L);
        Mockito.when((Object)inProgress.getStatus()).thenReturn((Object)CheckpointStatsStatus.IN_PROGRESS);
        Mockito.when((Object)inProgress.getProperties()).thenReturn((Object)CheckpointProperties.forStandardCheckpoint());
        Mockito.when((Object)inProgress.getTriggerTimestamp()).thenReturn((Object)1919191900L);
        Mockito.when((Object)inProgress.getLatestAckTimestamp()).thenReturn((Object)1977791901L);
        Mockito.when((Object)inProgress.getStateSize()).thenReturn((Object)111939272822L);
        Mockito.when((Object)inProgress.getEndToEndDuration()).thenReturn((Object)121191L);
        Mockito.when((Object)inProgress.getAlignmentBuffered()).thenReturn((Object)1L);
        Mockito.when((Object)inProgress.getNumberOfSubtasks()).thenReturn((Object)501);
        Mockito.when((Object)inProgress.getNumberOfAcknowledgedSubtasks()).thenReturn((Object)101);
        CompletedCheckpointStats completedSavepoint = (CompletedCheckpointStats)Mockito.mock(CompletedCheckpointStats.class);
        Mockito.when((Object)completedSavepoint.getCheckpointId()).thenReturn((Object)1322139L);
        Mockito.when((Object)completedSavepoint.getStatus()).thenReturn((Object)CheckpointStatsStatus.COMPLETED);
        Mockito.when((Object)completedSavepoint.getProperties()).thenReturn((Object)CheckpointProperties.forStandardSavepoint());
        Mockito.when((Object)completedSavepoint.getTriggerTimestamp()).thenReturn((Object)191900L);
        Mockito.when((Object)completedSavepoint.getLatestAckTimestamp()).thenReturn((Object)197791901L);
        Mockito.when((Object)completedSavepoint.getStateSize()).thenReturn((Object)1119822L);
        Mockito.when((Object)completedSavepoint.getEndToEndDuration()).thenReturn((Object)12191L);
        Mockito.when((Object)completedSavepoint.getAlignmentBuffered()).thenReturn((Object)111L);
        Mockito.when((Object)completedSavepoint.getNumberOfSubtasks()).thenReturn((Object)33501);
        Mockito.when((Object)completedSavepoint.getNumberOfAcknowledgedSubtasks()).thenReturn((Object)211);
        Mockito.when((Object)completedSavepoint.isDiscarded()).thenReturn((Object)true);
        Mockito.when((Object)completedSavepoint.getExternalPath()).thenReturn((Object)"completed-external-path");
        FailedCheckpointStats failed = (FailedCheckpointStats)Mockito.mock(FailedCheckpointStats.class);
        Mockito.when((Object)failed.getCheckpointId()).thenReturn((Object)110719L);
        Mockito.when((Object)failed.getStatus()).thenReturn((Object)CheckpointStatsStatus.FAILED);
        Mockito.when((Object)failed.getProperties()).thenReturn((Object)CheckpointProperties.forStandardCheckpoint());
        Mockito.when((Object)failed.getTriggerTimestamp()).thenReturn((Object)191900L);
        Mockito.when((Object)failed.getLatestAckTimestamp()).thenReturn((Object)197791901L);
        Mockito.when((Object)failed.getStateSize()).thenReturn((Object)1119822L);
        Mockito.when((Object)failed.getEndToEndDuration()).thenReturn((Object)12191L);
        Mockito.when((Object)failed.getAlignmentBuffered()).thenReturn((Object)111L);
        Mockito.when((Object)failed.getNumberOfSubtasks()).thenReturn((Object)33501);
        Mockito.when((Object)failed.getNumberOfAcknowledgedSubtasks()).thenReturn((Object)1);
        Mockito.when((Object)failed.getFailureTimestamp()).thenReturn((Object)119230L);
        Mockito.when((Object)failed.getFailureMessage()).thenReturn((Object)"failure message");
        checkpoints.add(inProgress);
        checkpoints.add(completedSavepoint);
        checkpoints.add(failed);
        Mockito.when((Object)history.getCheckpoints()).thenReturn(checkpoints);
        Mockito.when((Object)history.getLatestCompletedCheckpoint()).thenReturn((Object)latestCompleted);
        Mockito.when((Object)history.getLatestSavepoint()).thenReturn((Object)latestSavepoint);
        Mockito.when((Object)history.getLatestFailedCheckpoint()).thenReturn((Object)latestFailed);
        CheckpointStatsSnapshot snapshot = (CheckpointStatsSnapshot)Mockito.mock(CheckpointStatsSnapshot.class);
        Mockito.when((Object)snapshot.getCounts()).thenReturn((Object)counts);
        Mockito.when((Object)snapshot.getSummaryStats()).thenReturn((Object)summary);
        Mockito.when((Object)snapshot.getHistory()).thenReturn((Object)history);
        Mockito.when((Object)snapshot.getLatestRestoredCheckpoint()).thenReturn((Object)latestRestored);
        AccessExecutionGraph graph = (AccessExecutionGraph)Mockito.mock(AccessExecutionGraph.class);
        Mockito.when((Object)graph.getCheckpointStatsSnapshot()).thenReturn((Object)snapshot);
        return new TestCheckpointStats(graph, counts, stateSizeSummary, durationSummary, alignmentBufferedSummary, summary, latestCompleted, latestSavepoint, latestFailed, latestRestored, inProgress, completedSavepoint, failed, history, snapshot);
    }

    private static void compareCheckpointStats(TestCheckpointStats checkpointStats, JsonNode rootNode) {
        CheckpointStatsCounts counts = checkpointStats.counts;
        JsonNode countNode = rootNode.get("counts");
        Assert.assertEquals((long)counts.getNumberOfRestoredCheckpoints(), (long)countNode.get("restored").asLong());
        Assert.assertEquals((long)counts.getTotalNumberOfCheckpoints(), (long)countNode.get("total").asLong());
        Assert.assertEquals((long)counts.getNumberOfInProgressCheckpoints(), (long)countNode.get("in_progress").asLong());
        Assert.assertEquals((long)counts.getNumberOfCompletedCheckpoints(), (long)countNode.get("completed").asLong());
        Assert.assertEquals((long)counts.getNumberOfFailedCheckpoints(), (long)countNode.get("failed").asLong());
        MinMaxAvgStats stateSizeSummary = checkpointStats.stateSizeSummary;
        JsonNode summaryNode = rootNode.get("summary");
        JsonNode sizeSummaryNode = summaryNode.get("state_size");
        Assert.assertEquals((long)stateSizeSummary.getMinimum(), (long)sizeSummaryNode.get("min").asLong());
        Assert.assertEquals((long)stateSizeSummary.getMaximum(), (long)sizeSummaryNode.get("max").asLong());
        Assert.assertEquals((long)stateSizeSummary.getAverage(), (long)sizeSummaryNode.get("avg").asLong());
        MinMaxAvgStats durationSummary = checkpointStats.durationSummary;
        JsonNode durationSummaryNode = summaryNode.get("end_to_end_duration");
        Assert.assertEquals((long)durationSummary.getMinimum(), (long)durationSummaryNode.get("min").asLong());
        Assert.assertEquals((long)durationSummary.getMaximum(), (long)durationSummaryNode.get("max").asLong());
        Assert.assertEquals((long)durationSummary.getAverage(), (long)durationSummaryNode.get("avg").asLong());
        MinMaxAvgStats alignmentBufferedSummary = checkpointStats.alignmentBufferedSummary;
        JsonNode alignmentBufferedNode = summaryNode.get("alignment_buffered");
        Assert.assertEquals((long)alignmentBufferedSummary.getMinimum(), (long)alignmentBufferedNode.get("min").asLong());
        Assert.assertEquals((long)alignmentBufferedSummary.getMaximum(), (long)alignmentBufferedNode.get("max").asLong());
        Assert.assertEquals((long)alignmentBufferedSummary.getAverage(), (long)alignmentBufferedNode.get("avg").asLong());
        CompletedCheckpointStats latestCompleted = checkpointStats.latestCompleted;
        JsonNode latestNode = rootNode.get("latest");
        JsonNode latestCheckpointNode = latestNode.get("completed");
        Assert.assertEquals((long)latestCompleted.getCheckpointId(), (long)latestCheckpointNode.get("id").asLong());
        Assert.assertEquals((long)latestCompleted.getTriggerTimestamp(), (long)latestCheckpointNode.get("trigger_timestamp").asLong());
        Assert.assertEquals((long)latestCompleted.getLatestAckTimestamp(), (long)latestCheckpointNode.get("latest_ack_timestamp").asLong());
        Assert.assertEquals((long)latestCompleted.getStateSize(), (long)latestCheckpointNode.get("state_size").asLong());
        Assert.assertEquals((long)latestCompleted.getEndToEndDuration(), (long)latestCheckpointNode.get("end_to_end_duration").asLong());
        Assert.assertEquals((long)latestCompleted.getAlignmentBuffered(), (long)latestCheckpointNode.get("alignment_buffered").asLong());
        Assert.assertEquals((Object)latestCompleted.getExternalPath(), (Object)latestCheckpointNode.get("external_path").asText());
        CompletedCheckpointStats latestSavepoint = checkpointStats.latestSavepoint;
        JsonNode latestSavepointNode = latestNode.get("savepoint");
        Assert.assertEquals((long)latestSavepoint.getCheckpointId(), (long)latestSavepointNode.get("id").asLong());
        Assert.assertEquals((long)latestSavepoint.getTriggerTimestamp(), (long)latestSavepointNode.get("trigger_timestamp").asLong());
        Assert.assertEquals((long)latestSavepoint.getLatestAckTimestamp(), (long)latestSavepointNode.get("latest_ack_timestamp").asLong());
        Assert.assertEquals((long)latestSavepoint.getStateSize(), (long)latestSavepointNode.get("state_size").asLong());
        Assert.assertEquals((long)latestSavepoint.getEndToEndDuration(), (long)latestSavepointNode.get("end_to_end_duration").asLong());
        Assert.assertEquals((long)latestSavepoint.getAlignmentBuffered(), (long)latestSavepointNode.get("alignment_buffered").asLong());
        Assert.assertEquals((Object)latestSavepoint.getExternalPath(), (Object)latestSavepointNode.get("external_path").asText());
        FailedCheckpointStats latestFailed = checkpointStats.latestFailed;
        JsonNode latestFailedNode = latestNode.get("failed");
        Assert.assertEquals((long)latestFailed.getCheckpointId(), (long)latestFailedNode.get("id").asLong());
        Assert.assertEquals((long)latestFailed.getTriggerTimestamp(), (long)latestFailedNode.get("trigger_timestamp").asLong());
        Assert.assertEquals((long)latestFailed.getLatestAckTimestamp(), (long)latestFailedNode.get("latest_ack_timestamp").asLong());
        Assert.assertEquals((long)latestFailed.getStateSize(), (long)latestFailedNode.get("state_size").asLong());
        Assert.assertEquals((long)latestFailed.getEndToEndDuration(), (long)latestFailedNode.get("end_to_end_duration").asLong());
        Assert.assertEquals((long)latestFailed.getAlignmentBuffered(), (long)latestFailedNode.get("alignment_buffered").asLong());
        Assert.assertEquals((long)latestFailed.getFailureTimestamp(), (long)latestFailedNode.get("failure_timestamp").asLong());
        Assert.assertEquals((Object)latestFailed.getFailureMessage(), (Object)latestFailedNode.get("failure_message").asText());
        RestoredCheckpointStats latestRestored = checkpointStats.latestRestored;
        JsonNode latestRestoredNode = latestNode.get("restored");
        Assert.assertEquals((long)latestRestored.getCheckpointId(), (long)latestRestoredNode.get("id").asLong());
        Assert.assertEquals((long)latestRestored.getRestoreTimestamp(), (long)latestRestoredNode.get("restore_timestamp").asLong());
        Assert.assertEquals((Object)latestRestored.getProperties().isSavepoint(), (Object)latestRestoredNode.get("is_savepoint").asBoolean());
        Assert.assertEquals((Object)latestRestored.getExternalPath(), (Object)latestRestoredNode.get("external_path").asText());
        JsonNode historyNode = rootNode.get("history");
        Iterator it = historyNode.iterator();
        Assert.assertTrue((boolean)it.hasNext());
        JsonNode inProgressNode = (JsonNode)it.next();
        PendingCheckpointStats inProgress = checkpointStats.inProgress;
        CheckpointStatsHandlerTest.compareInProgressCheckpoint(inProgress, inProgressNode);
        Assert.assertTrue((boolean)it.hasNext());
        JsonNode completedSavepointNode = (JsonNode)it.next();
        CompletedCheckpointStats completedSavepoint = checkpointStats.completedSavepoint;
        CheckpointStatsHandlerTest.compareCompletedSavepoint(completedSavepoint, completedSavepointNode);
        Assert.assertTrue((boolean)it.hasNext());
        JsonNode failedNode = (JsonNode)it.next();
        FailedCheckpointStats failed = checkpointStats.failed;
        CheckpointStatsHandlerTest.compareFailedCheckpoint(failed, failedNode);
        Assert.assertFalse((boolean)it.hasNext());
    }

    private static void compareInProgressCheckpoint(PendingCheckpointStats inProgress, JsonNode inProgressNode) {
        Assert.assertEquals((long)inProgress.getCheckpointId(), (long)inProgressNode.get("id").asLong());
        Assert.assertEquals((Object)inProgress.getStatus().toString(), (Object)inProgressNode.get("status").asText());
        Assert.assertEquals((Object)inProgress.getProperties().isSavepoint(), (Object)inProgressNode.get("is_savepoint").asBoolean());
        Assert.assertEquals((long)inProgress.getTriggerTimestamp(), (long)inProgressNode.get("trigger_timestamp").asLong());
        Assert.assertEquals((long)inProgress.getLatestAckTimestamp(), (long)inProgressNode.get("latest_ack_timestamp").asLong());
        Assert.assertEquals((long)inProgress.getStateSize(), (long)inProgressNode.get("state_size").asLong());
        Assert.assertEquals((long)inProgress.getEndToEndDuration(), (long)inProgressNode.get("end_to_end_duration").asLong());
        Assert.assertEquals((long)inProgress.getAlignmentBuffered(), (long)inProgressNode.get("alignment_buffered").asLong());
        Assert.assertEquals((long)inProgress.getNumberOfSubtasks(), (long)inProgressNode.get("num_subtasks").asInt());
        Assert.assertEquals((long)inProgress.getNumberOfAcknowledgedSubtasks(), (long)inProgressNode.get("num_acknowledged_subtasks").asInt());
    }

    private static void compareCompletedSavepoint(CompletedCheckpointStats completedSavepoint, JsonNode completedSavepointNode) {
        Assert.assertEquals((long)completedSavepoint.getCheckpointId(), (long)completedSavepointNode.get("id").asLong());
        Assert.assertEquals((Object)completedSavepoint.getStatus().toString(), (Object)completedSavepointNode.get("status").asText());
        Assert.assertEquals((Object)completedSavepoint.getProperties().isSavepoint(), (Object)completedSavepointNode.get("is_savepoint").asBoolean());
        Assert.assertEquals((long)completedSavepoint.getTriggerTimestamp(), (long)completedSavepointNode.get("trigger_timestamp").asLong());
        Assert.assertEquals((long)completedSavepoint.getLatestAckTimestamp(), (long)completedSavepointNode.get("latest_ack_timestamp").asLong());
        Assert.assertEquals((long)completedSavepoint.getStateSize(), (long)completedSavepointNode.get("state_size").asLong());
        Assert.assertEquals((long)completedSavepoint.getEndToEndDuration(), (long)completedSavepointNode.get("end_to_end_duration").asLong());
        Assert.assertEquals((long)completedSavepoint.getAlignmentBuffered(), (long)completedSavepointNode.get("alignment_buffered").asLong());
        Assert.assertEquals((long)completedSavepoint.getNumberOfSubtasks(), (long)completedSavepointNode.get("num_subtasks").asInt());
        Assert.assertEquals((long)completedSavepoint.getNumberOfAcknowledgedSubtasks(), (long)completedSavepointNode.get("num_acknowledged_subtasks").asInt());
        Assert.assertEquals((Object)completedSavepoint.getExternalPath(), (Object)completedSavepointNode.get("external_path").asText());
        Assert.assertEquals((Object)completedSavepoint.isDiscarded(), (Object)completedSavepointNode.get("discarded").asBoolean());
    }

    private static void compareFailedCheckpoint(FailedCheckpointStats failed, JsonNode failedNode) {
        Assert.assertEquals((long)failed.getCheckpointId(), (long)failedNode.get("id").asLong());
        Assert.assertEquals((Object)failed.getStatus().toString(), (Object)failedNode.get("status").asText());
        Assert.assertEquals((Object)failed.getProperties().isSavepoint(), (Object)failedNode.get("is_savepoint").asBoolean());
        Assert.assertEquals((long)failed.getTriggerTimestamp(), (long)failedNode.get("trigger_timestamp").asLong());
        Assert.assertEquals((long)failed.getLatestAckTimestamp(), (long)failedNode.get("latest_ack_timestamp").asLong());
        Assert.assertEquals((long)failed.getStateSize(), (long)failedNode.get("state_size").asLong());
        Assert.assertEquals((long)failed.getEndToEndDuration(), (long)failedNode.get("end_to_end_duration").asLong());
        Assert.assertEquals((long)failed.getAlignmentBuffered(), (long)failedNode.get("alignment_buffered").asLong());
        Assert.assertEquals((long)failed.getNumberOfSubtasks(), (long)failedNode.get("num_subtasks").asInt());
        Assert.assertEquals((long)failed.getNumberOfAcknowledgedSubtasks(), (long)failedNode.get("num_acknowledged_subtasks").asInt());
        Assert.assertEquals((long)failed.getFailureTimestamp(), (long)failedNode.get("failure_timestamp").asLong());
        Assert.assertEquals((Object)failed.getFailureMessage(), (Object)failedNode.get("failure_message").asText());
    }

    private static class TestCheckpointStats {
        public final AccessExecutionGraph graph;
        public final CheckpointStatsCounts counts;
        public final MinMaxAvgStats stateSizeSummary;
        public final MinMaxAvgStats durationSummary;
        public final MinMaxAvgStats alignmentBufferedSummary;
        public final CompletedCheckpointStatsSummary summary;
        public final CompletedCheckpointStats latestCompleted;
        public final CompletedCheckpointStats latestSavepoint;
        public final FailedCheckpointStats latestFailed;
        public final RestoredCheckpointStats latestRestored;
        public final PendingCheckpointStats inProgress;
        public final CompletedCheckpointStats completedSavepoint;
        public final FailedCheckpointStats failed;
        public final CheckpointStatsHistory history;
        public final CheckpointStatsSnapshot snapshot;

        public TestCheckpointStats(AccessExecutionGraph graph, CheckpointStatsCounts counts, MinMaxAvgStats stateSizeSummary, MinMaxAvgStats durationSummary, MinMaxAvgStats alignmentBufferedSummary, CompletedCheckpointStatsSummary summary, CompletedCheckpointStats latestCompleted, CompletedCheckpointStats latestSavepoint, FailedCheckpointStats latestFailed, RestoredCheckpointStats latestRestored, PendingCheckpointStats inProgress, CompletedCheckpointStats completedSavepoint, FailedCheckpointStats failed, CheckpointStatsHistory history, CheckpointStatsSnapshot snapshot) {
            this.graph = graph;
            this.counts = counts;
            this.stateSizeSummary = stateSizeSummary;
            this.durationSummary = durationSummary;
            this.alignmentBufferedSummary = alignmentBufferedSummary;
            this.summary = summary;
            this.latestCompleted = latestCompleted;
            this.latestSavepoint = latestSavepoint;
            this.latestFailed = latestFailed;
            this.latestRestored = latestRestored;
            this.inProgress = inProgress;
            this.completedSavepoint = completedSavepoint;
            this.failed = failed;
            this.history = history;
            this.snapshot = snapshot;
        }
    }
}

