/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy.metrics;

import java.util.HashMap;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.rest.handler.legacy.metrics.JobVertexMetricsHandler;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStoreTest;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.runtime.webmonitor.retriever.MetricQueryServiceRetriever;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.powermock.api.mockito.PowerMockito;

public class AbstractMetricsHandlerTest
extends TestLogger {
    @Test
    public void testHandleRequest() throws Exception {
        MetricFetcher fetcher = new MetricFetcher((GatewayRetriever)PowerMockito.mock(GatewayRetriever.class), (MetricQueryServiceRetriever)PowerMockito.mock(MetricQueryServiceRetriever.class), Executors.directExecutor(), TestingUtils.TIMEOUT());
        MetricStoreTest.setupStore(fetcher.getMetricStore());
        JobVertexMetricsHandler handler = new JobVertexMetricsHandler(Executors.directExecutor(), fetcher);
        HashMap<String, String> pathParams = new HashMap<String, String>();
        HashMap<String, String> queryParams = new HashMap<String, String>();
        pathParams.put("jobid", "jobid");
        pathParams.put("vertexid", "taskid");
        String availableList = (String)handler.handleJsonRequest(pathParams, queryParams, null).get();
        Assert.assertEquals((Object)"[{\"id\":\"8.opname.abc.metric6\"},{\"id\":\"8.opname.abc.metric7\"},{\"id\":\"1.opname.abc.metric6\"},{\"id\":\"1.opname.abc.metric7\"},{\"id\":\"8.abc.metric5\"}]", (Object)availableList);
        queryParams.put("get", "8.opname.abc.metric6");
        String metricValue = (String)handler.handleJsonRequest(pathParams, queryParams, null).get();
        Assert.assertEquals((Object)"[{\"id\":\"8.opname.abc.metric6\",\"value\":\"5\"}]", (Object)metricValue);
        queryParams.put("get", "8.opname.abc.metric6,8.abc.metric5");
        String metricValues = (String)handler.handleJsonRequest(pathParams, queryParams, null).get();
        Assert.assertEquals((Object)"[{\"id\":\"8.opname.abc.metric6\",\"value\":\"5\"},{\"id\":\"8.abc.metric5\",\"value\":\"4\"}]", (Object)metricValues);
    }

    @Test
    public void testInvalidListDoesNotFail() {
        MetricFetcher fetcher = new MetricFetcher((GatewayRetriever)PowerMockito.mock(GatewayRetriever.class), (MetricQueryServiceRetriever)PowerMockito.mock(MetricQueryServiceRetriever.class), Executors.directExecutor(), TestingUtils.TIMEOUT());
        MetricStoreTest.setupStore(fetcher.getMetricStore());
        JobVertexMetricsHandler handler = new JobVertexMetricsHandler(Executors.directExecutor(), fetcher);
        HashMap<String, String> pathParams = new HashMap<String, String>();
        HashMap queryParams = new HashMap();
        pathParams.put("jobid", "jobid");
        pathParams.put("vertexid", "taskid");
        pathParams.put("jobid", "nonexistent");
        try {
            Assert.assertEquals((Object)"", handler.handleJsonRequest(pathParams, queryParams, null).get());
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testInvalidGetDoesNotFail() {
        MetricFetcher fetcher = new MetricFetcher((GatewayRetriever)PowerMockito.mock(GatewayRetriever.class), (MetricQueryServiceRetriever)PowerMockito.mock(MetricQueryServiceRetriever.class), Executors.directExecutor(), TestingUtils.TIMEOUT());
        MetricStoreTest.setupStore(fetcher.getMetricStore());
        JobVertexMetricsHandler handler = new JobVertexMetricsHandler(Executors.directExecutor(), fetcher);
        HashMap<String, String> pathParams = new HashMap<String, String>();
        HashMap<String, String> queryParams = new HashMap<String, String>();
        pathParams.put("jobid", "jobid");
        pathParams.put("vertexid", "taskid");
        queryParams.put("get", "");
        try {
            Assert.assertEquals((Object)"", handler.handleJsonRequest(pathParams, queryParams, null).get());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        pathParams.put("jobid", "nonexistent");
        queryParams.put("get", "subindex.opname.abc.metric5");
        try {
            Assert.assertEquals((Object)"", handler.handleJsonRequest(pathParams, queryParams, null).get());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        pathParams.put("jobid", "nonexistant");
        queryParams.put("get", "subindex.opname.abc.nonexistant");
        try {
            Assert.assertEquals((Object)"", handler.handleJsonRequest(pathParams, queryParams, null).get());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

