/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy.metrics;

import java.util.Collection;
import java.util.HashMap;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.rest.handler.legacy.metrics.AggregatingSubtasksMetricsHandler;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStoreTest;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.runtime.webmonitor.retriever.MetricQueryServiceRetriever;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.powermock.api.mockito.PowerMockito;

public class AggregatingSubtasksMetricsHandlerTest
extends TestLogger {
    @Test
    public void testGetPaths() {
        AggregatingSubtasksMetricsHandler handler = new AggregatingSubtasksMetricsHandler(Executors.directExecutor(), (MetricFetcher)PowerMockito.mock(MetricFetcher.class));
        String[] paths = handler.getPaths();
        Assert.assertEquals((long)1L, (long)paths.length);
        Assert.assertEquals((Object)"/jobs/:jobid/vertices/:vertexid/subtasks/metrics", (Object)paths[0]);
    }

    @Test
    public void getStores() throws Exception {
        MetricFetcher fetcher = new MetricFetcher((GatewayRetriever)PowerMockito.mock(GatewayRetriever.class), (MetricQueryServiceRetriever)PowerMockito.mock(MetricQueryServiceRetriever.class), Executors.directExecutor(), TestingUtils.TIMEOUT());
        MetricStore store = MetricStoreTest.setupStore(fetcher.getMetricStore());
        AggregatingSubtasksMetricsHandler handler = new AggregatingSubtasksMetricsHandler(Executors.directExecutor(), fetcher);
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("jobid", "jobid");
        pathParams.put("vertexid", "taskid");
        HashMap queryParams = new HashMap();
        Collection stores = handler.getStores(store, pathParams, queryParams);
        Assert.assertEquals((long)2L, (long)stores.size());
    }
}

