/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy.metrics;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.rest.handler.legacy.metrics.JobVertexMetricsHandler;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStoreTest;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.runtime.webmonitor.retriever.MetricQueryServiceRetriever;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.powermock.api.mockito.PowerMockito;

public class JobVertexMetricsHandlerTest
extends TestLogger {
    @Test
    public void testGetPaths() {
        JobVertexMetricsHandler handler = new JobVertexMetricsHandler(Executors.directExecutor(), (MetricFetcher)PowerMockito.mock(MetricFetcher.class));
        String[] paths = handler.getPaths();
        Assert.assertEquals((long)1L, (long)paths.length);
        Assert.assertEquals((Object)"/jobs/:jobid/vertices/:vertexid/metrics", (Object)paths[0]);
    }

    @Test
    public void getMapFor() throws Exception {
        MetricFetcher fetcher = new MetricFetcher((GatewayRetriever)PowerMockito.mock(GatewayRetriever.class), (MetricQueryServiceRetriever)PowerMockito.mock(MetricQueryServiceRetriever.class), Executors.directExecutor(), TestingUtils.TIMEOUT());
        MetricStore store = MetricStoreTest.setupStore(fetcher.getMetricStore());
        JobVertexMetricsHandler handler = new JobVertexMetricsHandler(Executors.directExecutor(), fetcher);
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("jobid", "jobid");
        pathParams.put("vertexid", "taskid");
        Map metrics = handler.getMapFor(pathParams, store);
        Assert.assertEquals((Object)"4", metrics.get("8.abc.metric5"));
        Assert.assertEquals((Object)"5", metrics.get("8.opname.abc.metric6"));
        Assert.assertEquals((Object)"6", metrics.get("8.opname.abc.metric7"));
    }

    @Test
    public void getMapForNull() {
        MetricFetcher fetcher = new MetricFetcher((GatewayRetriever)PowerMockito.mock(GatewayRetriever.class), (MetricQueryServiceRetriever)PowerMockito.mock(MetricQueryServiceRetriever.class), Executors.directExecutor(), TestingUtils.TIMEOUT());
        MetricStore store = fetcher.getMetricStore();
        JobVertexMetricsHandler handler = new JobVertexMetricsHandler(Executors.directExecutor(), fetcher);
        HashMap pathParams = new HashMap();
        Map metrics = handler.getMapFor(pathParams, store);
        Assert.assertNull((Object)metrics);
    }
}

