/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy.utils;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MeterView;
import org.apache.flink.runtime.accumulators.StringifiedAccumulatorResult;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ArchivedExecution;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.IOMetrics;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.Preconditions;

public class ArchivedExecutionBuilder {
    private ExecutionAttemptID attemptId;
    private long[] stateTimestamps;
    private int attemptNumber;
    private ExecutionState state;
    private String failureCause;
    private TaskManagerLocation assignedResourceLocation;
    private StringifiedAccumulatorResult[] userAccumulators;
    private IOMetrics ioMetrics;
    private int parallelSubtaskIndex;

    public ArchivedExecutionBuilder setAttemptId(ExecutionAttemptID attemptId) {
        this.attemptId = attemptId;
        return this;
    }

    public ArchivedExecutionBuilder setStateTimestamps(long[] stateTimestamps) {
        Preconditions.checkArgument((stateTimestamps.length == ExecutionState.values().length ? 1 : 0) != 0);
        this.stateTimestamps = stateTimestamps;
        return this;
    }

    public ArchivedExecutionBuilder setAttemptNumber(int attemptNumber) {
        this.attemptNumber = attemptNumber;
        return this;
    }

    public ArchivedExecutionBuilder setState(ExecutionState state) {
        this.state = state;
        return this;
    }

    public ArchivedExecutionBuilder setFailureCause(String failureCause) {
        this.failureCause = failureCause;
        return this;
    }

    public ArchivedExecutionBuilder setAssignedResourceLocation(TaskManagerLocation assignedResourceLocation) {
        this.assignedResourceLocation = assignedResourceLocation;
        return this;
    }

    public ArchivedExecutionBuilder setUserAccumulators(StringifiedAccumulatorResult[] userAccumulators) {
        this.userAccumulators = userAccumulators;
        return this;
    }

    public ArchivedExecutionBuilder setParallelSubtaskIndex(int parallelSubtaskIndex) {
        this.parallelSubtaskIndex = parallelSubtaskIndex;
        return this;
    }

    public ArchivedExecutionBuilder setIOMetrics(IOMetrics ioMetrics) {
        this.ioMetrics = ioMetrics;
        return this;
    }

    public ArchivedExecution build() throws UnknownHostException {
        long[] lArray;
        StringifiedAccumulatorResult[] stringifiedAccumulatorResultArray = this.userAccumulators != null ? this.userAccumulators : new StringifiedAccumulatorResult[]{};
        Object object = this.ioMetrics != null ? this.ioMetrics : new TestIOMetrics();
        ExecutionAttemptID executionAttemptID = this.attemptId != null ? this.attemptId : new ExecutionAttemptID();
        ExecutionState executionState = this.state != null ? this.state : ExecutionState.FINISHED;
        String string = this.failureCause != null ? this.failureCause : "(null)";
        TaskManagerLocation taskManagerLocation = this.assignedResourceLocation != null ? this.assignedResourceLocation : new TaskManagerLocation(new ResourceID("tm"), InetAddress.getLocalHost(), 1234);
        if (this.stateTimestamps != null) {
            lArray = this.stateTimestamps;
        } else {
            long[] lArray2 = new long[8];
            lArray2[0] = 1L;
            lArray2[1] = 2L;
            lArray2[2] = 3L;
            lArray2[3] = 4L;
            lArray2[4] = 5L;
            lArray2[5] = 5L;
            lArray2[6] = 5L;
            lArray = lArray2;
            lArray2[7] = 5L;
        }
        return new ArchivedExecution(stringifiedAccumulatorResultArray, object, executionAttemptID, this.attemptNumber, executionState, string, taskManagerLocation, this.parallelSubtaskIndex, lArray);
    }

    private static class TestCounter
    implements Counter {
        private final long count;

        private TestCounter(long count) {
            this.count = count;
        }

        public void inc() {
        }

        public void inc(long n) {
        }

        public void dec() {
        }

        public void dec(long n) {
        }

        public long getCount() {
            return this.count;
        }
    }

    private static class TestIOMetrics
    extends IOMetrics {
        private static final long serialVersionUID = -5920076211680012555L;

        public TestIOMetrics() {
            super((Meter)new MeterView((Counter)new TestCounter(1L), 0), (Meter)new MeterView((Counter)new TestCounter(2L), 0), (Meter)new MeterView((Counter)new TestCounter(3L), 0), (Meter)new MeterView((Counter)new TestCounter(4L), 0), (Meter)new MeterView((Counter)new TestCounter(5L), 0));
        }
    }
}

