/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy.utils;

import java.net.InetAddress;
import java.util.HashMap;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.accumulators.StringifiedAccumulatorResult;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecution;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.executiongraph.ArchivedExecution;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionVertex;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.apache.flink.runtime.executiongraph.IOMetrics;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedExecutionBuilder;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedExecutionGraphBuilder;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedExecutionJobVertexBuilder;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedExecutionVertexBuilder;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonFactory;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.junit.Assert;

public class ArchivedJobGenerationUtils {
    public static final ObjectMapper MAPPER = new ObjectMapper();
    public static final JsonFactory JACKSON_FACTORY = new JsonFactory().enable(JsonGenerator.Feature.AUTO_CLOSE_TARGET).disable(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT);
    private static ArchivedExecutionGraph originalJob;
    private static ArchivedExecutionJobVertex originalTask;
    private static ArchivedExecutionVertex originalSubtask;
    private static ArchivedExecution originalAttempt;
    private static final Object lock;

    private ArchivedJobGenerationUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccessExecutionGraph getTestJob() throws Exception {
        Object object = lock;
        synchronized (object) {
            if (originalJob == null) {
                ArchivedJobGenerationUtils.generateArchivedJob();
            }
        }
        return originalJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccessExecutionJobVertex getTestTask() throws Exception {
        Object object = lock;
        synchronized (object) {
            if (originalJob == null) {
                ArchivedJobGenerationUtils.generateArchivedJob();
            }
        }
        return originalTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccessExecutionVertex getTestSubtask() throws Exception {
        Object object = lock;
        synchronized (object) {
            if (originalJob == null) {
                ArchivedJobGenerationUtils.generateArchivedJob();
            }
        }
        return originalSubtask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccessExecution getTestAttempt() throws Exception {
        Object object = lock;
        synchronized (object) {
            if (originalJob == null) {
                ArchivedJobGenerationUtils.generateArchivedJob();
            }
        }
        return originalAttempt;
    }

    private static void generateArchivedJob() throws Exception {
        StringifiedAccumulatorResult acc1 = new StringifiedAccumulatorResult("name1", "type1", "value1");
        StringifiedAccumulatorResult acc2 = new StringifiedAccumulatorResult("name2", "type2", "value2");
        TaskManagerLocation location = new TaskManagerLocation(new ResourceID("hello"), InetAddress.getLocalHost(), 1234);
        originalAttempt = new ArchivedExecutionBuilder().setStateTimestamps(new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L}).setParallelSubtaskIndex(1).setAttemptNumber(0).setAssignedResourceLocation(location).setUserAccumulators(new StringifiedAccumulatorResult[]{acc1, acc2}).setState(ExecutionState.FINISHED).setFailureCause("attemptException").build();
        originalSubtask = new ArchivedExecutionVertexBuilder().setSubtaskIndex(originalAttempt.getParallelSubtaskIndex()).setTaskNameWithSubtask("hello(1/1)").setCurrentExecution(originalAttempt).build();
        originalTask = new ArchivedExecutionJobVertexBuilder().setTaskVertices(new ArchivedExecutionVertex[]{originalSubtask}).build();
        HashMap<JobVertexID, ArchivedExecutionJobVertex> tasks = new HashMap<JobVertexID, ArchivedExecutionJobVertex>();
        tasks.put(originalTask.getJobVertexId(), originalTask);
        originalJob = new ArchivedExecutionGraphBuilder().setJobID(new JobID()).setTasks(tasks).setFailureCause(new ErrorInfo((Throwable)new Exception("jobException"), originalAttempt.getStateTimestamp(ExecutionState.FAILED))).setState(JobStatus.FINISHED).setStateTimestamps(new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L}).setArchivedUserAccumulators(new StringifiedAccumulatorResult[]{acc1, acc2}).build();
    }

    public static void compareStringifiedAccumulators(StringifiedAccumulatorResult[] expectedAccs, ArrayNode writtenAccs) {
        Assert.assertEquals((long)expectedAccs.length, (long)writtenAccs.size());
        for (int x = 0; x < expectedAccs.length; ++x) {
            JsonNode acc = writtenAccs.get(x);
            Assert.assertEquals((Object)expectedAccs[x].getName(), (Object)acc.get("name").asText());
            Assert.assertEquals((Object)expectedAccs[x].getType(), (Object)acc.get("type").asText());
            Assert.assertEquals((Object)expectedAccs[x].getValue(), (Object)acc.get("value").asText());
        }
    }

    public static void compareIoMetrics(IOMetrics expectedMetrics, JsonNode writtenMetrics) {
        Assert.assertEquals((long)expectedMetrics.getNumBytesInTotal(), (long)writtenMetrics.get("read-bytes").asLong());
        Assert.assertEquals((long)expectedMetrics.getNumBytesOut(), (long)writtenMetrics.get("write-bytes").asLong());
        Assert.assertEquals((long)expectedMetrics.getNumRecordsIn(), (long)writtenMetrics.get("read-records").asLong());
        Assert.assertEquals((long)expectedMetrics.getNumRecordsOut(), (long)writtenMetrics.get("write-records").asLong());
    }

    static {
        lock = new Object();
    }
}

