/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc.akka;

import akka.actor.ActorSystem;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValueFactory;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.rpc.RpcEndpoint;
import org.apache.flink.runtime.rpc.RpcGateway;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.akka.AkkaRpcService;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class MessageSerializationTest
extends TestLogger {
    private static ActorSystem actorSystem1;
    private static ActorSystem actorSystem2;
    private static AkkaRpcService akkaRpcService1;
    private static AkkaRpcService akkaRpcService2;
    private static final Time timeout;
    private static final int maxFrameSize = 32000;

    @BeforeClass
    public static void setup() {
        Config akkaConfig = AkkaUtils.getDefaultAkkaConfig();
        Config modifiedAkkaConfig = akkaConfig.withValue("akka.remote.netty.tcp.maximum-frame-size", ConfigValueFactory.fromAnyRef((Object)"32000b"));
        actorSystem1 = AkkaUtils.createActorSystem((Config)modifiedAkkaConfig);
        actorSystem2 = AkkaUtils.createActorSystem((Config)modifiedAkkaConfig);
        akkaRpcService1 = new AkkaRpcService(actorSystem1, timeout);
        akkaRpcService2 = new AkkaRpcService(actorSystem2, timeout);
    }

    @AfterClass
    public static void teardown() {
        akkaRpcService1.stopService();
        akkaRpcService2.stopService();
        actorSystem1.shutdown();
        actorSystem2.shutdown();
        actorSystem1.awaitTermination();
        actorSystem2.awaitTermination();
    }

    @Test
    public void testNonSerializableLocalMessageTransfer() throws Exception {
        LinkedBlockingQueue<Object> linkedBlockingQueue = new LinkedBlockingQueue<Object>();
        TestEndpoint testEndpoint = new TestEndpoint((RpcService)akkaRpcService1, linkedBlockingQueue);
        testEndpoint.start();
        TestGateway testGateway = (TestGateway)testEndpoint.getSelfGateway(TestGateway.class);
        NonSerializableObject expected = new NonSerializableObject(42);
        testGateway.foobar(expected);
        Assert.assertThat((Object)linkedBlockingQueue.take(), (Matcher)Is.is((Object)expected));
    }

    @Test(expected=IOException.class)
    public void testNonSerializableRemoteMessageTransfer() throws Exception {
        LinkedBlockingQueue<Object> linkedBlockingQueue = new LinkedBlockingQueue<Object>();
        TestEndpoint testEndpoint = new TestEndpoint((RpcService)akkaRpcService1, linkedBlockingQueue);
        testEndpoint.start();
        String address = testEndpoint.getAddress();
        CompletableFuture remoteGatewayFuture = akkaRpcService2.connect(address, TestGateway.class);
        TestGateway remoteGateway = (TestGateway)remoteGatewayFuture.get(timeout.getSize(), timeout.getUnit());
        remoteGateway.foobar(new Object());
        Assert.fail((String)"Should have failed because Object is not serializable.");
    }

    @Test
    public void testSerializableRemoteMessageTransfer() throws Exception {
        LinkedBlockingQueue<Object> linkedBlockingQueue = new LinkedBlockingQueue<Object>();
        TestEndpoint testEndpoint = new TestEndpoint((RpcService)akkaRpcService1, linkedBlockingQueue);
        testEndpoint.start();
        String address = testEndpoint.getAddress();
        CompletableFuture remoteGatewayFuture = akkaRpcService2.connect(address, TestGateway.class);
        TestGateway remoteGateway = (TestGateway)remoteGatewayFuture.get(timeout.getSize(), timeout.getUnit());
        int expected = 42;
        remoteGateway.foobar(expected);
        Assert.assertThat((Object)linkedBlockingQueue.take(), (Matcher)Is.is((Object)expected));
    }

    @Test(expected=IOException.class)
    public void testMaximumFramesizeRemoteMessageTransfer() throws Exception {
        LinkedBlockingQueue<Object> linkedBlockingQueue = new LinkedBlockingQueue<Object>();
        TestEndpoint testEndpoint = new TestEndpoint((RpcService)akkaRpcService1, linkedBlockingQueue);
        testEndpoint.start();
        String address = testEndpoint.getAddress();
        CompletableFuture remoteGatewayFuture = akkaRpcService2.connect(address, TestGateway.class);
        TestGateway remoteGateway = (TestGateway)remoteGatewayFuture.get(timeout.getSize(), timeout.getUnit());
        int bufferSize = 32001;
        byte[] buffer = new byte[bufferSize];
        remoteGateway.foobar(buffer);
        Assert.fail((String)"Should have failed due to exceeding the maximum framesize.");
    }

    static {
        timeout = Time.seconds((long)10L);
    }

    private static class NonSerializableObject {
        private final Object object = new Object();
        private final int value;

        NonSerializableObject(int value) {
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (obj instanceof NonSerializableObject) {
                NonSerializableObject nonSerializableObject = (NonSerializableObject)obj;
                return this.value == nonSerializableObject.value;
            }
            return false;
        }

        public int hashCode() {
            return this.value * 41;
        }
    }

    private static class TestEndpoint
    extends RpcEndpoint
    implements TestGateway {
        private final LinkedBlockingQueue<Object> queue;

        protected TestEndpoint(RpcService rpcService, LinkedBlockingQueue<Object> queue) {
            super(rpcService);
            this.queue = queue;
        }

        @Override
        public void foobar(Object object) throws InterruptedException {
            this.queue.put(object);
        }
    }

    private static interface TestGateway
    extends RpcGateway {
        public void foobar(Object var1) throws IOException, InterruptedException;
    }
}

