/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.net.InetAddress;
import java.util.Random;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.core.memory.MemoryType;
import org.apache.flink.runtime.taskexecutor.QueryableStateConfiguration;
import org.apache.flink.runtime.taskexecutor.TaskManagerServices;
import org.apache.flink.runtime.taskexecutor.TaskManagerServicesConfiguration;
import org.apache.flink.runtime.taskmanager.NetworkEnvironmentConfiguration;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={EnvironmentInformation.class})
public class TaskManagerServicesTest {
    @Test
    public void calculateNetworkBufOld() throws Exception {
        Configuration config = new Configuration();
        config.setInteger(TaskManagerOptions.NETWORK_NUM_BUFFERS, 1);
        Assert.assertEquals((long)((Integer)TaskManagerOptions.MEMORY_SEGMENT_SIZE.defaultValue()).longValue(), (long)TaskManagerServices.calculateNetworkBufferMemory((long)0xA00000L, (Configuration)config));
        Assert.assertEquals((long)((Integer)TaskManagerOptions.MEMORY_SEGMENT_SIZE.defaultValue()).longValue(), (long)TaskManagerServices.calculateNetworkBufferMemory((long)0x4000000L, (Configuration)config));
        int numBuffers = (int)(0x200000000L / (long)((Integer)TaskManagerOptions.MEMORY_SEGMENT_SIZE.defaultValue()).intValue());
        config.setInteger(TaskManagerOptions.NETWORK_NUM_BUFFERS, numBuffers);
        Assert.assertEquals((long)0x200000000L, (long)TaskManagerServices.calculateNetworkBufferMemory((long)0x400000000L, (Configuration)config));
    }

    @Test
    public void calculateNetworkBufNew() throws Exception {
        Configuration config = new Configuration();
        Float defaultFrac = (Float)TaskManagerOptions.NETWORK_BUFFERS_MEMORY_FRACTION.defaultValue();
        Long defaultMin = (Long)TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MIN.defaultValue();
        Long defaultMax = (Long)TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MAX.defaultValue();
        Assert.assertEquals((long)TaskManagerServicesTest.enforceBounds((long)(defaultFrac.floatValue() * 1.048576E7f), defaultMin, defaultMax), (long)TaskManagerServices.calculateNetworkBufferMemory((long)0x8000000L, (Configuration)config));
        Assert.assertEquals((long)TaskManagerServicesTest.enforceBounds((long)(defaultFrac.floatValue() * 1.0737418E10f), defaultMin, defaultMax), (long)TaskManagerServices.calculateNetworkBufferMemory((long)0x280000000L, (Configuration)config));
        TaskManagerServicesTest.calculateNetworkBufNew(config);
    }

    private static void calculateNetworkBufNew(Configuration config) {
        config.setLong(TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MIN, 0x100000L);
        config.setLong(TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MAX, 0x100000L);
        Assert.assertEquals((long)0x100000L, (long)TaskManagerServices.calculateNetworkBufferMemory((long)0xA00000L, (Configuration)config));
        Assert.assertEquals((long)0x100000L, (long)TaskManagerServices.calculateNetworkBufferMemory((long)0x4000000L, (Configuration)config));
        Assert.assertEquals((long)0x100000L, (long)TaskManagerServices.calculateNetworkBufferMemory((long)0x40000000L, (Configuration)config));
        Random ran = new Random();
        for (int i = 0; i < 1000; ++i) {
            float frac = Math.max(ran.nextFloat(), Float.MIN_VALUE);
            config.setFloat(TaskManagerOptions.NETWORK_BUFFERS_MEMORY_FRACTION, frac);
            long min = Math.max((long)((Integer)TaskManagerOptions.MEMORY_SEGMENT_SIZE.defaultValue()).intValue(), ran.nextLong());
            config.setLong(TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MIN, min);
            long max = Math.max(min, ran.nextLong());
            config.setLong(TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MAX, max);
            long javaMem = Math.max(max + 1L, ran.nextLong());
            long networkBufMem = TaskManagerServices.calculateNetworkBufferMemory((long)javaMem, (Configuration)config);
            Assert.assertTrue((String)("Lower bound not met with configuration: " + config.toString()), (networkBufMem >= min ? 1 : 0) != 0);
            Assert.assertTrue((String)("Upper bound not met with configuration: " + config.toString()), (networkBufMem <= max ? 1 : 0) != 0);
            if (networkBufMem <= min || networkBufMem >= max) continue;
            Assert.assertEquals((String)("Wrong network buffer memory size with configuration: " + config.toString()), (long)((long)((float)javaMem * frac)), (long)networkBufMem);
        }
    }

    @Test
    public void calculateNetworkBufMixed() throws Exception {
        Configuration config = new Configuration();
        config.setInteger(TaskManagerOptions.NETWORK_NUM_BUFFERS, 1);
        Float defaultFrac = (Float)TaskManagerOptions.NETWORK_BUFFERS_MEMORY_FRACTION.defaultValue();
        Long defaultMin = (Long)TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MIN.defaultValue();
        Long defaultMax = (Long)TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MAX.defaultValue();
        Configuration config1 = config.clone();
        config1.setFloat(TaskManagerOptions.NETWORK_BUFFERS_MEMORY_FRACTION, 0.1f);
        Assert.assertEquals((long)TaskManagerServicesTest.enforceBounds(0x100000L, defaultMin, defaultMax), (long)TaskManagerServices.calculateNetworkBufferMemory((long)0x8000000L, (Configuration)config1));
        Assert.assertEquals((long)TaskManagerServicesTest.enforceBounds(0x40000000L, defaultMin, defaultMax), (long)TaskManagerServices.calculateNetworkBufferMemory((long)0x280000000L, (Configuration)config1));
        config1 = config.clone();
        long newMin = ((Integer)TaskManagerOptions.MEMORY_SEGMENT_SIZE.defaultValue()).intValue();
        config1.setLong(TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MIN, newMin);
        Assert.assertEquals((long)TaskManagerServicesTest.enforceBounds((long)(defaultFrac.floatValue() * 1.048576E7f), newMin, defaultMax), (long)TaskManagerServices.calculateNetworkBufferMemory((long)0xA00000L, (Configuration)config1));
        Assert.assertEquals((long)TaskManagerServicesTest.enforceBounds((long)(defaultFrac.floatValue() * 1.0737418E10f), newMin, defaultMax), (long)TaskManagerServices.calculateNetworkBufferMemory((long)0x280000000L, (Configuration)config1));
        config1 = config.clone();
        long newMax = Math.max(0x8000000L, (Long)TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MIN.defaultValue());
        config1.setLong(TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MAX, newMax);
        Assert.assertEquals((long)TaskManagerServicesTest.enforceBounds((long)(defaultFrac.floatValue() * 1.048576E7f), defaultMin, newMax), (long)TaskManagerServices.calculateNetworkBufferMemory((long)0x8000000L, (Configuration)config1));
        Assert.assertEquals((long)TaskManagerServicesTest.enforceBounds((long)(defaultFrac.floatValue() * 1.0737418E10f), defaultMin, newMax), (long)TaskManagerServices.calculateNetworkBufferMemory((long)0x280000000L, (Configuration)config1));
        Assert.assertTrue((boolean)TaskManagerServicesConfiguration.hasNewNetworkBufConf((Configuration)config1));
        TaskManagerServicesTest.calculateNetworkBufNew(config);
    }

    private static long enforceBounds(long value, long lower, long upper) {
        return Math.min(upper, Math.max(lower, value));
    }

    @Test
    public void calculateNetworkBufFromHeapSize() throws Exception {
        PowerMockito.mockStatic(EnvironmentInformation.class, (Class[])new Class[0]);
        PowerMockito.when((Object)EnvironmentInformation.getSizeOfFreeHeapMemoryWithDefrag()).thenReturn((Object)1048576000L);
        PowerMockito.when((Object)EnvironmentInformation.getMaxJvmHeapMemory()).thenReturn((Object)1048576000L);
        TaskManagerServicesConfiguration tmConfig = TaskManagerServicesTest.getTmConfig((Long)TaskManagerOptions.MANAGED_MEMORY_SIZE.defaultValue(), ((Float)TaskManagerOptions.MANAGED_MEMORY_FRACTION.defaultValue()).floatValue(), 0.1f, 0x3C00000L, 0x40000000L, MemoryType.HEAP);
        PowerMockito.when((Object)EnvironmentInformation.getSizeOfFreeHeapMemoryWithDefrag()).thenReturn((Object)1048576000L);
        Assert.assertEquals((long)0x6400000L, (long)TaskManagerServices.calculateNetworkBufferMemory((TaskManagerServicesConfiguration)tmConfig));
        tmConfig = TaskManagerServicesTest.getTmConfig(10L, ((Float)TaskManagerOptions.MANAGED_MEMORY_FRACTION.defaultValue()).floatValue(), 0.1f, 0x3C00000L, 0x40000000L, MemoryType.OFF_HEAP);
        PowerMockito.when((Object)EnvironmentInformation.getMaxJvmHeapMemory()).thenReturn((Object)933232640L);
        Assert.assertEquals((long)104857601L, (long)TaskManagerServices.calculateNetworkBufferMemory((TaskManagerServicesConfiguration)tmConfig));
        tmConfig = TaskManagerServicesTest.getTmConfig(-1L, 0.1f, 0.1f, 0x3C00000L, 0x40000000L, MemoryType.OFF_HEAP);
        PowerMockito.when((Object)EnvironmentInformation.getMaxJvmHeapMemory()).thenReturn((Object)849346560L);
        Assert.assertEquals((long)104857601L, (long)TaskManagerServices.calculateNetworkBufferMemory((TaskManagerServicesConfiguration)tmConfig));
    }

    private static TaskManagerServicesConfiguration getTmConfig(long managedMemory, float managedMemoryFraction, float networkBufFraction, long networkBufMin, long networkBufMax, MemoryType memType) {
        NetworkEnvironmentConfiguration networkConfig = new NetworkEnvironmentConfiguration(networkBufFraction, networkBufMin, networkBufMax, ((Integer)TaskManagerOptions.MEMORY_SEGMENT_SIZE.defaultValue()).intValue(), memType, null, ((Integer)TaskManagerOptions.NETWORK_REQUEST_BACKOFF_INITIAL.defaultValue()).intValue(), ((Integer)TaskManagerOptions.NETWORK_REQUEST_BACKOFF_MAX.defaultValue()).intValue(), ((Integer)TaskManagerOptions.NETWORK_BUFFERS_PER_CHANNEL.defaultValue()).intValue(), ((Integer)TaskManagerOptions.NETWORK_EXTRA_BUFFERS_PER_GATE.defaultValue()).intValue(), null);
        return new TaskManagerServicesConfiguration((InetAddress)Mockito.mock(InetAddress.class), new String[0], networkConfig, QueryableStateConfiguration.disabled(), 1, managedMemory, false, managedMemoryFraction, 0L);
    }

    @Test
    public void calculateHeapSizeMB() throws Exception {
        Configuration config = new Configuration();
        config.setFloat(TaskManagerOptions.NETWORK_BUFFERS_MEMORY_FRACTION, 0.1f);
        config.setLong(TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MIN, 0x4000000L);
        config.setLong(TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MAX, 0x40000000L);
        config.setBoolean(TaskManagerOptions.MEMORY_OFF_HEAP, false);
        Assert.assertEquals((long)1000L, (long)TaskManagerServices.calculateHeapSizeMB((long)1000L, (Configuration)config));
        config.setBoolean(TaskManagerOptions.MEMORY_OFF_HEAP, true);
        config.setLong(TaskManagerOptions.MANAGED_MEMORY_SIZE, 10L);
        Assert.assertEquals((long)890L, (long)TaskManagerServices.calculateHeapSizeMB((long)1000L, (Configuration)config));
        config.setLong(TaskManagerOptions.MANAGED_MEMORY_SIZE, -1L);
        config.setFloat(TaskManagerOptions.MANAGED_MEMORY_FRACTION, 0.1f);
        Assert.assertEquals((long)810L, (long)TaskManagerServices.calculateHeapSizeMB((long)1000L, (Configuration)config));
    }
}

