/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor.slot;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.taskexecutor.slot.TimeoutListener;
import org.apache.flink.runtime.taskexecutor.slot.TimerService;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;
import org.mockito.verification.VerificationMode;

public class TimerServiceTest {
    @Test
    public void testUnregisterAllTimeouts() throws Exception {
        ScheduledExecutorService scheduledExecutorService = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
        ScheduledFuture scheduledFuture = (ScheduledFuture)Mockito.mock(ScheduledFuture.class);
        Mockito.when(scheduledExecutorService.schedule((Runnable)Matchers.any(Runnable.class), Matchers.anyLong(), (TimeUnit)((Object)Matchers.any(TimeUnit.class)))).thenReturn((Object)scheduledFuture);
        TimerService timerService = new TimerService(scheduledExecutorService, 100L);
        TimeoutListener listener = (TimeoutListener)Mockito.mock(TimeoutListener.class);
        timerService.start(listener);
        timerService.registerTimeout((Object)new AllocationID(), 10L, TimeUnit.SECONDS);
        timerService.registerTimeout((Object)new AllocationID(), 10L, TimeUnit.SECONDS);
        timerService.unregisterAllTimeouts();
        Map timeouts = (Map)Whitebox.getInternalState((Object)timerService, (String)"timeouts");
        Assert.assertTrue((boolean)timeouts.isEmpty());
        ((ScheduledFuture)Mockito.verify((Object)scheduledFuture, (VerificationMode)Mockito.times((int)2))).cancel(true);
    }
}

