/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URI;
import java.util.Iterator;
import java.util.concurrent.Executor;
import net.jcip.annotations.NotThreadSafe;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServicesUtils;
import org.apache.flink.runtime.taskmanager.TaskManager;
import org.apache.flink.util.IOUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import scala.Tuple2;

@NotThreadSafe
public class TaskManagerConfigurationTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUsePreconfiguredNetworkInterface() throws Exception {
        String TEST_HOST_NAME = "testhostname";
        Configuration config = new Configuration();
        config.setString("taskmanager.hostname", "testhostname");
        config.setString(JobManagerOptions.ADDRESS, "localhost");
        config.setInteger(JobManagerOptions.PORT, 7891);
        HighAvailabilityServices highAvailabilityServices = HighAvailabilityServicesUtils.createHighAvailabilityServices((Configuration)config, (Executor)Executors.directExecutor(), (HighAvailabilityServicesUtils.AddressResolution)HighAvailabilityServicesUtils.AddressResolution.NO_ADDRESS_RESOLUTION);
        try {
            Tuple2 address = TaskManager.selectNetworkInterfaceAndPortRange((Configuration)config, (HighAvailabilityServices)highAvailabilityServices);
            Assert.assertEquals((Object)"testhostname", (Object)address._1());
        }
        finally {
            highAvailabilityServices.closeAndCleanupAllData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testActorSystemPortConfig() throws Exception {
        Configuration config = new Configuration();
        config.setString("taskmanager.hostname", "localhost");
        config.setString(JobManagerOptions.ADDRESS, "localhost");
        config.setInteger(JobManagerOptions.PORT, 7891);
        HighAvailabilityServices highAvailabilityServices = HighAvailabilityServicesUtils.createHighAvailabilityServices((Configuration)config, (Executor)Executors.directExecutor(), (HighAvailabilityServicesUtils.AddressResolution)HighAvailabilityServicesUtils.AddressResolution.NO_ADDRESS_RESOLUTION);
        try {
            Iterator portsIter = (Iterator)TaskManager.selectNetworkInterfaceAndPortRange((Configuration)config, (HighAvailabilityServices)highAvailabilityServices)._2();
            Assert.assertTrue((boolean)portsIter.hasNext());
            Assert.assertEquals((long)0L, (long)((Integer)portsIter.next()).intValue());
            int testPort = 22551;
            config.setString(TaskManagerOptions.RPC_PORT, String.valueOf(22551));
            portsIter = (Iterator)TaskManager.selectNetworkInterfaceAndPortRange((Configuration)config, (HighAvailabilityServices)highAvailabilityServices)._2();
            Assert.assertTrue((boolean)portsIter.hasNext());
            Assert.assertEquals((long)22551L, (long)((Integer)portsIter.next()).intValue());
            config.setString(TaskManagerOptions.RPC_PORT, "8000-8001");
            portsIter = (Iterator)TaskManager.selectNetworkInterfaceAndPortRange((Configuration)config, (HighAvailabilityServices)highAvailabilityServices)._2();
            Assert.assertTrue((boolean)portsIter.hasNext());
            Assert.assertEquals((long)8000L, (long)((Integer)portsIter.next()).intValue());
            Assert.assertEquals((long)8001L, (long)((Integer)portsIter.next()).intValue());
            try {
                config.setString(TaskManagerOptions.RPC_PORT, "-1");
                TaskManager.selectNetworkInterfaceAndPortRange((Configuration)config, (HighAvailabilityServices)highAvailabilityServices);
                Assert.fail((String)"should fail with an exception");
            }
            catch (IllegalConfigurationException illegalConfigurationException) {
                // empty catch block
            }
            try {
                config.setString(TaskManagerOptions.RPC_PORT, "100000");
                TaskManager.selectNetworkInterfaceAndPortRange((Configuration)config, (HighAvailabilityServices)highAvailabilityServices);
                Assert.fail((String)"should fail with an exception");
            }
            catch (IllegalConfigurationException illegalConfigurationException) {
                // empty catch block
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            highAvailabilityServices.closeAndCleanupAllData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDefaultFsParameterLoading() throws Exception {
        try {
            File tmpDir = this.temporaryFolder.newFolder();
            File confFile = new File(tmpDir, "flink-conf.yaml");
            URI defaultFS = new URI("otherFS", null, "localhost", 1234, null, null, null);
            PrintWriter pw1 = new PrintWriter(confFile);
            pw1.println("fs.default-scheme: " + defaultFS);
            pw1.close();
            String[] args = new String[]{"--configDir:" + tmpDir};
            TaskManager.parseArgsAndLoadConfig((String[])args);
            Assert.assertEquals((Object)defaultFS, (Object)FileSystem.getDefaultFsUri());
        }
        finally {
            FileSystem.initialize((Configuration)new Configuration());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNetworkInterfaceSelection() throws Exception {
        ServerSocket server;
        String hostname = "localhost";
        try {
            InetAddress localhostAddress = InetAddress.getByName(hostname);
            server = new ServerSocket(0, 50, localhostAddress);
        }
        catch (IOException e) {
            System.err.println("Skipping 'testNetworkInterfaceSelection' test.");
            return;
        }
        Configuration config = new Configuration();
        config.setString(JobManagerOptions.ADDRESS, hostname);
        config.setInteger(JobManagerOptions.PORT, server.getLocalPort());
        HighAvailabilityServices highAvailabilityServices = HighAvailabilityServicesUtils.createHighAvailabilityServices((Configuration)config, (Executor)Executors.directExecutor(), (HighAvailabilityServicesUtils.AddressResolution)HighAvailabilityServicesUtils.AddressResolution.NO_ADDRESS_RESOLUTION);
        try {
            Assert.assertNotNull((Object)TaskManager.selectNetworkInterfaceAndPortRange((Configuration)config, (HighAvailabilityServices)highAvailabilityServices)._1());
        }
        finally {
            highAvailabilityServices.closeAndCleanupAllData();
            IOUtils.closeQuietly((AutoCloseable)server);
        }
    }
}

