/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.testutils;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.highavailability.HighAvailabilityServicesUtils;
import org.apache.flink.runtime.jobmanager.JobManager;
import org.apache.flink.runtime.jobmanager.JobManagerMode;
import org.apache.flink.runtime.rpc.akka.AkkaRpcServiceUtils;
import org.apache.flink.runtime.testutils.TestJvmProcess;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.FiniteDuration;

public class JobManagerProcess
extends TestJvmProcess {
    private static final Logger LOG = LoggerFactory.getLogger(JobManagerProcess.class);
    private static final Pattern PORT_PATTERN = Pattern.compile(".*Starting JobManager at akka\\.tcp://flink@.*:(\\d+).*");
    private final int id;
    private final Configuration config;
    private final String[] jvmArgs;
    private int jobManagerPort;
    private ActorRef jobManagerRef;

    public JobManagerProcess(int id, Configuration config) throws Exception {
        Preconditions.checkArgument((id >= 0 ? 1 : 0) != 0, (Object)"Negative ID");
        this.id = id;
        this.config = (Configuration)Preconditions.checkNotNull((Object)config, (String)"Configuration");
        ArrayList<String> args = new ArrayList<String>();
        for (Map.Entry entry : config.toMap().entrySet()) {
            args.add("--" + (String)entry.getKey());
            args.add((String)entry.getValue());
        }
        this.jvmArgs = new String[args.size()];
        args.toArray(this.jvmArgs);
    }

    @Override
    public String getName() {
        return "JobManager " + this.id;
    }

    @Override
    public String[] getJvmArgs() {
        return this.jvmArgs;
    }

    @Override
    public String getEntryPointClassName() {
        return JobManagerProcessEntryPoint.class.getName();
    }

    public Configuration getConfig() {
        return this.config;
    }

    public int getJobManagerPort(FiniteDuration timeout) throws InterruptedException, NumberFormatException {
        if (this.jobManagerPort > 0) {
            return this.jobManagerPort;
        }
        Deadline deadline = timeout.fromNow();
        while (deadline.hasTimeLeft()) {
            Matcher matcher = PORT_PATTERN.matcher(this.getProcessOutput());
            if (matcher.find()) {
                String port = matcher.group(1);
                this.jobManagerPort = Integer.parseInt(port);
                return this.jobManagerPort;
            }
            Thread.sleep(100L);
        }
        throw new RuntimeException("Could not parse port from logs");
    }

    public String getJobManagerAkkaURL(FiniteDuration timeout) throws InterruptedException, UnknownHostException {
        int port = this.getJobManagerPort(timeout);
        return AkkaRpcServiceUtils.getRpcUrl((String)"localhost", (int)port, (String)"jobmanager", (HighAvailabilityServicesUtils.AddressResolution)HighAvailabilityServicesUtils.AddressResolution.NO_ADDRESS_RESOLUTION, (Configuration)this.config);
    }

    public String toString() {
        return String.format("JobManagerProcess(id=%d, port=%d)", this.id, this.jobManagerPort);
    }

    public ActorRef getActorRef(ActorSystem actorSystem, FiniteDuration timeout) throws Exception {
        if (this.jobManagerRef != null) {
            return this.jobManagerRef;
        }
        Preconditions.checkNotNull((Object)actorSystem, (String)"Actor system");
        Deadline deadline = timeout.fromNow();
        while (deadline.hasTimeLeft()) {
            try {
                this.jobManagerRef = AkkaUtils.getActorRef((String)this.getJobManagerAkkaURL(deadline.timeLeft()), (ActorSystem)actorSystem, (FiniteDuration)deadline.timeLeft());
                return this.jobManagerRef;
            }
            catch (Throwable ignored) {
                Thread.sleep(Math.min(100L, deadline.timeLeft().toMillis()));
            }
        }
        throw new IllegalStateException("JobManager did not start up within " + timeout + ".");
    }

    public static class JobManagerProcessEntryPoint {
        private static final Logger LOG = LoggerFactory.getLogger(JobManagerProcessEntryPoint.class);

        public static void main(String[] args) {
            try {
                ParameterTool params = ParameterTool.fromArgs((String[])args);
                Configuration config = params.getConfiguration();
                LOG.info("Configuration: {}.", (Object)config);
                JobManager.runJobManager((Configuration)config, (JobManagerMode)JobManagerMode.CLUSTER, (String)"localhost", (int)0);
                new CountDownLatch(1).await();
            }
            catch (Throwable t) {
                LOG.error("Failed to start JobManager process", t);
                System.exit(1);
            }
        }
    }
}

