/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job.metrics;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.job.metrics.AbstractMetricsHandler;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobIDPathParameter;
import org.apache.flink.runtime.rest.messages.JobVertexIdPathParameter;
import org.apache.flink.runtime.rest.messages.SubtaskIndexPathParameter;
import org.apache.flink.runtime.rest.messages.job.metrics.SubtaskMetricsHeaders;
import org.apache.flink.runtime.rest.messages.job.metrics.SubtaskMetricsMessageParameters;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;

public class SubtaskMetricsHandler
extends AbstractMetricsHandler<SubtaskMetricsMessageParameters> {
    public SubtaskMetricsHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> headers, MetricFetcher metricFetcher) {
        super(localRestAddress, leaderRetriever, timeout, headers, SubtaskMetricsHeaders.getInstance(), metricFetcher);
    }

    @Override
    @Nullable
    protected MetricStore.ComponentMetricStore getComponentMetricStore(HandlerRequest<EmptyRequestBody, SubtaskMetricsMessageParameters> request, MetricStore metricStore) {
        JobID jobId = (JobID)request.getPathParameter(JobIDPathParameter.class);
        JobVertexID vertexId = (JobVertexID)((Object)request.getPathParameter(JobVertexIdPathParameter.class));
        int subtaskIndex = (Integer)request.getPathParameter(SubtaskIndexPathParameter.class);
        return metricStore.getSubtaskMetricStore(jobId.toString(), vertexId.toString(), subtaskIndex);
    }
}

