/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CheckpointRetentionPolicy;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.state.CompletedCheckpointStorageLocation;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.testutils.TestCompletedCheckpointStorageLocation;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public abstract class CompletedCheckpointStoreTest
extends TestLogger {
    protected abstract CompletedCheckpointStore createCompletedCheckpoints(int var1) throws Exception;

    @Test(expected=Exception.class)
    public void testExceptionOnNoRetainedCheckpoints() throws Exception {
        this.createCompletedCheckpoints(0);
    }

    @Test
    public void testAddAndGetLatestCheckpoint() throws Exception {
        SharedStateRegistry sharedStateRegistry = new SharedStateRegistry();
        CompletedCheckpointStore checkpoints = this.createCompletedCheckpoints(4);
        Assert.assertEquals((long)0L, (long)checkpoints.getNumberOfRetainedCheckpoints());
        Assert.assertEquals((long)0L, (long)checkpoints.getAllCheckpoints().size());
        TestCompletedCheckpoint[] expected = new TestCompletedCheckpoint[]{CompletedCheckpointStoreTest.createCheckpoint(0, sharedStateRegistry), CompletedCheckpointStoreTest.createCheckpoint(1, sharedStateRegistry)};
        checkpoints.addCheckpoint((CompletedCheckpoint)expected[0]);
        Assert.assertEquals((long)1L, (long)checkpoints.getNumberOfRetainedCheckpoints());
        this.verifyCheckpoint(expected[0], checkpoints.getLatestCheckpoint());
        checkpoints.addCheckpoint((CompletedCheckpoint)expected[1]);
        Assert.assertEquals((long)2L, (long)checkpoints.getNumberOfRetainedCheckpoints());
        this.verifyCheckpoint(expected[1], checkpoints.getLatestCheckpoint());
    }

    @Test
    public void testAddCheckpointMoreThanMaxRetained() throws Exception {
        SharedStateRegistry sharedStateRegistry = new SharedStateRegistry();
        CompletedCheckpointStore checkpoints = this.createCompletedCheckpoints(1);
        TestCompletedCheckpoint[] expected = new TestCompletedCheckpoint[]{CompletedCheckpointStoreTest.createCheckpoint(0, sharedStateRegistry), CompletedCheckpointStoreTest.createCheckpoint(1, sharedStateRegistry), CompletedCheckpointStoreTest.createCheckpoint(2, sharedStateRegistry), CompletedCheckpointStoreTest.createCheckpoint(3, sharedStateRegistry)};
        checkpoints.addCheckpoint((CompletedCheckpoint)expected[0]);
        Assert.assertEquals((long)1L, (long)checkpoints.getNumberOfRetainedCheckpoints());
        for (int i = 1; i < expected.length; ++i) {
            Collection taskStates = expected[i - 1].getOperatorStates().values();
            checkpoints.addCheckpoint((CompletedCheckpoint)expected[i]);
            expected[i - 1].awaitDiscard();
            Assert.assertTrue((boolean)expected[i - 1].isDiscarded());
            Assert.assertEquals((long)1L, (long)checkpoints.getNumberOfRetainedCheckpoints());
        }
    }

    @Test
    public void testEmptyState() throws Exception {
        CompletedCheckpointStore checkpoints = this.createCompletedCheckpoints(1);
        Assert.assertNull((Object)checkpoints.getLatestCheckpoint());
        Assert.assertEquals((long)0L, (long)checkpoints.getAllCheckpoints().size());
        Assert.assertEquals((long)0L, (long)checkpoints.getNumberOfRetainedCheckpoints());
    }

    @Test
    public void testGetAllCheckpoints() throws Exception {
        TestCompletedCheckpoint[] expected;
        SharedStateRegistry sharedStateRegistry = new SharedStateRegistry();
        CompletedCheckpointStore checkpoints = this.createCompletedCheckpoints(4);
        for (TestCompletedCheckpoint checkpoint : expected = new TestCompletedCheckpoint[]{CompletedCheckpointStoreTest.createCheckpoint(0, sharedStateRegistry), CompletedCheckpointStoreTest.createCheckpoint(1, sharedStateRegistry), CompletedCheckpointStoreTest.createCheckpoint(2, sharedStateRegistry), CompletedCheckpointStoreTest.createCheckpoint(3, sharedStateRegistry)}) {
            checkpoints.addCheckpoint((CompletedCheckpoint)checkpoint);
        }
        List actual = checkpoints.getAllCheckpoints();
        Assert.assertEquals((long)expected.length, (long)actual.size());
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((Object)((Object)expected[i]), actual.get(i));
        }
    }

    @Test
    public void testDiscardAllCheckpoints() throws Exception {
        TestCompletedCheckpoint[] expected;
        SharedStateRegistry sharedStateRegistry = new SharedStateRegistry();
        CompletedCheckpointStore checkpoints = this.createCompletedCheckpoints(4);
        for (TestCompletedCheckpoint checkpoint : expected = new TestCompletedCheckpoint[]{CompletedCheckpointStoreTest.createCheckpoint(0, sharedStateRegistry), CompletedCheckpointStoreTest.createCheckpoint(1, sharedStateRegistry), CompletedCheckpointStoreTest.createCheckpoint(2, sharedStateRegistry), CompletedCheckpointStoreTest.createCheckpoint(3, sharedStateRegistry)}) {
            checkpoints.addCheckpoint((CompletedCheckpoint)checkpoint);
        }
        checkpoints.shutdown(JobStatus.FINISHED);
        Assert.assertNull((Object)checkpoints.getLatestCheckpoint());
        Assert.assertEquals((long)0L, (long)checkpoints.getAllCheckpoints().size());
        Assert.assertEquals((long)0L, (long)checkpoints.getNumberOfRetainedCheckpoints());
        for (TestCompletedCheckpoint checkpoint : expected) {
            checkpoint.awaitDiscard();
            Assert.assertTrue((boolean)checkpoint.isDiscarded());
        }
    }

    public static TestCompletedCheckpoint createCheckpoint(int id, SharedStateRegistry sharedStateRegistry) throws IOException {
        int numberOfStates = 4;
        CheckpointProperties props = CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION);
        OperatorID operatorID = new OperatorID();
        HashMap<OperatorID, OperatorState> operatorGroupState = new HashMap<OperatorID, OperatorState>();
        OperatorState operatorState = new OperatorState(operatorID, numberOfStates, numberOfStates);
        operatorGroupState.put(operatorID, operatorState);
        for (int i = 0; i < numberOfStates; ++i) {
            TestOperatorSubtaskState subtaskState = new TestOperatorSubtaskState();
            operatorState.putState(i, (OperatorSubtaskState)subtaskState);
        }
        operatorState.registerSharedStates(sharedStateRegistry);
        return new TestCompletedCheckpoint(new JobID(), id, 0L, operatorGroupState, props);
    }

    protected void verifyCheckpointRegistered(Collection<OperatorState> operatorStates, SharedStateRegistry registry) {
        for (OperatorState operatorState : operatorStates) {
            for (OperatorSubtaskState subtaskState : operatorState.getStates()) {
                Assert.assertTrue((boolean)((TestOperatorSubtaskState)subtaskState).registered);
            }
        }
    }

    public static void verifyCheckpointDiscarded(TestCompletedCheckpoint completedCheckpoint) {
        Assert.assertTrue((boolean)completedCheckpoint.isDiscarded());
        CompletedCheckpointStoreTest.verifyCheckpointDiscarded(completedCheckpoint.getOperatorStates().values());
    }

    protected static void verifyCheckpointDiscarded(Collection<OperatorState> operatorStates) {
        for (OperatorState operatorState : operatorStates) {
            for (OperatorSubtaskState subtaskState : operatorState.getStates()) {
                Assert.assertTrue((boolean)((TestOperatorSubtaskState)subtaskState).discarded);
            }
        }
    }

    private void verifyCheckpoint(CompletedCheckpoint expected, CompletedCheckpoint actual) {
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public static class TestOperatorSubtaskState
    extends OperatorSubtaskState {
        private static final long serialVersionUID = 522580433699164230L;
        boolean registered = false;
        boolean discarded = false;

        public void discardState() {
            super.discardState();
            Assert.assertFalse((boolean)this.discarded);
            this.discarded = true;
            this.registered = false;
        }

        public void registerSharedStates(SharedStateRegistry sharedStateRegistry) {
            super.registerSharedStates(sharedStateRegistry);
            Assert.assertFalse((boolean)this.discarded);
            this.registered = true;
        }

        public void reset() {
            this.registered = false;
            this.discarded = false;
        }

        public boolean isRegistered() {
            return this.registered;
        }

        public boolean isDiscarded() {
            return this.discarded;
        }
    }

    protected static class TestCompletedCheckpoint
    extends CompletedCheckpoint {
        private static final long serialVersionUID = 4211419809665983026L;
        private boolean isDiscarded;
        private final transient CountDownLatch discardLatch = new CountDownLatch(1);

        public TestCompletedCheckpoint(JobID jobId, long checkpointId, long timestamp, Map<OperatorID, OperatorState> operatorGroupState, CheckpointProperties props) {
            super(jobId, checkpointId, timestamp, Long.MAX_VALUE, operatorGroupState, null, props, (CompletedCheckpointStorageLocation)new TestCompletedCheckpointStorageLocation());
        }

        public boolean discardOnSubsume() throws Exception {
            if (super.discardOnSubsume()) {
                this.discard();
                return true;
            }
            return false;
        }

        public boolean discardOnShutdown(JobStatus jobStatus) throws Exception {
            if (super.discardOnShutdown(jobStatus)) {
                this.discard();
                return true;
            }
            return false;
        }

        void discard() {
            if (!this.isDiscarded) {
                this.isDiscarded = true;
                if (this.discardLatch != null) {
                    this.discardLatch.countDown();
                }
            }
        }

        public boolean isDiscarded() {
            return this.isDiscarded;
        }

        public void awaitDiscard() throws InterruptedException {
            if (this.discardLatch != null) {
                this.discardLatch.await();
            }
        }

        public boolean awaitDiscard(long timeout) throws InterruptedException {
            if (this.discardLatch != null) {
                return this.discardLatch.await(timeout, TimeUnit.MILLISECONDS);
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            TestCompletedCheckpoint that = (TestCompletedCheckpoint)((Object)o);
            return this.getJobId().equals((Object)that.getJobId()) && this.getCheckpointID() == that.getCheckpointID();
        }

        public int hashCode() {
            return this.getJobId().hashCode() + (int)this.getCheckpointID();
        }
    }
}

