/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.Collections;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.blob.BlobWriter;
import org.apache.flink.runtime.blob.VoidBlobWriter;
import org.apache.flink.runtime.checkpoint.CheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.CheckpointRetentionPolicy;
import org.apache.flink.runtime.checkpoint.CheckpointStatsTrackerTest;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.executiongraph.DummyJobInformation;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.JobInformation;
import org.apache.flink.runtime.executiongraph.failover.FailoverStrategy;
import org.apache.flink.runtime.executiongraph.failover.RestartAllStrategy;
import org.apache.flink.runtime.executiongraph.restart.NoRestartStrategy;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategy;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.jobmanager.scheduler.Scheduler;
import org.apache.flink.runtime.jobmaster.slotpool.SlotProvider;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.memory.MemoryStateBackend;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ExecutionGraphCheckpointCoordinatorTest {
    @Test
    public void testShutdownCheckpointCoordinator() throws Exception {
        CheckpointIDCounter counter = (CheckpointIDCounter)Mockito.mock(CheckpointIDCounter.class);
        CompletedCheckpointStore store = (CompletedCheckpointStore)Mockito.mock(CompletedCheckpointStore.class);
        ExecutionGraph graph = this.createExecutionGraphAndEnableCheckpointing(counter, store);
        graph.failGlobal((Throwable)new Exception("Test Exception"));
        ((CheckpointIDCounter)Mockito.verify((Object)counter, (VerificationMode)Mockito.times((int)1))).shutdown(JobStatus.FAILED);
        ((CompletedCheckpointStore)Mockito.verify((Object)store, (VerificationMode)Mockito.times((int)1))).shutdown((JobStatus)Matchers.eq((Object)JobStatus.FAILED));
    }

    @Test
    public void testSuspendCheckpointCoordinator() throws Exception {
        CheckpointIDCounter counter = (CheckpointIDCounter)Mockito.mock(CheckpointIDCounter.class);
        CompletedCheckpointStore store = (CompletedCheckpointStore)Mockito.mock(CompletedCheckpointStore.class);
        ExecutionGraph graph = this.createExecutionGraphAndEnableCheckpointing(counter, store);
        graph.suspend((Throwable)new Exception("Test Exception"));
        ((CheckpointIDCounter)Mockito.verify((Object)counter, (VerificationMode)Mockito.times((int)1))).shutdown((JobStatus)Matchers.eq((Object)JobStatus.SUSPENDED));
        ((CompletedCheckpointStore)Mockito.verify((Object)store, (VerificationMode)Mockito.times((int)1))).shutdown((JobStatus)Matchers.eq((Object)JobStatus.SUSPENDED));
    }

    private ExecutionGraph createExecutionGraphAndEnableCheckpointing(CheckpointIDCounter counter, CompletedCheckpointStore store) throws Exception {
        Time timeout = Time.days((long)1L);
        ExecutionGraph executionGraph = new ExecutionGraph((JobInformation)new DummyJobInformation(), TestingUtils.defaultExecutor(), (Executor)TestingUtils.defaultExecutor(), timeout, (RestartStrategy)new NoRestartStrategy(), (FailoverStrategy.Factory)new RestartAllStrategy.Factory(), (SlotProvider)new Scheduler((Executor)TestingUtils.defaultExecutionContext()), ClassLoader.getSystemClassLoader(), (BlobWriter)VoidBlobWriter.getInstance(), timeout);
        executionGraph.enableCheckpointing(100L, 100L, 100L, 1, CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), counter, store, (StateBackend)new MemoryStateBackend(), CheckpointStatsTrackerTest.createTestTracker());
        JobVertex jobVertex = new JobVertex("MockVertex");
        jobVertex.setInvokableClass(AbstractInvokable.class);
        executionGraph.attachJobGraph(Collections.singletonList(jobVertex));
        return executionGraph;
    }
}

