/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.List;
import javax.annotation.Nonnull;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStoreTest;
import org.apache.flink.runtime.checkpoint.TestingRetrievableStateStorageHelper;
import org.apache.flink.runtime.checkpoint.ZooKeeperCompletedCheckpointStore;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.runtime.zookeeper.ZooKeeperResource;
import org.apache.flink.shaded.curator.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class ZooKeeperCompletedCheckpointStoreTest
extends TestLogger {
    @ClassRule
    public static ZooKeeperResource zooKeeperResource = new ZooKeeperResource();

    @Test
    public void testPathConversion() {
        long checkpointId = 42L;
        String path = ZooKeeperCompletedCheckpointStore.checkpointIdToPath((long)42L);
        Assert.assertEquals((long)42L, (long)ZooKeeperCompletedCheckpointStore.pathToCheckpointId((String)path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDiscardingSubsumedCheckpoints() throws Exception {
        SharedStateRegistry sharedStateRegistry = new SharedStateRegistry();
        Configuration configuration = new Configuration();
        configuration.setString(HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM, zooKeeperResource.getConnectString());
        CuratorFramework client = ZooKeeperUtils.startCuratorFramework((Configuration)configuration);
        ZooKeeperCompletedCheckpointStore checkpointStore = this.createZooKeeperCheckpointStore(client);
        try {
            CompletedCheckpointStoreTest.TestCompletedCheckpoint checkpoint1 = CompletedCheckpointStoreTest.createCheckpoint(0, sharedStateRegistry);
            checkpointStore.addCheckpoint((CompletedCheckpoint)checkpoint1);
            Assert.assertThat((Object)checkpointStore.getAllCheckpoints(), (Matcher)Matchers.contains((Object[])new CompletedCheckpoint[]{checkpoint1}));
            CompletedCheckpointStoreTest.TestCompletedCheckpoint checkpoint2 = CompletedCheckpointStoreTest.createCheckpoint(1, sharedStateRegistry);
            checkpointStore.addCheckpoint((CompletedCheckpoint)checkpoint2);
            List allCheckpoints = checkpointStore.getAllCheckpoints();
            Assert.assertThat((Object)allCheckpoints, (Matcher)Matchers.contains((Object[])new CompletedCheckpoint[]{checkpoint2}));
            Assert.assertThat((Object)allCheckpoints, (Matcher)Matchers.not((Matcher)Matchers.contains((Object[])new CompletedCheckpoint[]{checkpoint1})));
            CompletedCheckpointStoreTest.verifyCheckpointDiscarded(checkpoint1);
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDiscardingCheckpointsAtShutDown() throws Exception {
        SharedStateRegistry sharedStateRegistry = new SharedStateRegistry();
        Configuration configuration = new Configuration();
        configuration.setString(HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM, zooKeeperResource.getConnectString());
        CuratorFramework client = ZooKeeperUtils.startCuratorFramework((Configuration)configuration);
        ZooKeeperCompletedCheckpointStore checkpointStore = this.createZooKeeperCheckpointStore(client);
        try {
            CompletedCheckpointStoreTest.TestCompletedCheckpoint checkpoint1 = CompletedCheckpointStoreTest.createCheckpoint(0, sharedStateRegistry);
            checkpointStore.addCheckpoint((CompletedCheckpoint)checkpoint1);
            Assert.assertThat((Object)checkpointStore.getAllCheckpoints(), (Matcher)Matchers.contains((Object[])new CompletedCheckpoint[]{checkpoint1}));
            checkpointStore.shutdown(JobStatus.FINISHED);
            CompletedCheckpointStoreTest.verifyCheckpointDiscarded(checkpoint1);
        }
        finally {
            client.close();
        }
    }

    @Nonnull
    private ZooKeeperCompletedCheckpointStore createZooKeeperCheckpointStore(CuratorFramework client) throws Exception {
        return new ZooKeeperCompletedCheckpointStore(1, client, "/checkpoints", new TestingRetrievableStateStorageHelper(), Executors.directExecutor());
    }
}

