/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.savepoint;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.checkpoint.savepoint.CheckpointTestUtils;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointV1;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointV1Serializer;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointV2;
import org.junit.Assert;
import org.junit.Test;

public class SavepointV1SerializerTest {
    @Test
    public void testSerializeDeserializeV1() throws Exception {
        Random r = new Random(42L);
        for (int i = 0; i < 50; ++i) {
            SavepointV1 expected = new SavepointV1((long)(i + 123123), CheckpointTestUtils.createTaskStates(r, 1 + r.nextInt(64), 1 + r.nextInt(64)));
            SavepointV1Serializer serializer = SavepointV1Serializer.INSTANCE;
            ByteArrayOutputStreamWithPos baos = new ByteArrayOutputStreamWithPos();
            serializer.serializeOld(expected, (DataOutputStream)new DataOutputViewStreamWrapper((OutputStream)baos));
            byte[] bytes = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            SavepointV2 actual = serializer.deserialize((DataInputStream)new DataInputViewStreamWrapper((InputStream)bais), Thread.currentThread().getContextClassLoader());
            Assert.assertEquals((long)expected.getCheckpointId(), (long)actual.getCheckpointId());
            Assert.assertEquals((Object)expected.getTaskStates(), (Object)actual.getTaskStates());
            Assert.assertTrue((boolean)actual.getMasterStates().isEmpty());
        }
    }
}

